/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.swing.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.axis2.tool.service.bean.ClassFileSelectionBean;
import org.apache.axis2.tool.service.bean.WizardBean;
import org.apache.axis2.tool.service.swing.ui.WizardPane;

public class WizardPane1
extends WizardPane {
    private ClassFileSelectionBean myBean = null;
    private JLabel classFileLocationLabel;
    private JTextField classFileLocationTextBox;
    private JButton browseButton;

    public WizardPane1(WizardBean wizardBean, JFrame ownerFrame) {
        super(ownerFrame);
        this.init();
        if (wizardBean.getPage1bean() != null) {
            this.myBean = wizardBean.getPage1bean();
            this.classFileLocationTextBox.setText(this.myBean.getFileLocation());
        } else {
            this.myBean = new ClassFileSelectionBean();
            wizardBean.setPage1bean(this.myBean);
        }
    }

    public boolean validateValues() {
        String text = this.myBean.getFileLocation();
        return text != null && text.trim().length() > 0;
    }

    private void init() {
        this.setLayout(null);
        this.setSize(this.width, this.height);
        this.initDescription("Welcome to the new AXIS Service packager Wizard Interface.\n\n Insert the location for the class files here.This should be a folder with \n the compiled classes");
        this.classFileLocationLabel = new JLabel("class file location");
        this.add(this.classFileLocationLabel);
        this.classFileLocationLabel.setBounds(this.hgap, this.descHeight, 100, 20);
        this.classFileLocationTextBox = new JTextField();
        this.add(this.classFileLocationTextBox);
        this.classFileLocationTextBox.setBounds(100 + 2 * this.hgap, this.descHeight, 250, 20);
        this.classFileLocationTextBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardPane1.this.handleTextBoxChange();
            }
        });
        this.classFileLocationTextBox.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                WizardPane1.this.handleTextBoxChange();
            }
        });
        this.browseButton = new JButton(".");
        this.add(this.browseButton);
        this.browseButton.setBounds(100 + 2 * this.hgap + 250, this.descHeight, 20, 20);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardPane1.this.classFileLocationTextBox.setText(WizardPane1.this.browseForAFolder());
                WizardPane1.this.handleTextBoxChange();
            }
        });
    }

    private void handleTextBoxChange() {
        String text = this.classFileLocationTextBox.getText();
        if (text != null) {
            this.myBean.setFileLocation(text);
        }
    }
}

