/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import org.apache.axis2.tool.service.bean.Page3Bean;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.ui.AbstractServiceWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServiceArchiveOutputLocationPage
extends AbstractServiceWizardPage {
    private static final String DEFAULT_JAR_NAME = "my_service";
    private Text outputFileLocationTextBox;
    private Button browseButton;
    private Text outputFileNameTextbox;
    private boolean isWizardComplete = false;

    public ServiceArchiveOutputLocationPage() {
        super("page4");
    }

    protected void initializeDefaultSettings() {
        this.settings.put("OUT_LOCATION", System.getProperty("user.dir"));
        this.settings.put("OUT_NAME", DEFAULT_JAR_NAME);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        Label lable = new Label(container, 0);
        lable.setText(ServiceArchiver.getResourceString("page4.outputlocation.label"));
        this.outputFileLocationTextBox = new Text(container, 2048);
        this.outputFileLocationTextBox.setLayoutData((Object)gd);
        this.outputFileLocationTextBox.setText("");
        this.outputFileLocationTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceArchiveOutputLocationPage.this.handleLocationModification();
            }
        });
        gd = new GridData(128);
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(ServiceArchiver.getResourceString("general.browse"));
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ServiceArchiveOutputLocationPage.this.handleBrowse();
            }
        });
        lable = new Label(container, 0);
        lable.setText(ServiceArchiver.getResourceString("page4.outputname.label"));
        gd = new GridData(768);
        this.outputFileNameTextbox = new Text(container, 2048);
        this.outputFileNameTextbox.setLayoutData((Object)gd);
        this.outputFileNameTextbox.setText(this.settings.get("OUT_NAME"));
        this.outputFileNameTextbox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceArchiveOutputLocationPage.this.handleFileNameModification();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Label fillLable = new Label(container, 0);
        fillLable.setText("");
        fillLable.setLayoutData((Object)gd);
        Label fillLable1 = new Label(container, 0);
        fillLable1.setText("");
        fillLable1.setLayoutData((Object)gd);
        Label hintLable = new Label(container, 0);
        hintLable.setText(ServiceArchiver.getResourceString("page4.hint.caption"));
        hintLable.setLayoutData((Object)gd);
        if (this.restoredFromPreviousSettings) {
            this.handleFileNameModification();
            this.handleLocationModification();
        }
        this.setControl((Control)container);
    }

    private void handleBrowse() {
        DirectoryDialog dirDialog = new DirectoryDialog(this.getShell());
        dirDialog.setMessage(ServiceArchiver.getResourceString("page4.dirdialog.caption"));
        String returnText = dirDialog.open();
        if (returnText != null) {
            this.outputFileLocationTextBox.setText(returnText);
            this.outputFileLocationTextBox.setToolTipText(returnText);
        }
    }

    private void handleLocationModification() {
        String outputLocationText = this.outputFileLocationTextBox.getText();
        this.settings.put("OUT_LOCATION", outputLocationText);
        if (outputLocationText == null || "".equals(outputLocationText.trim())) {
            this.updateStatus(ServiceArchiver.getResourceString("page4.error.location"));
            this.isWizardComplete = false;
            this.updateStatus(null);
        } else {
            String outputFilenameText = this.outputFileNameTextbox.getText();
            this.settings.put("OUT_NAME", outputFilenameText);
            if (outputFilenameText == null || "".equals(outputFilenameText.trim())) {
                this.updateStatus(ServiceArchiver.getResourceString("page4.error.filename"));
                this.isWizardComplete = false;
                this.updateStatus(null);
            } else {
                this.isWizardComplete = true;
                this.updateStatus(null);
            }
        }
    }

    private void handleFileNameModification() {
        String outputFilenameText = this.outputFileNameTextbox.getText();
        this.settings.put("OUT_NAME", outputFilenameText);
        if (outputFilenameText == null || "".equals(outputFilenameText.trim())) {
            this.updateStatus(ServiceArchiver.getResourceString("page4.error.filename"));
            this.isWizardComplete = false;
            this.updateStatus(null);
        } else {
            String outputLocationText = this.outputFileLocationTextBox.getText();
            this.settings.put("OUT_LOCATION", outputLocationText);
            if (outputLocationText == null || "".equals(outputLocationText.trim())) {
                this.updateStatus(ServiceArchiver.getResourceString("page4.error.location"));
                this.isWizardComplete = false;
                this.updateStatus(null);
            } else {
                this.isWizardComplete = true;
                this.updateStatus(null);
            }
        }
    }

    public Page3Bean getBean() {
        Page3Bean pageBean = new Page3Bean();
        pageBean.setOutputFolderName(this.outputFileLocationTextBox.getText().trim());
        pageBean.setOutputFileName(this.outputFileNameTextbox.getText().trim());
        return pageBean;
    }

    protected boolean getWizardComplete() {
        return this.isWizardComplete;
    }
}

