/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
//
// Generated By:JAX-WS RI IBM 2.1.1 in JDK 6 (JAXB RI IBM JAXB 2.1.3 in JDK 1.6)
//


package org.apache.axis2.jaxws.sample.asyncdoclit.client;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;

@WebServiceClient(name = "AsyncService", targetNamespace = "http://org/test/asyncdoclit", wsdlLocation = "async_doclitwr2.wsdl")
public class AsyncService
    extends Service
{

    private final static URL ASYNCSERVICE_WSDL_LOCATION;
    private static String wsdlLocation="/test/org/apache/axis2/jaxws/sample/asyncdoclit/server/META-INF/async_doclitwr2.wsdl";
    static {
        URL url = null;
        try {
            try{
                String baseDir = new File(System.getProperty("basedir",".")).getCanonicalPath();
                wsdlLocation = new File(baseDir + wsdlLocation).getAbsolutePath();
            }catch(Exception e){
                e.printStackTrace();
            }
            File file = new File(wsdlLocation);
            url = file.toURI().toURL();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ASYNCSERVICE_WSDL_LOCATION = url;
    }

    public AsyncService(URL wsdlLocation, QName serviceName) {
        super(wsdlLocation, serviceName);
    }

    public AsyncService() {
        super(ASYNCSERVICE_WSDL_LOCATION, new QName("http://org/test/asyncdoclit", "AsyncService"));
    }

    /**
     * 
     * @return
     *     returns AsyncPort
     */
    @WebEndpoint(name = "AsyncPort")
    public AsyncPort getAsyncPort() {
        return (AsyncPort)super.getPort(new QName("http://org/test/asyncdoclit", "AsyncPort"), AsyncPort.class);
    }

    /**
     * 
     * @param features
     *     A list of {@link javax.xml.ws.WebServiceFeature} to configure on the proxy.  Supported features not in the <code>features</code> parameter will have their default values.
     * @return
     *     returns AsyncPort
     */
    @WebEndpoint(name = "AsyncPort")
    public AsyncPort getAsyncPort(WebServiceFeature... features) {
        return (AsyncPort)super.getPort(new QName("http://org/test/asyncdoclit", "AsyncPort"), AsyncPort.class, features);
    }

}
