/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.codegen.eclipse.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

public class ClassFileReader {
    public static boolean tryLoadingClass(String className, String[] classPathEntries, List errorListener) {
        ClassLoader classLoader;
        if (classPathEntries.length > 0) {
            final URL[] urls = new URL[classPathEntries.length];
            try {
                for (int i = 0; i < classPathEntries.length; ++i) {
                    String classPathEntry = classPathEntries[i];
                    urls[i] = classPathEntry.startsWith("http://") ? new URL(classPathEntry) : new File(classPathEntry).toURL();
                }
            }
            catch (MalformedURLException e) {
                if (errorListener != null) {
                    errorListener.add(e);
                }
                return false;
            }
            classLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

                @Override
                public URLClassLoader run() {
                    return new URLClassLoader(urls);
                }
            });
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(className);
            clazz.getMethods();
        }
        catch (Throwable t) {
            if (errorListener != null) {
                errorListener.add(t);
            }
            return false;
        }
        return true;
    }
}

