/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.udp.UDPOutTransportInfo;
import org.apache.axis2.util.MessageProcessorSelector;
import org.apache.commons.logging.LogFactory;

public class UDPSender
extends AbstractTransportSender {
    public UDPSender() {
        this.log = LogFactory.getLog(UDPSender.class);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgContext, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        UDPOutTransportInfo udpOutInfo = targetEPR == null && outTransportInfo != null ? (UDPOutTransportInfo)outTransportInfo : new UDPOutTransportInfo(targetEPR);
        MessageFormatter messageFormatter = MessageProcessorSelector.getMessageFormatter((MessageContext)msgContext);
        OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgContext);
        format.setContentType(udpOutInfo.getContentType());
        byte[] payload = messageFormatter.getBytes(msgContext, format);
        try {
            DatagramSocket socket = new DatagramSocket();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending " + payload.length + " bytes to " + udpOutInfo.getAddress()));
            }
            try {
                socket.send(new DatagramPacket(payload, payload.length, udpOutInfo.getAddress()));
                if (!msgContext.getOptions().isUseSeparateListener() && !msgContext.isServerSide()) {
                    this.waitForReply(msgContext, socket, udpOutInfo.getContentType());
                }
            }
            finally {
                socket.close();
            }
        }
        catch (IOException ex) {
            throw new AxisFault("Unable to send packet", (Throwable)ex);
        }
    }

    private void waitForReply(MessageContext messageContext, DatagramSocket datagramSocket, String contentType) throws IOException {
        if (!(messageContext.getAxisOperation() instanceof OutInAxisOperation) && messageContext.getProperty("piggybackMessage") == null) {
            return;
        }
        byte[] inputBuffer = new byte[4096];
        DatagramPacket packet = new DatagramPacket(inputBuffer, inputBuffer.length);
        datagramSocket.receive(packet);
        try {
            MessageContext respMessageContext = messageContext.getOperationContext().getMessageContext("In");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(inputBuffer, 0, packet.getLength());
            SOAPEnvelope envelope = TransportUtils.createSOAPMessage((MessageContext)respMessageContext, (InputStream)inputStream, (String)contentType);
            respMessageContext.setEnvelope(envelope);
        }
        catch (XMLStreamException e) {
            throw new AxisFault("Can not build the soap message ", (Throwable)e);
        }
    }
}

