/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.transport.base.AbstractTransportListener;
import org.apache.axis2.transport.base.TransportListenerEndpointViewMBean;

public class TransportListenerEndpointView
implements TransportListenerEndpointViewMBean {
    private final AbstractTransportListener listener;
    private final String serviceName;

    public TransportListenerEndpointView(AbstractTransportListener listener, String serviceName) {
        this.listener = listener;
        this.serviceName = serviceName;
    }

    public String[] getAddresses() {
        EndpointReference[] epr;
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            hostname = "localhost";
        }
        try {
            epr = this.listener.getEPRsForService(this.serviceName, hostname);
        }
        catch (AxisFault ex) {
            return null;
        }
        if (epr == null) {
            return null;
        }
        String[] result = new String[epr.length];
        for (int i = 0; i < epr.length; ++i) {
            result[i] = epr[i].getAddress();
        }
        return result;
    }
}

