/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.websocketx;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketUtil;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketVersion;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class WebSocketServerHandshaker00
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker00.class);

    public WebSocketServerHandshaker00(String webSocketURL, String subprotocols) {
        this(webSocketURL, subprotocols, Long.MAX_VALUE);
    }

    public WebSocketServerHandshaker00(String webSocketURL, String subprotocols, long maxFramePayloadLength) {
        super(WebSocketVersion.V00, webSocketURL, subprotocols, maxFramePayloadLength);
    }

    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 00 server handshake", channel.getId()));
        }
        if (!"Upgrade".equalsIgnoreCase(req.getHeader("Connection")) || !"WebSocket".equalsIgnoreCase(req.getHeader("Upgrade"))) {
            throw new WebSocketHandshakeException("not a WebSocket handshake request: missing upgrade");
        }
        boolean isHixie76 = req.containsHeader("Sec-WebSocket-Key1") && req.containsHeader("Sec-WebSocket-Key2");
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, isHixie76 ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"));
        res.addHeader("Upgrade", "WebSocket");
        res.addHeader("Connection", "Upgrade");
        if (isHixie76) {
            res.addHeader("Sec-WebSocket-Origin", req.getHeader("Origin"));
            res.addHeader("Sec-WebSocket-Location", this.getWebSocketUrl());
            String subprotocols = req.getHeader("Sec-WebSocket-Protocol");
            if (subprotocols != null) {
                String selectedSubprotocol = this.selectSubprotocol(subprotocols);
                if (selectedSubprotocol == null) {
                    throw new WebSocketHandshakeException("Requested subprotocol(s) not supported: " + subprotocols);
                }
                res.addHeader("Sec-WebSocket-Protocol", selectedSubprotocol);
                this.setSelectedSubprotocol(selectedSubprotocol);
            }
            String key1 = req.getHeader("Sec-WebSocket-Key1");
            String key2 = req.getHeader("Sec-WebSocket-Key2");
            int a = (int)(Long.parseLong(key1.replaceAll("[^0-9]", "")) / (long)key1.replaceAll("[^ ]", "").length());
            int b = (int)(Long.parseLong(key2.replaceAll("[^0-9]", "")) / (long)key2.replaceAll("[^ ]", "").length());
            long c = req.getContent().readLong();
            ChannelBuffer input = ChannelBuffers.buffer(16);
            input.writeInt(a);
            input.writeInt(b);
            input.writeLong(c);
            res.setContent(WebSocketUtil.md5(input));
        } else {
            res.addHeader("WebSocket-Origin", req.getHeader("Origin"));
            res.addHeader("WebSocket-Location", this.getWebSocketUrl());
            String protocol = req.getHeader("WebSocket-Protocol");
            if (protocol != null) {
                res.addHeader("WebSocket-Protocol", this.selectSubprotocol(protocol));
            }
        }
        ChannelFuture future = channel.write(res);
        future.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                ChannelPipeline p = future.getChannel().getPipeline();
                if (p.get(HttpChunkAggregator.class) != null) {
                    p.remove(HttpChunkAggregator.class);
                }
                p.replace(HttpRequestDecoder.class, "wsdecoder", (ChannelHandler)new WebSocket00FrameDecoder(WebSocketServerHandshaker00.this.getMaxFramePayloadLength()));
                p.replace(HttpResponseEncoder.class, "wsencoder", (ChannelHandler)new WebSocket00FrameEncoder());
            }
        });
        return future;
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        return channel.write(frame);
    }
}

