/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class GraphiteSink
implements MetricsSink,
Closeable {
    private static final Log LOG = LogFactory.getLog(GraphiteSink.class);
    private static final String SERVER_HOST_KEY = "server_host";
    private static final String SERVER_PORT_KEY = "server_port";
    private static final String METRICS_PREFIX = "metrics_prefix";
    private Writer writer = null;
    private String metricsPrefix = null;
    private Socket socket = null;

    @Override
    public void init(SubsetConfiguration conf) {
        String serverHost = conf.getString(SERVER_HOST_KEY);
        Integer serverPort = Integer.parseInt(conf.getString(SERVER_PORT_KEY));
        this.metricsPrefix = conf.getString(METRICS_PREFIX);
        if (this.metricsPrefix == null) {
            this.metricsPrefix = "";
        }
        try {
            this.socket = new Socket(serverHost, (int)serverPort);
            this.writer = new OutputStreamWriter(this.socket.getOutputStream());
        }
        catch (Exception e) {
            throw new MetricsException("Error creating connection, " + serverHost + ":" + serverPort, e);
        }
    }

    @Override
    public void putMetrics(MetricsRecord record) {
        StringBuilder lines = new StringBuilder();
        StringBuilder metricsPathPrefix = new StringBuilder();
        metricsPathPrefix.append(this.metricsPrefix).append(".").append(record.context()).append(".").append(record.name());
        for (MetricsTag tag : record.tags()) {
            if (tag.value() == null) continue;
            metricsPathPrefix.append(".");
            metricsPathPrefix.append(tag.name());
            metricsPathPrefix.append("=");
            metricsPathPrefix.append(tag.value());
        }
        int timestamp = Math.round((float)record.timestamp() / 1000.0f);
        for (AbstractMetric metric : record.metrics()) {
            lines.append(metricsPathPrefix.toString() + "." + metric.name().replace(' ', '.')).append(" ").append(metric.value()).append(" ").append(timestamp).append("\n");
        }
        try {
            if (this.writer == null) {
                throw new MetricsException("Writer in GraphiteSink is null!");
            }
            this.writer.write(lines.toString());
        }
        catch (Exception e) {
            throw new MetricsException("Error sending metrics", e);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            throw new MetricsException("Error flushing metrics", e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.closeStream(this.writer);
            this.writer = null;
            LOG.info("writer in GraphiteSink is closed!");
        }
        catch (Throwable e) {
            throw new MetricsException("Error closing writer", e);
        }
        finally {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
                this.socket = null;
                LOG.info("socket in GraphiteSink is closed!");
            }
        }
    }
}

