/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.security.client;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;

public class ClientHSTokenSelector
implements TokenSelector<MRDelegationTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(ClientHSTokenSelector.class);

    @Override
    public Token<MRDelegationTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug("Looking for a token with service " + service.toString());
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Token kind is " + token.getKind().toString() + " and the token's service name is " + token.getService());
            }
            if (!MRDelegationTokenIdentifier.KIND_NAME.equals(token.getKind()) || !service.equals(token.getService())) continue;
            return token;
        }
        return null;
    }
}

