/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmitted;
import org.apache.hadoop.security.authorize.AccessControlList;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobSubmittedEvent
implements HistoryEvent {
    private JobSubmitted datum = new JobSubmitted();

    public JobSubmittedEvent(JobID id, String jobName, String userName, long submitTime, String jobConfPath, Map<JobACL, AccessControlList> jobACLs, String jobQueueName) {
        this(id, jobName, userName, submitTime, jobConfPath, jobACLs, jobQueueName, "", "", "", "");
    }

    public JobSubmittedEvent(JobID id, String jobName, String userName, long submitTime, String jobConfPath, Map<JobACL, AccessControlList> jobACLs, String jobQueueName, String workflowId, String workflowName, String workflowNodeName, String workflowAdjacencies) {
        this(id, jobName, userName, submitTime, jobConfPath, jobACLs, jobQueueName, workflowId, workflowName, workflowNodeName, workflowAdjacencies, "");
    }

    public JobSubmittedEvent(JobID id, String jobName, String userName, long submitTime, String jobConfPath, Map<JobACL, AccessControlList> jobACLs, String jobQueueName, String workflowId, String workflowName, String workflowNodeName, String workflowAdjacencies, String workflowTags) {
        this.datum.jobid = new Utf8(id.toString());
        this.datum.jobName = new Utf8(jobName);
        this.datum.userName = new Utf8(userName);
        this.datum.submitTime = submitTime;
        this.datum.jobConfPath = new Utf8(jobConfPath);
        HashMap<CharSequence, CharSequence> jobAcls = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<JobACL, AccessControlList> entry : jobACLs.entrySet()) {
            jobAcls.put(new Utf8(entry.getKey().getAclName()), new Utf8(entry.getValue().getAclString()));
        }
        this.datum.acls = jobAcls;
        if (jobQueueName != null) {
            this.datum.jobQueueName = new Utf8(jobQueueName);
        }
        if (workflowId != null) {
            this.datum.workflowId = new Utf8(workflowId);
        }
        if (workflowName != null) {
            this.datum.workflowName = new Utf8(workflowName);
        }
        if (workflowNodeName != null) {
            this.datum.workflowNodeName = new Utf8(workflowNodeName);
        }
        if (workflowAdjacencies != null) {
            this.datum.workflowAdjacencies = new Utf8(workflowAdjacencies);
        }
        if (workflowTags != null) {
            this.datum.workflowTags = new Utf8(workflowTags);
        }
    }

    JobSubmittedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobSubmitted)datum;
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.jobid.toString());
    }

    public String getJobName() {
        return this.datum.jobName.toString();
    }

    public String getJobQueueName() {
        if (this.datum.jobQueueName != null) {
            return this.datum.jobQueueName.toString();
        }
        return null;
    }

    public String getUserName() {
        return this.datum.userName.toString();
    }

    public long getSubmitTime() {
        return this.datum.submitTime;
    }

    public String getJobConfPath() {
        return this.datum.jobConfPath.toString();
    }

    public Map<JobACL, AccessControlList> getJobAcls() {
        HashMap<JobACL, AccessControlList> jobAcls = new HashMap<JobACL, AccessControlList>();
        for (JobACL jobACL : JobACL.values()) {
            Utf8 jobACLsUtf8 = new Utf8(jobACL.getAclName());
            if (!this.datum.acls.containsKey(jobACLsUtf8)) continue;
            jobAcls.put(jobACL, new AccessControlList(this.datum.acls.get(jobACLsUtf8).toString()));
        }
        return jobAcls;
    }

    public String getWorkflowId() {
        if (this.datum.workflowId != null) {
            return this.datum.workflowId.toString();
        }
        return null;
    }

    public String getWorkflowName() {
        if (this.datum.workflowName != null) {
            return this.datum.workflowName.toString();
        }
        return null;
    }

    public String getWorkflowNodeName() {
        if (this.datum.workflowNodeName != null) {
            return this.datum.workflowNodeName.toString();
        }
        return null;
    }

    public String getWorkflowAdjacencies() {
        if (this.datum.workflowAdjacencies != null) {
            return this.datum.workflowAdjacencies.toString();
        }
        return null;
    }

    public String getWorkflowTags() {
        if (this.datum.workflowTags != null) {
            return this.datum.workflowTags.toString();
        }
        return null;
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_SUBMITTED;
    }
}

