/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.avro.util.Utf8;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobQueueChange;

public class JobQueueChangeEvent
implements HistoryEvent {
    private JobQueueChange datum = new JobQueueChange();

    public JobQueueChangeEvent(JobID id, String queueName) {
        this.datum.jobid = new Utf8(id.toString());
        this.datum.jobQueueName = new Utf8(queueName);
    }

    JobQueueChangeEvent() {
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_QUEUE_CHANGED;
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobQueueChange)datum;
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.jobid.toString());
    }

    public String getJobQueueName() {
        if (this.datum.jobQueueName != null) {
            return this.datum.jobQueueName.toString();
        }
        return null;
    }
}

