/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaInputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RollingLogs;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetFactory;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public interface FsDatasetSpi<V extends FsVolumeSpi>
extends FSDatasetMBean {
    public RollingLogs createRollingLogs(String var1, String var2) throws IOException;

    public List<V> getVolumes();

    public DatanodeStorage getStorage(String var1);

    public StorageReport[] getStorageReports(String var1) throws IOException;

    public V getVolume(ExtendedBlock var1);

    public Map<String, Object> getVolumeInfoMap();

    public List<FinalizedReplica> getFinalizedBlocks(String var1);

    public void checkAndUpdate(String var1, long var2, File var4, File var5, FsVolumeSpi var6);

    public LengthInputStream getMetaDataInputStream(ExtendedBlock var1) throws IOException;

    public long getLength(ExtendedBlock var1) throws IOException;

    @Deprecated
    public Replica getReplica(String var1, long var2);

    public String getReplicaString(String var1, long var2);

    public Block getStoredBlock(String var1, long var2) throws IOException;

    public InputStream getBlockInputStream(ExtendedBlock var1, long var2) throws IOException;

    public ReplicaInputStreams getTmpInputStreams(ExtendedBlock var1, long var2, long var4) throws IOException;

    public ReplicaInPipelineInterface createTemporary(ExtendedBlock var1) throws IOException;

    public ReplicaInPipelineInterface createRbw(ExtendedBlock var1) throws IOException;

    public ReplicaInPipelineInterface recoverRbw(ExtendedBlock var1, long var2, long var4, long var6) throws IOException;

    public ReplicaInPipelineInterface convertTemporaryToRbw(ExtendedBlock var1) throws IOException;

    public ReplicaInPipelineInterface append(ExtendedBlock var1, long var2, long var4) throws IOException;

    public ReplicaInPipelineInterface recoverAppend(ExtendedBlock var1, long var2, long var4) throws IOException;

    public String recoverClose(ExtendedBlock var1, long var2, long var4) throws IOException;

    public void finalizeBlock(ExtendedBlock var1) throws IOException;

    public void unfinalizeBlock(ExtendedBlock var1) throws IOException;

    public Map<DatanodeStorage, BlockListAsLongs> getBlockReports(String var1);

    public List<Long> getCacheReport(String var1);

    public boolean contains(ExtendedBlock var1);

    public boolean isValidBlock(ExtendedBlock var1);

    public boolean isValidRbw(ExtendedBlock var1);

    public void invalidate(String var1, Block[] var2) throws IOException;

    public void cache(String var1, long[] var2);

    public void uncache(String var1, long[] var2);

    public boolean isCached(String var1, long var2);

    public void checkDataDir() throws DiskChecker.DiskErrorException;

    public void shutdown();

    public void adjustCrcChannelPosition(ExtendedBlock var1, ReplicaOutputStreams var2, int var3) throws IOException;

    public boolean hasEnoughResource();

    public long getReplicaVisibleLength(ExtendedBlock var1) throws IOException;

    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock var1) throws IOException;

    public String updateReplicaUnderRecovery(ExtendedBlock var1, long var2, long var4) throws IOException;

    public void addBlockPool(String var1, Configuration var2) throws IOException;

    public void shutdownBlockPool(String var1);

    public void deleteBlockPool(String var1, boolean var2) throws IOException;

    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock var1) throws IOException;

    public HdfsBlocksMetadata getHdfsBlocksMetadata(String var1, long[] var2) throws IOException;

    public void enableTrash(String var1);

    public void restoreTrash(String var1);

    public boolean trashEnabled(String var1);

    public void submitBackgroundSyncFileRangeRequest(ExtendedBlock var1, FileDescriptor var2, long var3, long var5, int var7);

    public static abstract class Factory<D extends FsDatasetSpi<?>> {
        public static Factory<?> getFactory(Configuration conf) {
            Class<Factory> clazz = conf.getClass("dfs.datanode.fsdataset.factory", FsDatasetFactory.class, Factory.class);
            return ReflectionUtils.newInstance(clazz, conf);
        }

        public abstract D newInstance(DataNode var1, DataStorage var2, Configuration var3) throws IOException;

        public boolean isSimulated() {
            return false;
        }
    }
}

