/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificCompiler {
    private static final int JVM_METHOD_ARG_LIMIT = 255;
    protected static final int MAX_FIELD_PARAMETER_UNIT_COUNT = 254;
    private final SpecificData specificData = new SpecificData();
    private final Set<Schema> queue = new HashSet<Schema>();
    private Protocol protocol;
    private VelocityEngine velocityEngine;
    private String templateDir;
    private FieldVisibility fieldVisibility = FieldVisibility.PRIVATE;
    private boolean createOptionalGetters = false;
    private boolean gettersReturnOptional = false;
    private boolean optionalGettersForNullableFieldsOnly = false;
    private boolean createSetters = true;
    private boolean createAllArgsConstructor = true;
    private String outputCharacterEncoding;
    private boolean enableDecimalLogicalType = false;
    private String suffix = ".java";
    private List<Object> additionalVelocityTools = Collections.emptyList();
    protected static final Set<String> ACCESSOR_MUTATOR_RESERVED_WORDS = new HashSet<String>(Arrays.asList("class", "schema", "classSchema"));
    protected static final Set<String> TYPE_IDENTIFIER_RESERVED_WORDS;
    protected static final Set<String> ERROR_RESERVED_WORDS;
    private static final String FILE_HEADER = "/**\n * Autogenerated by Avro\n *\n * DO NOT EDIT DIRECTLY\n */\n";
    private GenericData.StringType stringType = GenericData.StringType.CharSequence;
    private static final Schema NULL_SCHEMA;
    int maxStringChars = 8192;

    void addLogicalTypeConversions(SpecificData specificData) {
        specificData.addLogicalTypeConversion(new TimeConversions.DateConversion());
        specificData.addLogicalTypeConversion(new TimeConversions.TimeMillisConversion());
        specificData.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
        specificData.addLogicalTypeConversion(new TimeConversions.TimestampMillisConversion());
        specificData.addLogicalTypeConversion(new TimeConversions.TimestampMicrosConversion());
        specificData.addLogicalTypeConversion(new TimeConversions.LocalTimestampMicrosConversion());
        specificData.addLogicalTypeConversion(new TimeConversions.LocalTimestampMillisConversion());
        specificData.addLogicalTypeConversion(new Conversions.UUIDConversion());
    }

    public boolean isCreateAllArgsConstructor() {
        return this.createAllArgsConstructor;
    }

    public SpecificCompiler(Protocol protocol) {
        this();
        for (Schema s2 : protocol.getTypes()) {
            this.enqueue(s2);
        }
        this.protocol = protocol;
    }

    public SpecificCompiler(Schema schema) {
        this();
        this.enqueue(schema);
        this.protocol = null;
    }

    SpecificCompiler() {
        this.templateDir = System.getProperty("org.apache.avro.specific.templates", "/org/apache/avro/compiler/specific/templates/java/classic/");
        this.initializeVelocity();
        this.initializeSpecificData();
    }

    public void setAdditionalVelocityTools(List<Object> additionalVelocityTools) {
        this.additionalVelocityTools = additionalVelocityTools;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean publicFields() {
        return this.fieldVisibility == FieldVisibility.PUBLIC;
    }

    public boolean privateFields() {
        return this.fieldVisibility == FieldVisibility.PRIVATE;
    }

    public void setFieldVisibility(FieldVisibility fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
    }

    public boolean isCreateSetters() {
        return this.createSetters;
    }

    public void setCreateSetters(boolean createSetters) {
        this.createSetters = createSetters;
    }

    public boolean isCreateOptionalGetters() {
        return this.createOptionalGetters;
    }

    public void setCreateOptionalGetters(boolean createOptionalGetters) {
        this.createOptionalGetters = createOptionalGetters;
    }

    public boolean isGettersReturnOptional() {
        return this.gettersReturnOptional;
    }

    public void setGettersReturnOptional(boolean gettersReturnOptional) {
        this.gettersReturnOptional = gettersReturnOptional;
    }

    public boolean isOptionalGettersForNullableFieldsOnly() {
        return this.optionalGettersForNullableFieldsOnly;
    }

    public void setOptionalGettersForNullableFieldsOnly(boolean optionalGettersForNullableFieldsOnly) {
        this.optionalGettersForNullableFieldsOnly = optionalGettersForNullableFieldsOnly;
    }

    public void setEnableDecimalLogicalType(boolean enableDecimalLogicalType) {
        this.enableDecimalLogicalType = enableDecimalLogicalType;
    }

    public void addCustomConversion(Class<?> conversionClass) {
        try {
            Conversion conversion = (Conversion)conversionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.specificData.addLogicalTypeConversion(conversion);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate conversion class " + conversionClass, e);
        }
    }

    public Collection<String> getUsedConversionClasses(Schema schema) {
        HashSet<String> result = new HashSet<String>();
        for (Conversion<?> conversion : this.getUsedConversions(schema)) {
            result.add(conversion.getClass().getCanonicalName());
        }
        return result;
    }

    public Map<String, String> getUsedCustomLogicalTypeFactories(Schema schema) {
        Set logicalTypeNames = this.getUsedLogicalTypes(schema).stream().map(LogicalType::getName).collect(Collectors.toSet());
        return LogicalTypes.getCustomRegisteredTypes().entrySet().stream().filter(entry -> logicalTypeNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((LogicalTypes.LogicalTypeFactory)entry.getValue()).getClass().getCanonicalName()));
    }

    private void collectUsedTypes(Schema schema, Set<Conversion<?>> conversionResults, Set<LogicalType> logicalTypeResults, Set<Schema> seenSchemas) {
        if (seenSchemas.contains(schema)) {
            return;
        }
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid(schema);
        if (logicalTypeResults != null && logicalType != null) {
            logicalTypeResults.add(logicalType);
        }
        Conversion conversion = this.specificData.getConversionFor(logicalType);
        if (conversionResults != null && conversion != null) {
            conversionResults.add(conversion);
        }
        seenSchemas.add(schema);
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    this.collectUsedTypes(field.schema(), conversionResults, logicalTypeResults, seenSchemas);
                }
                break;
            }
            case MAP: {
                this.collectUsedTypes(schema.getValueType(), conversionResults, logicalTypeResults, seenSchemas);
                break;
            }
            case ARRAY: {
                this.collectUsedTypes(schema.getElementType(), conversionResults, logicalTypeResults, seenSchemas);
                break;
            }
            case UNION: {
                for (Schema s2 : schema.getTypes()) {
                    this.collectUsedTypes(s2, conversionResults, logicalTypeResults, seenSchemas);
                }
                break;
            }
            case NULL: 
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
    }

    private Set<Conversion<?>> getUsedConversions(Schema schema) {
        HashSet conversionResults = new HashSet();
        this.collectUsedTypes(schema, conversionResults, null, new HashSet<Schema>());
        return conversionResults;
    }

    private Set<LogicalType> getUsedLogicalTypes(Schema schema) {
        HashSet<LogicalType> logicalTypeResults = new HashSet<LogicalType>();
        this.collectUsedTypes(schema, null, logicalTypeResults, new HashSet<Schema>());
        return logicalTypeResults;
    }

    private void initializeVelocity() {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.addProperty("resource.loaders", "class, file");
        this.velocityEngine.addProperty("resource.loader.class.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.velocityEngine.addProperty("resource.loader.file.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        this.velocityEngine.addProperty("resource.loader.file.path", "/, ., ");
        this.velocityEngine.setProperty("runtime.strict_mode.enable", true);
        this.velocityEngine.setProperty("parser.space_gobbling", "bc");
    }

    private void initializeSpecificData() {
        this.addLogicalTypeConversions(this.specificData);
        this.specificData.addLogicalTypeConversion(new Conversions.DecimalConversion());
    }

    public static void compileProtocol(File src, File dest) throws IOException {
        SpecificCompiler.compileProtocol(new File[]{src}, dest);
    }

    public static void compileProtocol(File[] srcFiles, File dest) throws IOException {
        for (File src : srcFiles) {
            Protocol protocol = Protocol.parse(src);
            SpecificCompiler compiler = new SpecificCompiler(protocol);
            compiler.compileToDestination(src, dest);
        }
    }

    public static void compileSchema(File src, File dest) throws IOException {
        SpecificCompiler.compileSchema(new File[]{src}, dest);
    }

    public static void compileSchema(File[] srcFiles, File dest) throws IOException {
        Schema.Parser parser = new Schema.Parser();
        for (File src : srcFiles) {
            Schema schema = parser.parse(src);
            SpecificCompiler compiler = new SpecificCompiler(schema);
            compiler.compileToDestination(src, dest);
        }
    }

    private void enqueue(Schema schema) {
        if (this.queue.contains(schema)) {
            return;
        }
        switch (schema.getType()) {
            case RECORD: {
                this.queue.add(schema);
                for (Schema.Field field : schema.getFields()) {
                    this.enqueue(field.schema());
                }
                break;
            }
            case MAP: {
                this.enqueue(schema.getValueType());
                break;
            }
            case ARRAY: {
                this.enqueue(schema.getElementType());
                break;
            }
            case UNION: {
                for (Schema s2 : schema.getTypes()) {
                    this.enqueue(s2);
                }
                break;
            }
            case ENUM: 
            case FIXED: {
                this.queue.add(schema);
                break;
            }
            case NULL: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
    }

    Collection<OutputFile> compile() {
        ArrayList<OutputFile> out = new ArrayList<OutputFile>(this.queue.size() + 1);
        for (Schema schema : this.queue) {
            out.add(this.compile(schema));
        }
        if (this.protocol != null) {
            out.add(this.compileInterface(this.protocol));
        }
        return out;
    }

    public void compileToDestination(File src, File dst) throws IOException {
        for (Schema schema : this.queue) {
            OutputFile o = this.compile(schema);
            o.writeToDestination(src, dst);
        }
        if (this.protocol != null) {
            this.compileInterface(this.protocol).writeToDestination(src, dst);
        }
    }

    private String renderTemplate(String templateName, VelocityContext context) {
        Template template;
        try {
            template = this.velocityEngine.getTemplate(templateName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StringWriter writer = new StringWriter();
        template.merge(context, writer);
        return writer.toString();
    }

    OutputFile compileInterface(Protocol protocol) {
        protocol = this.addStringType(protocol);
        VelocityContext context = new VelocityContext();
        context.put("protocol", protocol);
        context.put("this", this);
        for (Object velocityTool : this.additionalVelocityTools) {
            String toolName = velocityTool.getClass().getSimpleName().toLowerCase();
            context.put(toolName, velocityTool);
        }
        String out = this.renderTemplate(this.templateDir + "protocol.vm", context);
        OutputFile outputFile = new OutputFile();
        String mangledName = SpecificCompiler.mangleTypeIdentifier(protocol.getName());
        outputFile.path = this.makePath(mangledName, SpecificCompiler.mangle(protocol.getNamespace()));
        outputFile.contents = out;
        outputFile.outputCharacterEncoding = this.outputCharacterEncoding;
        return outputFile;
    }

    String makePath(String name, String space) {
        if (space == null || space.isEmpty()) {
            return name + this.suffix;
        }
        return space.replace('.', File.separatorChar) + File.separatorChar + name + this.suffix;
    }

    protected int calcAllArgConstructorParameterUnits(Schema record) {
        if (record.getType() != Schema.Type.RECORD) {
            throw new RuntimeException("This method must only be called for record schemas.");
        }
        return record.getFields().size();
    }

    protected void validateRecordForCompilation(Schema record) {
        boolean bl = this.createAllArgsConstructor = this.calcAllArgConstructorParameterUnits(record) <= 254;
        if (!this.createAllArgsConstructor) {
            Logger logger = LoggerFactory.getLogger(SpecificCompiler.class);
            logger.warn("Record '" + record.getFullName() + "' contains more than " + 254 + " parameters which exceeds the JVM spec for the number of permitted constructor arguments. Clients must rely on the builder pattern to create objects instead. For more info see JIRA ticket AVRO-1642.");
        }
    }

    OutputFile compile(Schema schema) {
        schema = this.addStringType(schema);
        String output = "";
        VelocityContext context = new VelocityContext();
        context.put("this", this);
        context.put("schema", schema);
        for (Object velocityTool : this.additionalVelocityTools) {
            String toolName = velocityTool.getClass().getSimpleName().toLowerCase();
            context.put(toolName, velocityTool);
        }
        switch (schema.getType()) {
            case RECORD: {
                this.validateRecordForCompilation(schema);
                output = this.renderTemplate(this.templateDir + "record.vm", context);
                break;
            }
            case ENUM: {
                output = this.renderTemplate(this.templateDir + "enum.vm", context);
                break;
            }
            case FIXED: {
                output = this.renderTemplate(this.templateDir + "fixed.vm", context);
                break;
            }
            case NULL: 
            case BOOLEAN: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
        OutputFile outputFile = new OutputFile();
        String name = SpecificCompiler.mangleTypeIdentifier(schema.getName());
        outputFile.path = this.makePath(name, SpecificCompiler.mangle(schema.getNamespace()));
        outputFile.contents = output;
        outputFile.outputCharacterEncoding = this.outputCharacterEncoding;
        return outputFile;
    }

    public void setStringType(GenericData.StringType t) {
        this.stringType = t;
    }

    private Protocol addStringType(Protocol p) {
        if (this.stringType != GenericData.StringType.String) {
            return p;
        }
        Protocol newP = new Protocol(p.getName(), p.getDoc(), p.getNamespace());
        LinkedHashMap<Schema, Schema> types = new LinkedHashMap<Schema, Schema>();
        for (Map.Entry<String, Object> entry : p.getObjectProps().entrySet()) {
            newP.addProp(entry.getKey(), entry.getValue());
        }
        LinkedHashSet<Schema> namedTypes = new LinkedHashSet<Schema>();
        for (Schema s2 : p.getTypes()) {
            namedTypes.add(this.addStringType(s2, types));
        }
        newP.setTypes(namedTypes);
        Map<String, Protocol.Message> map = newP.getMessages();
        for (Protocol.Message m3 : p.getMessages().values()) {
            map.put(m3.getName(), m3.isOneWay() ? newP.createMessage(m3, this.addStringType(m3.getRequest(), types)) : newP.createMessage(m3, this.addStringType(m3.getRequest(), types), this.addStringType(m3.getResponse(), types), this.addStringType(m3.getErrors(), types)));
        }
        return newP;
    }

    private Schema addStringType(Schema s2) {
        if (this.stringType != GenericData.StringType.String) {
            return s2;
        }
        return this.addStringType(s2, new HashMap<Schema, Schema>());
    }

    private Schema addStringType(Schema s2, Map<Schema, Schema> seen) {
        if (seen.containsKey(s2)) {
            return seen.get(s2);
        }
        Schema result = s2;
        switch (s2.getType()) {
            case STRING: {
                result = Schema.create(Schema.Type.STRING);
                if (s2.getLogicalType() != null) break;
                GenericData.setStringType(result, this.stringType);
                break;
            }
            case RECORD: {
                result = Schema.createRecord(s2.getFullName(), s2.getDoc(), null, s2.isError());
                for (String string : s2.getAliases()) {
                    result.addAlias(string, null);
                }
                seen.put(s2, result);
                ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>(s2.getFields().size());
                for (Schema.Field f : s2.getFields()) {
                    Schema fSchema = this.addStringType(f.schema(), seen);
                    Schema.Field newF = new Schema.Field(f, fSchema);
                    newFields.add(newF);
                }
                result.setFields(newFields);
                break;
            }
            case ARRAY: {
                Schema schema = this.addStringType(s2.getElementType(), seen);
                result = Schema.createArray(schema);
                break;
            }
            case MAP: {
                Schema v = this.addStringType(s2.getValueType(), seen);
                result = Schema.createMap(v);
                GenericData.setStringType(result, this.stringType);
                break;
            }
            case UNION: {
                ArrayList<Schema> types = new ArrayList<Schema>(s2.getTypes().size());
                for (Schema branch : s2.getTypes()) {
                    types.add(this.addStringType(branch, seen));
                }
                result = Schema.createUnion(types);
            }
        }
        result.addAllProps(s2);
        if (s2.getLogicalType() != null) {
            s2.getLogicalType().addToSchema(result);
        }
        seen.put(s2, result);
        return result;
    }

    public String getStringType(Schema s2) {
        String prop;
        switch (s2.getType()) {
            case MAP: {
                prop = "java-key-class";
                break;
            }
            case STRING: {
                prop = "java-class";
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't check string-type of non-string/map type: " + s2);
            }
        }
        return this.getStringType(s2.getObjectProp(prop));
    }

    private String getStringType(Object overrideClassProperty) {
        if (overrideClassProperty != null) {
            return overrideClassProperty.toString();
        }
        switch (this.stringType) {
            case String: {
                return "java.lang.String";
            }
            case Utf8: {
                return "org.apache.avro.util.Utf8";
            }
            case CharSequence: {
                return "java.lang.CharSequence";
            }
        }
        throw new RuntimeException("Unknown string type: " + (Object)((Object)this.stringType));
    }

    public boolean isStringable(Schema schema) {
        String t = this.getStringType(schema);
        return !t.equals("java.lang.String") && !t.equals("java.lang.CharSequence") && !t.equals("org.apache.avro.util.Utf8");
    }

    public String javaType(Schema schema) {
        return this.javaType(schema, true);
    }

    private String javaType(Schema schema, boolean checkConvertedLogicalType) {
        String convertedLogicalType;
        if (checkConvertedLogicalType && (convertedLogicalType = this.getConvertedLogicalType(schema)) != null) {
            return convertedLogicalType;
        }
        switch (schema.getType()) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                return this.mangleFullyQualified(schema.getFullName());
            }
            case ARRAY: {
                return "java.util.List<" + this.javaType(schema.getElementType()) + ">";
            }
            case MAP: {
                return "java.util.Map<" + this.getStringType(schema.getObjectProp("java-key-class")) + "," + this.javaType(schema.getValueType()) + ">";
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return this.javaType(types.get(types.get(0).equals(NULL_SCHEMA) ? 1 : 0));
                }
                return "java.lang.Object";
            }
            case STRING: {
                return this.getStringType(schema.getObjectProp("java-class"));
            }
            case BYTES: {
                return "java.nio.ByteBuffer";
            }
            case INT: {
                return "java.lang.Integer";
            }
            case LONG: {
                return "java.lang.Long";
            }
            case FLOAT: {
                return "java.lang.Float";
            }
            case DOUBLE: {
                return "java.lang.Double";
            }
            case BOOLEAN: {
                return "java.lang.Boolean";
            }
            case NULL: {
                return "java.lang.Void";
            }
        }
        throw new RuntimeException("Unknown type: " + schema);
    }

    private String mangleFullyQualified(String fullName) {
        int lastDot = fullName.lastIndexOf(46);
        if (lastDot < 0) {
            return SpecificCompiler.mangleTypeIdentifier(fullName);
        }
        String namespace = fullName.substring(0, lastDot);
        String typeName = fullName.substring(lastDot + 1);
        return SpecificCompiler.mangle(namespace) + "." + SpecificCompiler.mangleTypeIdentifier(typeName);
    }

    private LogicalType getLogicalType(Schema schema) {
        if (this.enableDecimalLogicalType || !(schema.getLogicalType() instanceof LogicalTypes.Decimal)) {
            return schema.getLogicalType();
        }
        return null;
    }

    private String getConvertedLogicalType(Schema schema) {
        Conversion conversion = this.specificData.getConversionFor(this.getLogicalType(schema));
        if (conversion != null) {
            return conversion.getConvertedType().getName();
        }
        return null;
    }

    public String generateSetterCode(Schema schema, String name, String pname) {
        Conversion conversion = this.specificData.getConversionFor(schema.getLogicalType());
        if (conversion != null) {
            return conversion.adjustAndSetValue("this." + name, pname);
        }
        return "this." + name + " = " + pname + ";";
    }

    @Deprecated
    public String javaUnbox(Schema schema) {
        return this.javaUnbox(schema, false);
    }

    public String javaUnbox(Schema schema, boolean unboxNullToVoid) {
        String convertedLogicalType = this.getConvertedLogicalType(schema);
        if (convertedLogicalType != null) {
            return convertedLogicalType;
        }
        switch (schema.getType()) {
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case NULL: {
                if (!unboxNullToVoid) break;
                return "void";
            }
        }
        return this.javaType(schema, false);
    }

    public String indent(int n) {
        return new String(new char[n]).replace('\u0000', ' ');
    }

    public int getNonNullIndex(Schema s2) {
        if (s2.getType() != Schema.Type.UNION || s2.getTypes().size() != 2 || !s2.getTypes().contains(NULL_SCHEMA)) {
            throw new IllegalArgumentException("Can only be used on 2-branch union with a null branch: " + s2);
        }
        return s2.getTypes().get(0).equals(NULL_SCHEMA) ? 1 : 0;
    }

    public boolean isCustomCodable(Schema schema) {
        return this.isCustomCodable(schema, new HashSet<Schema>());
    }

    private boolean isCustomCodable(Schema schema, Set<Schema> seen) {
        if (!seen.add(schema)) {
            return true;
        }
        if (schema.getLogicalType() != null) {
            return false;
        }
        boolean result = true;
        switch (schema.getType()) {
            case RECORD: {
                if (schema.isError()) {
                    return false;
                }
                for (Schema.Field f : schema.getFields()) {
                    result &= this.isCustomCodable(f.schema(), seen);
                }
                break;
            }
            case MAP: {
                result = this.isCustomCodable(schema.getValueType(), seen);
                break;
            }
            case ARRAY: {
                result = this.isCustomCodable(schema.getElementType(), seen);
                break;
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() != 2 || !types.contains(NULL_SCHEMA)) {
                    return false;
                }
                for (Schema s2 : types) {
                    result &= this.isCustomCodable(s2, seen);
                }
                break;
            }
        }
        return result;
    }

    public boolean hasLogicalTypeField(Schema schema) {
        for (Schema.Field field : schema.getFields()) {
            if (field.schema().getLogicalType() == null) continue;
            return true;
        }
        return false;
    }

    public String conversionInstance(Schema schema) {
        if (schema == null || schema.getLogicalType() == null) {
            return "null";
        }
        if (LogicalTypes.Decimal.class.equals(schema.getLogicalType().getClass()) && !this.enableDecimalLogicalType) {
            return "null";
        }
        Conversion conversion = this.specificData.getConversionFor(schema.getLogicalType());
        if (conversion != null) {
            return "new " + conversion.getClass().getCanonicalName() + "()";
        }
        return "null";
    }

    public String[] javaAnnotations(JsonProperties props) {
        Object value = props.getObjectProp("javaAnnotation");
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String) {
            return new String[]{value.toString()};
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> annots = new ArrayList<String>(list.size());
            for (Object o : list) {
                annots.add(o.toString());
            }
            return annots.toArray(new String[0]);
        }
        return new String[0];
    }

    public String javaSplit(String s2) throws IOException {
        StringBuilder b = new StringBuilder(s2.length());
        b.append("\"");
        for (int i = 0; i < s2.length(); i += this.maxStringChars) {
            if (i != 0) {
                b.append("\",\"");
            }
            String chunk = s2.substring(i, Math.min(s2.length(), i + this.maxStringChars));
            b.append(SpecificCompiler.javaEscape(chunk));
        }
        b.append("\"");
        return b.toString();
    }

    public static String javaEscape(String o) {
        return o.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String escapeForJavadoc(String s2) {
        return s2.replace("*/", "*&#47;");
    }

    public static String nullToEmpty(String x) {
        return x == null ? "" : x;
    }

    public static String mangle(String word) {
        return SpecificCompiler.mangle(word, false);
    }

    public static String mangle(String word, boolean isError) {
        return SpecificCompiler.mangle(word, isError ? ERROR_RESERVED_WORDS : SpecificData.RESERVED_WORDS);
    }

    public static String mangleTypeIdentifier(String word) {
        return SpecificCompiler.mangleTypeIdentifier(word, false);
    }

    public static String mangleTypeIdentifier(String word, boolean isError) {
        return SpecificCompiler.mangle(word, isError ? ERROR_RESERVED_WORDS : TYPE_IDENTIFIER_RESERVED_WORDS);
    }

    public static String mangle(String word, Set<String> reservedWords) {
        return SpecificCompiler.mangle(word, reservedWords, false);
    }

    public static String mangle(String word, Set<String> reservedWords, boolean isMethod) {
        if (StringUtils.isBlank(word)) {
            return word;
        }
        if (word.contains(".")) {
            String[] packageWords = word.split("\\.");
            CharSequence[] newPackageWords = new String[packageWords.length];
            for (int i = 0; i < packageWords.length; ++i) {
                String oldName = packageWords[i];
                newPackageWords[i] = SpecificCompiler.mangle(oldName, reservedWords, false);
            }
            return String.join((CharSequence)".", newPackageWords);
        }
        if (reservedWords.contains(word) || isMethod && reservedWords.contains(Character.toLowerCase(word.charAt(0)) + (word.length() > 1 ? word.substring(1) : ""))) {
            return word + '$';
        }
        return word;
    }

    public static long fingerprint64(Schema schema) {
        return SchemaNormalization.parsingFingerprint64(schema);
    }

    public static String generateGetMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "get", "");
    }

    public static String generateGetOptionalMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "getOptional", "");
    }

    public static String generateSetMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "set", "");
    }

    public static String generateHasMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "has", "");
    }

    public static String generateClearMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "clear", "");
    }

    public static boolean hasBuilder(Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                return true;
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return SpecificCompiler.hasBuilder(types.get(types.get(0).equals(NULL_SCHEMA) ? 1 : 0));
                }
                return false;
            }
        }
        return false;
    }

    public static String generateGetBuilderMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "get", "Builder");
    }

    public static String generateSetBuilderMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "set", "Builder");
    }

    public static String generateHasBuilderMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "has", "Builder");
    }

    private static String generateMethodName(Schema schema, Schema.Field field, String prefix, String postfix) {
        char firstChar = field.name().charAt(0);
        String conflictingFieldName = (Character.isLowerCase(firstChar) ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + (field.name().length() > 1 ? field.name().substring(1) : "");
        boolean fieldNameConflict = schema.getField(conflictingFieldName) != null;
        StringBuilder methodBuilder = new StringBuilder(prefix);
        String fieldName = SpecificCompiler.mangle(field.name(), schema.isError() ? ERROR_RESERVED_WORDS : ACCESSOR_MUTATOR_RESERVED_WORDS, true);
        boolean nextCharToUpper = true;
        for (int ii = 0; ii < fieldName.length(); ++ii) {
            if (fieldName.charAt(ii) == '_') {
                nextCharToUpper = true;
                continue;
            }
            if (nextCharToUpper) {
                methodBuilder.append(Character.toUpperCase(fieldName.charAt(ii)));
                nextCharToUpper = false;
                continue;
            }
            methodBuilder.append(fieldName.charAt(ii));
        }
        methodBuilder.append(postfix);
        if (fieldNameConflict) {
            if (methodBuilder.charAt(methodBuilder.length() - 1) != '$') {
                methodBuilder.append('$');
            }
            methodBuilder.append(Character.isLowerCase(firstChar) ? (char)'0' : '1');
        }
        return methodBuilder.toString();
    }

    public static boolean isUnboxedJavaTypeNullable(Schema schema) {
        switch (schema.getType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        SpecificCompiler.compileProtocol(new File(args[0]), new File(args[1]));
    }

    public void setOutputCharacterEncoding(String outputCharacterEncoding) {
        this.outputCharacterEncoding = outputCharacterEncoding;
    }

    static {
        ACCESSOR_MUTATOR_RESERVED_WORDS.addAll(SpecificData.RESERVED_WORDS);
        TYPE_IDENTIFIER_RESERVED_WORDS = new HashSet<String>(Arrays.asList("var", "yield", "record"));
        TYPE_IDENTIFIER_RESERVED_WORDS.addAll(SpecificData.RESERVED_WORDS);
        ERROR_RESERVED_WORDS = new HashSet<String>(Arrays.asList("message", "cause"));
        ERROR_RESERVED_WORDS.addAll(ACCESSOR_MUTATOR_RESERVED_WORDS);
        NULL_SCHEMA = Schema.create(Schema.Type.NULL);
    }

    static class OutputFile {
        String path;
        String contents;
        String outputCharacterEncoding;

        OutputFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        File writeToDestination(File src, File destDir) throws IOException {
            File f = new File(destDir, this.path);
            if (src != null && f.exists() && f.lastModified() >= src.lastModified()) {
                return f;
            }
            f.getParentFile().mkdirs();
            Writer fw = null;
            FileOutputStream fos = null;
            try {
                if (this.outputCharacterEncoding != null) {
                    fos = new FileOutputStream(f);
                    fw = new OutputStreamWriter((OutputStream)fos, this.outputCharacterEncoding);
                } else {
                    fw = Files.newBufferedWriter(f.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                }
                fw.write(SpecificCompiler.FILE_HEADER);
                fw.write(this.contents);
            }
            finally {
                if (fw != null) {
                    fw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            return f;
        }
    }

    public static enum FieldVisibility {
        PUBLIC,
        PRIVATE;

    }
}

