/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.security.AdminACLsManager;

@InterfaceAudience.Private
public class ApplicationACLsManager {
    private static final Log LOG = LogFactory.getLog(ApplicationACLsManager.class);
    private static AccessControlList DEFAULT_YARN_APP_ACL = new AccessControlList(" ");
    private final Configuration conf;
    private final AdminACLsManager adminAclsManager;
    private final ConcurrentMap<ApplicationId, Map<ApplicationAccessType, AccessControlList>> applicationACLS = new ConcurrentHashMap<ApplicationId, Map<ApplicationAccessType, AccessControlList>>();

    @VisibleForTesting
    public ApplicationACLsManager() {
        this(new Configuration());
    }

    public ApplicationACLsManager(Configuration conf) {
        this.conf = conf;
        this.adminAclsManager = new AdminACLsManager(this.conf);
    }

    public boolean areACLsEnabled() {
        return this.adminAclsManager.areACLsEnabled();
    }

    public void addApplication(ApplicationId appId, Map<ApplicationAccessType, String> acls) {
        HashMap<ApplicationAccessType, AccessControlList> finalMap = new HashMap<ApplicationAccessType, AccessControlList>(acls.size());
        for (Map.Entry<ApplicationAccessType, String> acl : acls.entrySet()) {
            finalMap.put(acl.getKey(), new AccessControlList(acl.getValue()));
        }
        this.applicationACLS.put(appId, finalMap);
    }

    public void removeApplication(ApplicationId appId) {
        this.applicationACLS.remove(appId);
    }

    public boolean checkAccess(UserGroupInformation callerUGI, ApplicationAccessType applicationAccessType, String applicationOwner, ApplicationId applicationId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verifying access-type " + (Object)((Object)applicationAccessType) + " for " + callerUGI + " on application " + applicationId + " owned by " + applicationOwner);
        }
        String user = callerUGI.getShortUserName();
        if (!this.areACLsEnabled()) {
            return true;
        }
        AccessControlList applicationACL = DEFAULT_YARN_APP_ACL;
        Map acls = (Map)this.applicationACLS.get(applicationId);
        if (acls == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ACL not found for application " + applicationId + " owned by " + applicationOwner + ". Using default [" + " " + "]");
            }
        } else {
            AccessControlList applicationACLInMap = (AccessControlList)acls.get((Object)applicationAccessType);
            if (applicationACLInMap != null) {
                applicationACL = applicationACLInMap;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("ACL not found for access-type " + (Object)((Object)applicationAccessType) + " for application " + applicationId + " owned by " + applicationOwner + ". Using default [" + " " + "]");
            }
        }
        return this.adminAclsManager.isAdmin(callerUGI) || user.equals(applicationOwner) || applicationACL.isUserAllowed(callerUGI);
    }

    public final boolean isAdmin(UserGroupInformation calledUGI) {
        return this.adminAclsManager.isAdmin(calledUGI);
    }
}

