/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SynchronousScheduler implements ILSMIOOperationScheduler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final SynchronousScheduler INSTANCE = new SynchronousScheduler();

    private SynchronousScheduler() {
    }

    @Override
    public void scheduleOperation(ILSMIOOperation operation) throws HyracksDataException {
        try {
            operation.call();
        } catch (Exception e) {
            LOGGER.log(Level.ERROR, "IO Operation failed", e);
            throw HyracksDataException.create(e);
        }
    }
}
