/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.hyracks.server.process;

import java.io.File;
import java.util.List;

import org.apache.hyracks.control.cc.CCDriver;

public class HyracksCCProcess extends HyracksServerProcess {

    public HyracksCCProcess(File configFile, File logFile, File appHome, File workingDir) {
        this.configFile = configFile;
        this.logFile = logFile;
        this.appHome = appHome;
        this.workingDir = workingDir;
    }

    @Override
    protected String getMainClassName() {
        return CCDriver.class.getName();
    }

    @Override
    protected void addJvmArgs(List<String> cList) {
        // CC needs more than default memory
        cList.add("-Xmx1024m");
        //cList.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=5005");
    }
}
