/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.FanoutWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.RollingDataWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class FanoutDataWriter<T>
extends FanoutWriter<T, DataWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSizeInBytes;
    private final List<DataFile> dataFiles;

    public FanoutDataWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes) {
        this.writerFactory = writerFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.dataFiles = Lists.newArrayList();
    }

    @Override
    protected FileWriter<T, DataWriteResult> newWriter(PartitionSpec spec, StructLike partition) {
        return new RollingDataWriter<T>(this.writerFactory, this.fileFactory, this.io, this.targetFileSizeInBytes, spec, partition);
    }

    @Override
    protected void addResult(DataWriteResult result) {
        this.dataFiles.addAll(result.dataFiles());
    }

    @Override
    protected DataWriteResult aggregatedResult() {
        return new DataWriteResult(this.dataFiles);
    }
}

