/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.asterix.common.cluster.ComputePartition;
import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.cluster.SplitComputeLocations;
import org.apache.asterix.common.cluster.StorageComputePartitionsMap;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.utils.DataPartitioningProvider;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.MappedFileSplit;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;

public class StaticDataPartitioningProvider
extends DataPartitioningProvider {
    public StaticDataPartitioningProvider(ICcApplicationContext appCtx) {
        super(appCtx);
    }

    @Override
    public PartitioningProperties getPartitioningProperties(String databaseName) {
        SplitComputeLocations databaseSplits = this.getSplits(databaseName);
        StorageComputePartitionsMap partitionMap = this.clusterStateManager.getStorageComputeMap();
        int[][] partitionsMap = partitionMap.getComputeToStorageMap(false);
        return PartitioningProperties.of((IFileSplitProvider)databaseSplits.getSplitsProvider(), (AlgebricksPartitionConstraint)databaseSplits.getConstraints(), (int[][])partitionsMap);
    }

    @Override
    public PartitioningProperties getPartitioningProperties(String databaseName, DataverseName dataverseName) {
        SplitComputeLocations dataverseSplits = this.getDataverseSplits(databaseName, dataverseName);
        StorageComputePartitionsMap partitionMap = this.clusterStateManager.getStorageComputeMap();
        int[][] partitionsMap = partitionMap.getComputeToStorageMap(false);
        return PartitioningProperties.of((IFileSplitProvider)dataverseSplits.getSplitsProvider(), (AlgebricksPartitionConstraint)dataverseSplits.getConstraints(), (int[][])partitionsMap);
    }

    @Override
    public PartitioningProperties getPartitioningProperties(MetadataTransactionContext mdTxnCtx, Dataset ds, String indexName) throws AlgebricksException {
        SplitComputeLocations datasetSplits = this.getDatasetSplits(ds, indexName);
        StorageComputePartitionsMap partitionMap = this.clusterStateManager.getStorageComputeMap();
        int[][] partitionsMap = partitionMap.getComputeToStorageMap(MetadataIndexImmutableProperties.isMetadataDataset((int)ds.getDatasetId()));
        return PartitioningProperties.of((IFileSplitProvider)datasetSplits.getSplitsProvider(), (AlgebricksPartitionConstraint)datasetSplits.getConstraints(), (int[][])partitionsMap);
    }

    private SplitComputeLocations getDataverseSplits(String databaseName, DataverseName dataverseName) {
        return this.getSplits(this.namespacePathResolver.resolve(databaseName, dataverseName));
    }

    private SplitComputeLocations getSplits(String subPath) {
        ArrayList<MappedFileSplit> splits = new ArrayList<MappedFileSplit>();
        ArrayList<String> locations = new ArrayList<String>();
        HashSet<Integer> uniqueLocations = new HashSet<Integer>();
        StorageComputePartitionsMap partitionMap = this.clusterStateManager.getStorageComputeMap();
        for (int i = 0; i < this.storagePartitionsCounts; ++i) {
            File f = new File(StoragePathUtil.prepareStoragePartitionPath((int)i), subPath);
            ComputePartition computePartition = partitionMap.getComputePartition(i);
            splits.add(new MappedFileSplit(computePartition.getNodeId(), f.getPath(), 0));
            if (!uniqueLocations.contains(computePartition.getId())) {
                locations.add(computePartition.getNodeId());
            }
            uniqueLocations.add(computePartition.getId());
        }
        IFileSplitProvider splitProvider = StoragePathUtil.splitProvider((FileSplit[])splits.toArray(new FileSplit[0]));
        AlgebricksAbsolutePartitionConstraint constraints = new AlgebricksAbsolutePartitionConstraint(locations.toArray(new String[0]));
        return new SplitComputeLocations(splitProvider, (AlgebricksPartitionConstraint)constraints);
    }

    private SplitComputeLocations getDatasetSplits(Dataset dataset, String indexName) {
        ArrayList<MappedFileSplit> splits = new ArrayList<MappedFileSplit>();
        ArrayList<String> locations = new ArrayList<String>();
        HashSet<Integer> uniqueLocations = new HashSet<Integer>();
        String namespacePath = this.namespacePathResolver.resolve(dataset.getDatabaseName(), dataset.getDataverseName());
        StorageComputePartitionsMap partitionMap = this.clusterStateManager.getStorageComputeMap();
        int datasetPartitions = this.getNumberOfPartitions(dataset);
        boolean metadataDataset = MetadataIndexImmutableProperties.isMetadataDataset((int)dataset.getDatasetId());
        for (int i = 0; i < datasetPartitions; ++i) {
            int storagePartition = metadataDataset ? -1 : i;
            String relPath = StoragePathUtil.prepareNamespaceIndexName((String)dataset.getDatasetName(), (String)indexName, (long)dataset.getRebalanceCount(), (String)namespacePath);
            File f = new File(StoragePathUtil.prepareStoragePartitionPath((int)storagePartition), relPath);
            ComputePartition computePartition = partitionMap.getComputePartition(storagePartition);
            splits.add(new MappedFileSplit(computePartition.getNodeId(), f.getPath(), 0));
            int computePartitionId = computePartition.getId();
            if (!uniqueLocations.contains(computePartitionId)) {
                locations.add(computePartition.getNodeId());
            }
            uniqueLocations.add(computePartitionId);
        }
        IFileSplitProvider splitProvider = StoragePathUtil.splitProvider((FileSplit[])splits.toArray(new FileSplit[0]));
        AlgebricksAbsolutePartitionConstraint constraints = new AlgebricksAbsolutePartitionConstraint(locations.toArray(new String[0]));
        return new SplitComputeLocations(splitProvider, (AlgebricksPartitionConstraint)constraints);
    }

    public AlgebricksAbsolutePartitionConstraint getClusterLocations() {
        SplitComputeLocations locations = this.getSplits("Default");
        return (AlgebricksAbsolutePartitionConstraint)locations.getConstraints();
    }
}

