/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.util.Comparator;
import java.util.List;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.utils.NormalizedKeyUtils;
import org.apache.hyracks.dataflow.std.sort.util.GroupFrameAccessor;
import org.apache.hyracks.dataflow.std.util.ReferenceEntry;
import org.apache.hyracks.dataflow.std.util.ReferencedPriorityQueue;

public class RunMergingFrameReader
implements IFrameReader {
    private final IHyracksTaskContext ctx;
    private final List<? extends IFrameReader> runCursors;
    private final List<? extends IFrame> inFrames;
    private final int[] sortFields;
    private final IBinaryComparator[] comparators;
    private final INormalizedKeyComputer nmkComputer;
    private final int normalizedKeyLength;
    private final boolean normalizedKeyDecisive;
    private final RecordDescriptor recordDesc;
    private final int topK;
    private int tupleCount;
    private FrameTupleAppender outFrameAppender;
    private ReferencedPriorityQueue topTuples;
    private int[] tupleIndexes;
    private IFrameTupleAccessor[] tupleAccessors;

    public RunMergingFrameReader(IHyracksTaskContext ctx, List<? extends IFrameReader> runs, List<? extends IFrame> inFrames, int[] sortFields, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDesc) {
        this(ctx, runs, inFrames, sortFields, comparators, nmkComputer, recordDesc, Integer.MAX_VALUE);
    }

    public RunMergingFrameReader(IHyracksTaskContext ctx, List<? extends IFrameReader> runs, List<? extends IFrame> inFrames, int[] sortFields, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, RecordDescriptor recordDesc, int topK) {
        this.ctx = ctx;
        this.runCursors = runs;
        this.inFrames = inFrames;
        this.sortFields = sortFields;
        this.comparators = comparators;
        this.nmkComputer = nmkComputer;
        int n = this.normalizedKeyLength = nmkComputer != null ? nmkComputer.getNormalizedKeyProperties().getNormalizedKeyLength() : 0;
        this.normalizedKeyDecisive = nmkComputer != null ? nmkComputer.getNormalizedKeyProperties().isDecisive() && comparators.length == 1 : false;
        this.recordDesc = recordDesc;
        this.topK = topK;
    }

    public void open() throws HyracksDataException {
        this.tupleCount = 0;
        this.tupleAccessors = new IFrameTupleAccessor[this.runCursors.size()];
        this.outFrameAppender = new FrameTupleAppender();
        Comparator<ReferenceEntry> comparator = this.createEntryComparator(this.comparators);
        this.topTuples = new ReferencedPriorityQueue(this.runCursors.size(), comparator, this.sortFields, this.nmkComputer);
        this.tupleIndexes = new int[this.runCursors.size()];
        for (int i = 0; i < this.runCursors.size(); ++i) {
            this.tupleIndexes[i] = 0;
            int runIndex = this.topTuples.peek().getRunid();
            this.runCursors.get(runIndex).open();
            if (this.runCursors.get(runIndex).nextFrame(this.inFrames.get(runIndex))) {
                this.tupleAccessors[runIndex] = new GroupFrameAccessor(this.ctx.getInitialFrameSize(), this.recordDesc);
                this.tupleAccessors[runIndex].reset(this.inFrames.get(runIndex).getBuffer());
                RunMergingFrameReader.setNextTopTuple(runIndex, this.tupleIndexes, this.runCursors, this.inFrames, this.tupleAccessors, this.topTuples);
                continue;
            }
            RunMergingFrameReader.closeRun(runIndex, this.runCursors, this.tupleAccessors);
            this.topTuples.pop();
        }
    }

    public boolean nextFrame(IFrame outFrame) throws HyracksDataException {
        this.outFrameAppender.reset(outFrame, true);
        while (!this.topTuples.areRunsExhausted() && this.tupleCount < this.topK) {
            int tupleIndex;
            ReferenceEntry top = this.topTuples.peek();
            int runIndex = top.getRunid();
            IFrameTupleAccessor fta = top.getAccessor();
            if (!this.outFrameAppender.append(fta, tupleIndex = top.getTupleIndex())) {
                return true;
            }
            ++this.tupleCount;
            int n = runIndex;
            this.tupleIndexes[n] = this.tupleIndexes[n] + 1;
            RunMergingFrameReader.setNextTopTuple(runIndex, this.tupleIndexes, this.runCursors, this.inFrames, this.tupleAccessors, this.topTuples);
        }
        return this.outFrameAppender.getTupleCount() > 0;
    }

    public void close() throws HyracksDataException {
        for (int i = 0; i < this.runCursors.size(); ++i) {
            RunMergingFrameReader.closeRun(i, this.runCursors, this.tupleAccessors);
        }
    }

    private static void setNextTopTuple(int runIndex, int[] tupleIndexes, List<? extends IFrameReader> runCursors, List<? extends IFrame> inFrames, IFrameTupleAccessor[] tupleAccessors, ReferencedPriorityQueue topTuples) throws HyracksDataException {
        boolean exists = RunMergingFrameReader.hasNextTuple(runIndex, tupleIndexes, runCursors, inFrames, tupleAccessors);
        if (exists) {
            topTuples.popAndReplace(tupleAccessors[runIndex], tupleIndexes[runIndex]);
        } else {
            topTuples.pop();
            RunMergingFrameReader.closeRun(runIndex, runCursors, tupleAccessors);
        }
    }

    private static boolean hasNextTuple(int runIndex, int[] tupleIndexes, List<? extends IFrameReader> runCursors, List<? extends IFrame> inFrames, IFrameTupleAccessor[] tupleAccessors) throws HyracksDataException {
        if (tupleAccessors[runIndex] == null || runCursors.get(runIndex) == null) {
            return false;
        }
        if (tupleIndexes[runIndex] >= tupleAccessors[runIndex].getTupleCount()) {
            IFrame frame = inFrames.get(runIndex);
            if (runCursors.get(runIndex).nextFrame(frame)) {
                tupleIndexes[runIndex] = 0;
                tupleAccessors[runIndex].reset(frame.getBuffer());
                return RunMergingFrameReader.hasNextTuple(runIndex, tupleIndexes, runCursors, inFrames, tupleAccessors);
            }
            return false;
        }
        return true;
    }

    private static void closeRun(int index, List<? extends IFrameReader> runCursors, IFrameTupleAccessor[] tupleAccessors) throws HyracksDataException {
        if (runCursors.get(index) != null) {
            runCursors.get(index).close();
            runCursors.set(index, null);
            tupleAccessors[index] = null;
        }
    }

    private Comparator<ReferenceEntry> createEntryComparator(final IBinaryComparator[] comparators) {
        return new Comparator<ReferenceEntry>(){

            @Override
            public int compare(ReferenceEntry tp1, ReferenceEntry tp2) {
                int[] tPointers2;
                int[] tPointers1 = tp1.getTPointers();
                int cmp = NormalizedKeyUtils.compareNormalizeKeys((int[])tPointers1, (int)0, (int[])(tPointers2 = tp2.getTPointers()), (int)0, (int)RunMergingFrameReader.this.normalizedKeyLength);
                if (cmp != 0) {
                    return cmp;
                }
                if (RunMergingFrameReader.this.normalizedKeyDecisive) {
                    return this.compareRun(tp1, tp2);
                }
                IFrameTupleAccessor fta1 = tp1.getAccessor();
                IFrameTupleAccessor fta2 = tp2.getAccessor();
                byte[] b1 = fta1.getBuffer().array();
                byte[] b2 = fta2.getBuffer().array();
                for (int f = 0; f < RunMergingFrameReader.this.sortFields.length; ++f) {
                    try {
                        int c = comparators[f].compare(b1, tPointers1[2 * f + RunMergingFrameReader.this.normalizedKeyLength], tPointers1[2 * f + RunMergingFrameReader.this.normalizedKeyLength + 1], b2, tPointers2[2 * f + RunMergingFrameReader.this.normalizedKeyLength], tPointers2[2 * f + RunMergingFrameReader.this.normalizedKeyLength + 1]);
                        if (c == 0) continue;
                        return c;
                    }
                    catch (HyracksDataException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return this.compareRun(tp1, tp2);
            }

            private int compareRun(ReferenceEntry tp1, ReferenceEntry tp2) {
                int runid2;
                int runid1 = tp1.getRunid();
                return runid1 < (runid2 = tp2.getRunid()) ? -1 : (runid1 == runid2 ? 0 : 1);
            }
        };
    }
}

