/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminConfigKey;
import org.apache.kerby.kerberos.kerb.common.Krb5Conf;

public class AdminConfig
extends Krb5Conf {
    private static final String LIBDEFAULT = "libdefaults";

    public boolean enableDebug() {
        return this.getBoolean(AdminConfigKey.KRB_DEBUG, true, new String[]{LIBDEFAULT});
    }

    public String getAdminHost() {
        return this.getString(AdminConfigKey.ADMIN_HOST, true, new String[]{LIBDEFAULT});
    }

    public int getAdminPort() {
        Integer kdcPort = this.getInt(AdminConfigKey.ADMIN_PORT, true, new String[]{LIBDEFAULT});
        if (kdcPort != null) {
            return kdcPort;
        }
        return -1;
    }

    public int getAdminTcpPort() {
        Integer kdcPort = this.getInt(AdminConfigKey.ADMIN_TCP_PORT, true, new String[]{LIBDEFAULT});
        if (kdcPort != null && kdcPort > 0) {
            return kdcPort;
        }
        return this.getAdminPort();
    }

    public boolean allowUdp() {
        return this.getBoolean(AdminConfigKey.ADMIN_ALLOW_UDP, true, new String[]{LIBDEFAULT}) != false || this.getInt(AdminConfigKey.ADMIN_UDP_PORT, true, new String[]{LIBDEFAULT}) != null || this.getInt(AdminConfigKey.ADMIN_PORT, false, new String[]{LIBDEFAULT}) != null;
    }

    public boolean allowTcp() {
        return this.getBoolean(AdminConfigKey.ADMIN_ALLOW_TCP, true, new String[]{LIBDEFAULT}) != false || this.getInt(AdminConfigKey.ADMIN_TCP_PORT, true, new String[]{LIBDEFAULT}) != null || this.getInt(AdminConfigKey.ADMIN_PORT, false, new String[]{LIBDEFAULT}) != null;
    }

    public int getAdminUdpPort() {
        Integer kdcPort = this.getInt(AdminConfigKey.ADMIN_UDP_PORT, true, new String[]{LIBDEFAULT});
        if (kdcPort != null && kdcPort > 0) {
            return kdcPort;
        }
        return this.getAdminPort();
    }

    public String getAdminRealm() {
        String realm = this.getString(AdminConfigKey.ADMIN_REALM, false, new String[]{LIBDEFAULT});
        if (realm == null && (realm = this.getString(AdminConfigKey.DEFAULT_REALM, false, new String[]{LIBDEFAULT})) == null) {
            realm = (String)AdminConfigKey.ADMIN_REALM.getDefaultValue();
        }
        return realm;
    }

    public String getKeyTabFile() {
        return this.getString(AdminConfigKey.KEYTAB_FILE, true, new String[]{LIBDEFAULT});
    }

    public String getProtocol() {
        return this.getString(AdminConfigKey.PROTOCOL, true, new String[]{LIBDEFAULT});
    }

    public String getServerName() {
        return this.getString(AdminConfigKey.SERVER_NAME, true, new String[]{LIBDEFAULT});
    }
}

