/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslator;
import org.apache.asterix.algebra.base.ILangExpressionToPlanTranslatorFactory;
import org.apache.asterix.api.http.server.ResultUtil;
import org.apache.asterix.app.result.fields.ExplainOnlyResultsPrinter;
import org.apache.asterix.app.result.fields.SignaturePrinter;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.api.INodeJobTracker;
import org.apache.asterix.common.api.IResponseFieldPrinter;
import org.apache.asterix.common.api.IResponsePrinter;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.OptimizationConfUtil;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.common.utils.Job;
import org.apache.asterix.compiler.provider.ILangCompilationProvider;
import org.apache.asterix.compiler.provider.IRuleSetFactory;
import org.apache.asterix.dataflow.data.common.ConflictingTypeResolver;
import org.apache.asterix.dataflow.data.common.ExpressionTypeComputer;
import org.apache.asterix.dataflow.data.common.MergeAggregationExpressionFactory;
import org.apache.asterix.dataflow.data.common.MissableTypeComputer;
import org.apache.asterix.dataflow.data.common.PartialAggregationTypeComputer;
import org.apache.asterix.formats.base.IDataFormat;
import org.apache.asterix.jobgen.QueryLogicalExpressionJobGen;
import org.apache.asterix.lang.common.base.IAstPrintVisitorFactory;
import org.apache.asterix.lang.common.base.IQueryRewriter;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.optimizer.base.AsterixOptimizationContext;
import org.apache.asterix.runtime.job.listener.JobEventListenerFactory;
import org.apache.asterix.translator.CompiledStatements;
import org.apache.asterix.translator.ExecutionPlans;
import org.apache.asterix.translator.IRequestParameters;
import org.apache.asterix.translator.ResultMetadata;
import org.apache.asterix.translator.SessionConfig;
import org.apache.asterix.translator.SessionOutput;
import org.apache.asterix.utils.ResourceUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.compiler.api.HeuristicCompilerFactoryBuilder;
import org.apache.hyracks.algebricks.compiler.api.ICompiler;
import org.apache.hyracks.algebricks.compiler.api.ICompilerFactory;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.ExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IConflictingTypeResolver;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionEvalSizeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.ILogicalExpressionJobGen;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMergeAggregationExpressionFactory;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IPartialAggregationTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksStringBuilderWriter;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.rewriter.base.IOptimizationContextFactory;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactoryProvider;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.serializer.ResultSerializerFactoryProvider;
import org.apache.hyracks.algebricks.runtime.writers.PrinterBasedWriterFactory;
import org.apache.hyracks.api.client.IClusterInfoCollector;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.resource.IClusterCapacity;
import org.apache.hyracks.api.result.IResultMetadata;
import org.apache.hyracks.control.common.config.OptionTypes;

public class APIFramework {
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    public static final String PREFIX_INTERNAL_PARAMETERS = "_internal";
    private final IRewriterFactory rewriterFactory;
    private final IAstPrintVisitorFactory astPrintVisitorFactory;
    private final ILangExpressionToPlanTranslatorFactory translatorFactory;
    private final IRuleSetFactory ruleSetFactory;
    private final Set<String> configurableParameterNames;
    private final ExecutionPlans executionPlans;
    private PlanInfo lastPlan;

    public APIFramework(ILangCompilationProvider compilationProvider) {
        this.rewriterFactory = compilationProvider.getRewriterFactory();
        this.astPrintVisitorFactory = compilationProvider.getAstPrintVisitorFactory();
        this.translatorFactory = compilationProvider.getExpressionToPlanTranslatorFactory();
        this.ruleSetFactory = compilationProvider.getRuleSetFactory();
        this.configurableParameterNames = compilationProvider.getCompilerOptions();
        this.executionPlans = new ExecutionPlans();
        this.lastPlan = null;
    }

    public Pair<IReturningStatement, Integer> reWriteQuery(LangRewritingContext langRewritingContext, IReturningStatement q, SessionOutput output, boolean allowNonStoredUdfCalls, boolean inlineUdfsAndViews, Collection<VarIdentifier> externalVars) throws CompilationException {
        if (q == null) {
            return null;
        }
        SessionConfig conf = output.config();
        if (!conf.is("format-only-physical-ops") && conf.is("oob-expr-tree")) {
            this.generateExpressionTree(q);
        }
        IQueryRewriter rw = this.rewriterFactory.createQueryRewriter();
        rw.rewrite(langRewritingContext, q, allowNonStoredUdfCalls, inlineUdfsAndViews, externalVars);
        return new Pair((Object)q, (Object)q.getVarCounter());
    }

    public JobSpecification compileQuery(IClusterInfoCollector clusterInfoCollector, MetadataProvider metadataProvider, Query query, int varCounter, String outputDatasetName, SessionOutput output, CompiledStatements.ICompiledStatement statement, Map<VarIdentifier, IAObject> externalVars, IResponsePrinter printer, IWarningCollector warningCollector, IRequestParameters requestParameters, EnumSet<JobFlag> runtimeFlags) throws AlgebricksException, ACIDException {
        boolean printSignature;
        boolean isCopy;
        boolean isQuery = query != null;
        boolean isLoad = statement != null && statement.getKind() == Statement.Kind.LOAD;
        boolean bl = isCopy = statement != null && statement.getKind() == Statement.Kind.COPY_FROM;
        SourceLocation sourceLoc = query != null ? query.getSourceLocation() : (statement != null ? statement.getSourceLocation() : null);
        boolean isExplainOnly = isQuery && query.isExplain();
        SessionConfig conf = output.config();
        if (isQuery && !conf.is("format-only-physical-ops") && conf.is("oob-rewritten-expr-tree")) {
            this.generateRewrittenExpressionTree((IReturningStatement)query);
        }
        TxnId txnId = metadataProvider.getTxnIdFactory().create();
        metadataProvider.setTxnId(txnId);
        ILangExpressionToPlanTranslator t = this.translatorFactory.createExpressionToPlanTranslator(metadataProvider, varCounter, externalVars);
        ResultMetadata resultMetadata = new ResultMetadata(output.config().fmt());
        ILogicalPlan plan = isLoad || isCopy ? t.translateCopyOrLoad((CompiledStatements.ICompiledDmlStatement)statement) : t.translate(query, outputDatasetName, statement, (IResultMetadata)resultMetadata);
        ICcApplicationContext ccAppContext = metadataProvider.getApplicationContext();
        CompilerProperties compilerProperties = ccAppContext.getCompilerProperties();
        Map<String, Object> querySpecificConfig = this.validateConfig(metadataProvider.getConfig(), sourceLoc);
        PhysicalOptimizationConfig physOptConf = OptimizationConfUtil.createPhysicalOptimizationConf((CompilerProperties)compilerProperties, querySpecificConfig, this.configurableParameterNames, (SourceLocation)sourceLoc);
        boolean cboMode = physOptConf.getCBOMode() || physOptConf.getCBOTestMode();
        HeuristicCompilerFactoryBuilder builder = new HeuristicCompilerFactoryBuilder((IOptimizationContextFactory)OptimizationContextFactory.INSTANCE);
        builder.setPhysicalOptimizationConfig(physOptConf);
        builder.setLogicalRewrites(() -> this.ruleSetFactory.getLogicalRewrites(ccAppContext));
        builder.setLogicalRewritesByKind(kind -> this.ruleSetFactory.getLogicalRewrites(kind, ccAppContext));
        builder.setPhysicalRewrites(() -> this.ruleSetFactory.getPhysicalRewrites(ccAppContext));
        IDataFormat format = metadataProvider.getDataFormat();
        ICompilerFactory compilerFactory = builder.create();
        builder.setExpressionEvalSizeComputer(format.getExpressionEvalSizeComputer());
        builder.setIMergeAggregationExpressionFactory((IMergeAggregationExpressionFactory)new MergeAggregationExpressionFactory());
        builder.setPartialAggregationTypeComputer((IPartialAggregationTypeComputer)new PartialAggregationTypeComputer());
        builder.setExpressionTypeComputer((IExpressionTypeComputer)ExpressionTypeComputer.INSTANCE);
        builder.setMissableTypeComputer((IMissableTypeComputer)MissableTypeComputer.INSTANCE);
        builder.setConflictingTypeResolver((IConflictingTypeResolver)ConflictingTypeResolver.INSTANCE);
        builder.setWarningCollector(warningCollector);
        builder.setMaxWarnings(conf.getMaxWarnings());
        if ((isQuery || isLoad || isCopy) && !conf.is("format-only-physical-ops") && conf.is("oob-logical-plan")) {
            this.generateLogicalPlan(plan, output.config().getPlanFormat(), cboMode);
        }
        int parallelism = APIFramework.getParallelism((String)querySpecificConfig.get(CompilerProperties.COMPILER_PARALLELISM_KEY), compilerProperties.getParallelism());
        AlgebricksAbsolutePartitionConstraint computationLocations = APIFramework.chooseLocations(clusterInfoCollector, parallelism, metadataProvider.getClusterLocations());
        builder.setClusterLocations(computationLocations);
        builder.setBinaryBooleanInspectorFactory(format.getBinaryBooleanInspectorFactory());
        builder.setBinaryIntegerInspectorFactory(format.getBinaryIntegerInspectorFactory());
        builder.setComparatorFactoryProvider(format.getBinaryComparatorFactoryProvider());
        builder.setExpressionRuntimeProvider((IExpressionRuntimeProvider)new ExpressionRuntimeProvider((ILogicalExpressionJobGen)new QueryLogicalExpressionJobGen(metadataProvider.getFunctionManager())));
        builder.setHashFunctionFactoryProvider(format.getBinaryHashFunctionFactoryProvider());
        builder.setHashFunctionFamilyProvider(format.getBinaryHashFunctionFamilyProvider());
        builder.setMissingWriterFactory(format.getMissingWriterFactory());
        builder.setNullWriterFactory(format.getNullWriterFactory());
        builder.setUnnestingPositionWriterFactory(format.getUnnestingPositionWriterFactory());
        builder.setPredicateEvaluatorFactoryProvider(format.getPredicateEvaluatorFactoryProvider());
        builder.setPrinterProvider(this.getPrinterFactoryProvider(format, conf.fmt()));
        builder.setWriterFactory((IAWriterFactory)PrinterBasedWriterFactory.INSTANCE);
        builder.setResultSerializerFactoryProvider((IResultSerializerFactoryProvider)ResultSerializerFactoryProvider.INSTANCE);
        builder.setSerializerDeserializerProvider(format.getSerdeProvider());
        builder.setTypeTraitProvider(format.getTypeTraitProvider());
        builder.setNormalizedKeyComputerFactoryProvider(format.getNormalizedKeyComputerFactoryProvider());
        ICompiler compiler = compilerFactory.createCompiler(plan, (IMetadataProvider)metadataProvider, t.getVarCounter());
        if (conf.isOptimize()) {
            compiler.optimize();
            if (conf.is("oob-optimized-logical-plan") || isExplainOnly) {
                if (conf.is("format-only-physical-ops")) {
                    AlgebricksStringBuilderWriter buf = new AlgebricksStringBuilderWriter(256);
                    PlanPrettyPrinter.printPhysicalOps((ILogicalPlan)plan, (AlgebricksStringBuilderWriter)buf, (int)0, (boolean)true);
                    output.out().write(buf.toString());
                } else if (isQuery || isLoad || isCopy) {
                    this.generateOptimizedLogicalPlan(plan, output.config().getPlanFormat(), cboMode);
                }
            }
        }
        if (conf.getClientType() == SessionConfig.ClientType.JDBC) {
            this.executionPlans.setStatementCategory(Statement.Category.toString((byte)this.getStatementCategory(query, statement)));
            if (!conf.isExecuteQuery()) {
                String stmtParams = ResultUtil.ParseOnlyResult.printStatementParameters(externalVars.keySet(), v -> v);
                this.executionPlans.setStatementParameters(stmtParams);
            }
            if (isExplainOnly) {
                this.executionPlans.setExplainOnly(true);
            } else if (isQuery) {
                this.executionPlans.setSignature(SignaturePrinter.generateFlatSignature(resultMetadata));
            }
        }
        boolean bl2 = printSignature = isQuery && requestParameters != null && requestParameters.isPrintSignature();
        if (printSignature && !isExplainOnly) {
            printer.addResultPrinter((IResponseFieldPrinter)SignaturePrinter.newInstance(this.executionPlans));
        }
        if (!conf.isGenerateJobSpec()) {
            if (isQuery || isLoad || isCopy) {
                this.generateOptimizedLogicalPlan(plan, output.config().getPlanFormat(), cboMode);
            }
            return null;
        }
        JobEventListenerFactory jobEventListenerFactory = new JobEventListenerFactory(txnId, metadataProvider.isWriteTransaction());
        JobSpecification spec = compiler.createJob((Object)ccAppContext, (IJobletEventListenerFactory)jobEventListenerFactory, runtimeFlags);
        if (!(!isQuery && !isCopy || compiler.skipJobCapacityAssignment() || requestParameters != null && requestParameters.isSkipAdmissionPolicy())) {
            INodeJobTracker nodeJobTracker = ccAppContext.getNodeJobTracker();
            AlgebricksAbsolutePartitionConstraint jobLocations = APIFramework.getJobLocations(spec, nodeJobTracker, computationLocations);
            IClusterCapacity jobRequiredCapacity = ResourceUtils.getRequiredCapacity(plan, jobLocations, physOptConf);
            spec.setRequiredClusterCapacity(jobRequiredCapacity);
        }
        if ((conf.is("oob-optimized-logical-plan") || isExplainOnly) && (isQuery || isLoad || isCopy)) {
            this.generateOptimizedLogicalPlan(plan, spec.getLogical2PhysicalMap(), output.config().getPlanFormat(), cboMode);
            if (runtimeFlags.contains(JobFlag.PROFILE_RUNTIME)) {
                this.lastPlan = new PlanInfo(plan, spec.getLogical2PhysicalMap(), cboMode, output.config().getPlanFormat());
            }
        }
        if (isExplainOnly) {
            this.printPlanAsResult(metadataProvider, output, printer, printSignature);
            if (!conf.is("oob-optimized-logical-plan")) {
                this.executionPlans.setOptimizedLogicalPlan(null);
            }
            return null;
        }
        if (isQuery && conf.is("oob-hyracks-job")) {
            this.generateJob(spec);
        }
        return spec;
    }

    private void printPlanAsResult(MetadataProvider metadataProvider, SessionOutput output, IResponsePrinter printer, boolean printSignature) throws AlgebricksException {
        try {
            if (printSignature) {
                printer.addResultPrinter((IResponseFieldPrinter)SignaturePrinter.INSTANCE);
            }
            printer.addResultPrinter((IResponseFieldPrinter)new ExplainOnlyResultsPrinter((IApplicationContext)metadataProvider.getApplicationContext(), this.executionPlans.getOptimizedLogicalPlan(), output));
            printer.printResults();
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    protected IPrinterFactoryProvider getPrinterFactoryProvider(IDataFormat format, SessionConfig.OutputFormat outputFormat) throws AlgebricksException {
        switch (outputFormat) {
            case LOSSLESS_JSON: {
                return format.getLosslessJSONPrinterFactoryProvider();
            }
            case LOSSLESS_ADM_JSON: {
                return format.getLosslessADMJSONPrinterFactoryProvider();
            }
            case CSV: {
                return format.getCSVPrinterFactoryProvider();
            }
            case ADM: {
                return format.getADMPrinterFactoryProvider();
            }
            case CLEAN_JSON: {
                return format.getCleanJSONPrinterFactoryProvider();
            }
        }
        throw new AlgebricksException("Unexpected OutputFormat: " + outputFormat);
    }

    private IPlanPrettyPrinter getPrettyPrintVisitor(SessionConfig.PlanFormat planFormat) {
        return planFormat.equals((Object)SessionConfig.PlanFormat.JSON) ? PlanPrettyPrinter.createJsonPlanPrettyPrinter() : PlanPrettyPrinter.createStringPlanPrettyPrinter();
    }

    private byte getStatementCategory(Query query, CompiledStatements.ICompiledStatement statement) {
        return statement != null && statement.getKind() != Statement.Kind.COPY_TO ? ((CompiledStatements.ICompiledDmlStatement)statement).getCategory() : (query != null ? (byte)1 : 4);
    }

    public void executeJobArray(IHyracksClientConnection hcc, JobSpecification[] specs, PrintWriter out) throws Exception {
        for (JobSpecification spec : specs) {
            spec.setMaxReattempts(0);
            JobId jobId = hcc.startJob(spec);
            long startTime = System.currentTimeMillis();
            hcc.waitForCompletion(jobId);
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            out.println("<pre>Duration: " + duration + " sec</pre>");
        }
    }

    public void executeJobArray(IHyracksClientConnection hcc, Job[] jobs, PrintWriter out) throws Exception {
        for (Job job : jobs) {
            job.getJobSpec().setMaxReattempts(0);
            long startTime = System.currentTimeMillis();
            try {
                JobId jobId = hcc.startJob(job.getJobSpec());
                if (job.getSubmissionMode() == Job.SubmissionMode.ASYNCHRONOUS) continue;
                hcc.waitForCompletion(jobId);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            out.println("<pre>Duration: " + duration + " sec</pre>");
        }
    }

    public ExecutionPlans getExecutionPlans() {
        return this.executionPlans;
    }

    private static AlgebricksAbsolutePartitionConstraint chooseLocations(IClusterInfoCollector clusterInfoCollector, int parallelismHint, AlgebricksAbsolutePartitionConstraint storageLocations) throws AlgebricksException {
        try {
            Map ncMap = clusterInfoCollector.getNodeControllerInfos();
            int totalNumCores = APIFramework.getTotalNumCores(ncMap);
            if (parallelismHint == 0 && storageLocations.getLocations().length <= totalNumCores) {
                return storageLocations;
            }
            return APIFramework.getComputationLocations(ncMap, parallelismHint);
        }
        catch (HyracksException e) {
            throw new AlgebricksException((Throwable)e);
        }
    }

    private static AlgebricksAbsolutePartitionConstraint getComputationLocations(Map<String, NodeControllerInfo> ncMap, int parallelismHint) {
        int parallelism = parallelismHint <= 0 ? -2 * ncMap.size() : parallelismHint;
        int numNodes = ncMap.size();
        int numNodesWithOneMorePartition = parallelism % numNodes;
        int perNodeParallelismMin = parallelism / numNodes;
        int perNodeParallelismMax = parallelism / numNodes + 1;
        ArrayList allNodes = new ArrayList();
        HashSet<String> selectedNodesWithOneMorePartition = new HashSet<String>();
        ncMap.forEach((key, value) -> allNodes.add(key));
        Random random = new Random();
        for (int index = numNodesWithOneMorePartition; index >= 1; --index) {
            int pick = random.nextInt(index);
            selectedNodesWithOneMorePartition.add((String)allNodes.get(pick));
            Collections.swap(allNodes, pick, index - 1);
        }
        ArrayList locations = new ArrayList();
        ncMap.forEach((nodeId, value) -> {
            int availableCores = value.getNumAvailableCores();
            int nodeParallelism = selectedNodesWithOneMorePartition.contains(nodeId) ? perNodeParallelismMax : perNodeParallelismMin;
            int coresToUse = nodeParallelism >= 0 && nodeParallelism < availableCores ? nodeParallelism : availableCores;
            for (int count = 0; count < coresToUse; ++count) {
                locations.add(nodeId);
            }
        });
        return new AlgebricksAbsolutePartitionConstraint(locations.toArray(new String[0]));
    }

    private static int getTotalNumCores(Map<String, NodeControllerInfo> ncMap) {
        return ncMap.values().stream().mapToInt(NodeControllerInfo::getNumAvailableCores).sum();
    }

    private static int getParallelism(String parameter, int parallelismInConfiguration) {
        IOptionType integerIPropertyInterpreter = OptionTypes.INTEGER;
        return parameter == null ? parallelismInConfiguration : (Integer)integerIPropertyInterpreter.parse(parameter);
    }

    private Map<String, Object> validateConfig(Map<String, Object> config, SourceLocation sourceLoc) throws AlgebricksException {
        for (String parameterName : config.keySet()) {
            if (this.configurableParameterNames.contains(parameterName) || parameterName.startsWith(PREFIX_INTERNAL_PARAMETERS)) continue;
            throw AsterixException.create((ErrorCode)ErrorCode.COMPILATION_UNSUPPORTED_QUERY_PARAMETER, (SourceLocation)sourceLoc, (Serializable[])new Serializable[]{parameterName});
        }
        return config;
    }

    private void generateExpressionTree(IReturningStatement statement) throws CompilationException {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            statement.accept((ILangVisitor)this.astPrintVisitorFactory.createLangVisitor(writer), (Object)0);
            this.executionPlans.setExpressionTree(stringWriter.toString());
        }
    }

    private void generateRewrittenExpressionTree(IReturningStatement statement) throws CompilationException {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            statement.accept((ILangVisitor)this.astPrintVisitorFactory.createLangVisitor(writer), (Object)0);
            this.executionPlans.setRewrittenExpressionTree(stringWriter.toString());
        }
    }

    private void generateLogicalPlan(ILogicalPlan plan, SessionConfig.PlanFormat format, boolean printOptimizerEstimates) throws AlgebricksException {
        this.executionPlans.setLogicalPlan(this.getPrettyPrintVisitor(format).printPlan(plan, printOptimizerEstimates).toString());
    }

    private void generateOptimizedLogicalPlan(ILogicalPlan plan, Map<Object, String> log2phys, SessionConfig.PlanFormat format, boolean printOptimizerEstimates) throws AlgebricksException {
        this.executionPlans.setOptimizedLogicalPlan(this.getPrettyPrintVisitor(format).printPlan(plan, log2phys, printOptimizerEstimates).toString());
    }

    public void generateOptimizedLogicalPlanWithProfile(ObjectNode profile) throws HyracksDataException {
        try {
            if (this.lastPlan != null) {
                this.executionPlans.setOptimizedLogicalPlan(this.getPrettyPrintVisitor(this.lastPlan.format).printPlan(this.lastPlan.plan, this.lastPlan.log2Phys, this.lastPlan.printOptimizerEstimates, profile).toString());
            }
        }
        catch (AlgebricksException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void generateOptimizedLogicalPlan(ILogicalPlan plan, SessionConfig.PlanFormat format, boolean printOptimizerEstimates) throws AlgebricksException {
        this.executionPlans.setOptimizedLogicalPlan(this.getPrettyPrintVisitor(format).printPlan(plan, printOptimizerEstimates).toString());
    }

    private void generateJob(JobSpecification spec) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            writer.println(OBJECT_WRITER.writeValueAsString((Object)spec.toJSON()));
            this.executionPlans.setJob(stringWriter.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static AlgebricksAbsolutePartitionConstraint getJobLocations(JobSpecification spec, INodeJobTracker jobTracker, AlgebricksAbsolutePartitionConstraint clusterLocations) {
        Set jobParticipatingNodes = jobTracker.getJobParticipatingNodes(spec, null);
        return new AlgebricksAbsolutePartitionConstraint((String[])Arrays.stream(clusterLocations.getLocations()).filter(jobParticipatingNodes::contains).toArray(String[]::new));
    }

    private class PlanInfo {
        ILogicalPlan plan;
        Map<Object, String> log2Phys;
        boolean printOptimizerEstimates;
        SessionConfig.PlanFormat format;

        public PlanInfo(ILogicalPlan plan, Map<Object, String> log2Phys, boolean printOptimizerEstimates, SessionConfig.PlanFormat format) {
            this.plan = plan;
            this.log2Phys = log2Phys;
            this.printOptimizerEstimates = printOptimizerEstimates;
            this.format = format;
        }
    }

    private static class OptimizationContextFactory
    implements IOptimizationContextFactory {
        public static final OptimizationContextFactory INSTANCE = new OptimizationContextFactory();

        private OptimizationContextFactory() {
        }

        public IOptimizationContext createOptimizationContext(int varCounter, IExpressionEvalSizeComputer expressionEvalSizeComputer, IMergeAggregationExpressionFactory mergeAggregationExpressionFactory, IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer missableTypeComputer, IConflictingTypeResolver conflictingTypeResolver, PhysicalOptimizationConfig physicalOptimizationConfig, AlgebricksPartitionConstraint clusterLocations, IWarningCollector warningCollector) {
            IPlanPrettyPrinter prettyPrinter = PlanPrettyPrinter.createStringPlanPrettyPrinter();
            return new AsterixOptimizationContext((IOptimizationContextFactory)this, varCounter, expressionEvalSizeComputer, mergeAggregationExpressionFactory, expressionTypeComputer, missableTypeComputer, conflictingTypeResolver, physicalOptimizationConfig, clusterLocations, prettyPrinter, warningCollector);
        }

        public IOptimizationContext cloneOptimizationContext(IOptimizationContext oc) {
            return new AsterixOptimizationContext((AsterixOptimizationContext)oc);
        }
    }
}

