/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.asterix.common.api.IClientRequest;
import org.apache.asterix.common.api.IRequestTracker;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RequestTracker
implements IRequestTracker {
    private final Map<String, IClientRequest> runningRequests = new ConcurrentHashMap<String, IClientRequest>();
    private final Map<String, IClientRequest> clientIdRequests = new ConcurrentHashMap<String, IClientRequest>();
    private final CircularFifoQueue<IClientRequest> completedRequests;
    private final ICcApplicationContext ccAppCtx;

    public RequestTracker(ICcApplicationContext ccAppCtx) {
        this.ccAppCtx = ccAppCtx;
        this.completedRequests = new CircularFifoQueue(ccAppCtx.getExternalProperties().getRequestsArchiveSize());
    }

    public IClientRequest get(String requestId) {
        return this.runningRequests.get(requestId);
    }

    public IClientRequest getByClientContextId(String clientContextId) {
        Objects.requireNonNull(clientContextId, "clientContextId must not be null");
        return this.clientIdRequests.get(clientContextId);
    }

    public void track(IClientRequest request) {
        this.runningRequests.put(request.getId(), request);
        if (request.getClientContextId() != null) {
            this.clientIdRequests.put(request.getClientContextId(), request);
        }
    }

    public void cancel(String requestId) throws HyracksDataException {
        IClientRequest request = this.runningRequests.get(requestId);
        if (request == null) {
            return;
        }
        if (!request.isCancellable()) {
            throw new IllegalStateException("Request " + request.getId() + " cannot be cancelled");
        }
        this.cancel(request);
    }

    public void complete(String requestId) {
        IClientRequest request = this.runningRequests.get(requestId);
        if (request != null) {
            request.complete();
            this.untrack(request);
        }
    }

    public synchronized Collection<IClientRequest> getRunningRequests() {
        return Collections.unmodifiableCollection(this.runningRequests.values());
    }

    public synchronized Collection<IClientRequest> getCompletedRequests() {
        return Collections.unmodifiableCollection(new ArrayList<IClientRequest>((Collection<IClientRequest>)this.completedRequests));
    }

    private void cancel(IClientRequest request) throws HyracksDataException {
        request.cancel(this.ccAppCtx);
        this.untrack(request);
    }

    private void untrack(IClientRequest request) {
        IClientRequest completedRequest = this.runningRequests.remove(request.getId());
        if (completedRequest != null) {
            String clientContextId = completedRequest.getClientContextId();
            if (clientContextId != null) {
                this.clientIdRequests.remove(completedRequest.getClientContextId());
            }
            this.archive(completedRequest);
        }
    }

    private synchronized void archive(IClientRequest request) {
        this.completedRequests.add((Object)request);
    }
}

