/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.job.listener;

import java.util.Map;
import org.apache.asterix.common.api.IJobEventListenerFactory;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.TransactionOptions;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.job.IJobletEventListener;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobParameterByteStore;
import org.apache.hyracks.api.job.JobStatus;

public class MultiTransactionJobletEventListenerFactory
implements IJobEventListenerFactory {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, TxnId> txnIdMap;
    private final boolean transactionalWrite;

    public MultiTransactionJobletEventListenerFactory(Map<Integer, TxnId> txnIdMap, boolean transactionalWrite) {
        this.txnIdMap = txnIdMap;
        this.transactionalWrite = transactionalWrite;
    }

    public TxnId getTxnId(int datasetId) {
        return this.txnIdMap.get(datasetId);
    }

    public IJobletEventListenerFactory copyFactory() {
        return new MultiTransactionJobletEventListenerFactory(this.txnIdMap, this.transactionalWrite);
    }

    public void updateListenerJobParameters(JobParameterByteStore jobParameterByteStore) {
    }

    public IJobletEventListener createListener(final IHyracksJobletContext jobletContext) {
        return new IJobletEventListener(){

            public void jobletFinish(JobStatus jobStatus) {
                try {
                    ITransactionManager txnManager = ((INcApplicationContext)jobletContext.getServiceContext().getApplicationContext()).getTransactionSubsystem().getTransactionManager();
                    for (TxnId subTxnId : MultiTransactionJobletEventListenerFactory.this.txnIdMap.values()) {
                        ITransactionContext txnContext = txnManager.getTransactionContext(subTxnId);
                        txnContext.setWriteTxn(MultiTransactionJobletEventListenerFactory.this.transactionalWrite);
                        if (jobStatus != JobStatus.FAILURE) {
                            txnManager.commitTransaction(subTxnId);
                            continue;
                        }
                        txnManager.abortTransaction(subTxnId);
                    }
                }
                catch (ACIDException e) {
                    throw new Error(e);
                }
            }

            public void jobletStart() {
                try {
                    TransactionOptions options = new TransactionOptions(ITransactionManager.AtomicityLevel.ENTITY_LEVEL);
                    for (TxnId subTxnId : MultiTransactionJobletEventListenerFactory.this.txnIdMap.values()) {
                        ((INcApplicationContext)jobletContext.getServiceContext().getApplicationContext()).getTransactionSubsystem().getTransactionManager().beginTransaction(subTxnId, options);
                    }
                }
                catch (ACIDException e) {
                    throw new Error(e);
                }
            }
        };
    }
}

