/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.BTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;

public class ArrayBTreeAccessMethod
extends BTreeAccessMethod {
    public static final ArrayBTreeAccessMethod INSTANCE = new ArrayBTreeAccessMethod();

    @Override
    public boolean matchAllIndexExprs(Index index) {
        return ((Index.ArrayIndexDetails)index.getIndexDetails()).getElementList().stream().map(e -> e.getProjectList().size()).reduce(0, Integer::sum) > 1 && this.hasUnknownableField(index);
    }

    @Override
    public boolean matchPrefixIndexExprs(Index index) {
        return !this.matchAllIndexExprs(index);
    }

    private boolean hasUnknownableField(Index index) {
        if (index.isSecondaryIndex() && index.getIndexDetails().isOverridingKeyFieldTypes() && !index.isEnforced()) {
            return true;
        }
        for (Index.ArrayIndexElement e : ((Index.ArrayIndexDetails)index.getIndexDetails()).getElementList()) {
            for (int i = 0; i < e.getProjectList().size(); ++i) {
                if (!NonTaggedFormatUtil.isOptional((IAType)((IAType)e.getTypeList().get(i)))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean applyJoinPlanTransformation(List<Mutable<ILogicalOperator>> afterJoinRefs, Mutable<ILogicalOperator> joinRef, OptimizableOperatorSubTree leftSubTree, OptimizableOperatorSubTree rightSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, IOptimizationContext context, boolean isLeftOuterJoin, boolean isLeftOuterJoinWithSpecialGroupBy, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        ILogicalOperator indexSearchOp;
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)joinRef.getValue();
        Mutable conditionRef = joinOp.getCondition();
        Dataset dataset = analysisCtx.getIndexDatasetMap().get(chosenIndex);
        if (!rightSubTree.hasDataSourceScan() || !dataset.getDatasetName().equals(rightSubTree.getDataset().getDatasetName())) {
            return false;
        }
        OptimizableOperatorSubTree indexSubTree = rightSubTree;
        OptimizableOperatorSubTree probeSubTree = leftSubTree;
        ArrayDeque<ILogicalOperator> opStack = new ArrayDeque<ILogicalOperator>();
        ArrayList<ILogicalOperator> visited = new ArrayList<ILogicalOperator>();
        opStack.add(probeSubTree.getRoot());
        while (!opStack.isEmpty()) {
            ILogicalOperator workingOp = (ILogicalOperator)opStack.pop();
            if (!visited.contains(workingOp)) {
                if (workingOp.getOperatorTag() == LogicalOperatorTag.INNERJOIN || workingOp.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
                    ArrayList conjuncts;
                    AbstractBinaryJoinOperator joinOperator = (AbstractBinaryJoinOperator)workingOp;
                    ILogicalExpression joinCondition = (ILogicalExpression)joinOperator.getCondition().getValue();
                    if (joinCondition.splitIntoConjuncts(conjuncts = new ArrayList())) {
                        for (Mutable conjunct : conjuncts) {
                            if (((ILogicalExpression)conjunct.getValue()).getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                                return false;
                            }
                            AbstractFunctionCallExpression expr = (AbstractFunctionCallExpression)joinCondition;
                            if (expr.getFunctionIdentifier() == BuiltinFunctions.EQ) continue;
                            return false;
                        }
                    } else {
                        if (joinCondition.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
                            return false;
                        }
                        AbstractFunctionCallExpression expr = (AbstractFunctionCallExpression)joinCondition;
                        if (expr.getFunctionIdentifier() != BuiltinFunctions.EQ) {
                            return false;
                        }
                    }
                }
                visited.add(workingOp);
            }
            for (Mutable opRef : workingOp.getInputs()) {
                if (visited.contains(opRef.getValue())) continue;
                opStack.push((ILogicalOperator)opRef.getValue());
            }
        }
        LogicalVariable newNullPlaceHolderVar = null;
        if (isLeftOuterJoin) {
            newNullPlaceHolderVar = indexSubTree.getDataSourceVariables().get(0);
            ILogicalOperator workingOp = indexSubTree.getRoot();
            ILogicalOperator rootOp = indexSubTree.getRoot();
            ILogicalOperator previousOp = null;
            while (!workingOp.getInputs().isEmpty()) {
                if (workingOp.getOperatorTag() == LogicalOperatorTag.UNNEST) {
                    UnnestOperator oldUnnest = (UnnestOperator)workingOp;
                    LeftOuterUnnestOperator newUnnest = new LeftOuterUnnestOperator(oldUnnest.getVariable(), (Mutable)new MutableObject((Object)((ILogicalExpression)oldUnnest.getExpressionRef().getValue())), ConstantExpression.MISSING.getValue());
                    newUnnest.setSourceLocation(oldUnnest.getSourceLocation());
                    newUnnest.getInputs().addAll(oldUnnest.getInputs());
                    newUnnest.setExecutionMode(oldUnnest.getExecutionMode());
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newUnnest);
                    if (workingOp.equals(rootOp)) {
                        rootOp = newUnnest;
                        workingOp = newUnnest;
                    } else if (previousOp != null) {
                        previousOp.getInputs().clear();
                        previousOp.getInputs().add(new MutableObject((Object)newUnnest));
                        context.computeAndSetTypeEnvironmentForOperator(previousOp);
                    }
                }
                previousOp = workingOp;
                workingOp = (ILogicalOperator)((Mutable)workingOp.getInputs().get(0)).getValue();
            }
            indexSubTree.setRoot(rootOp);
            indexSubTree.setRootRef((Mutable<ILogicalOperator>)new MutableObject((Object)rootOp));
            joinOp.getInputs().remove(1);
            joinOp.getInputs().add(1, new MutableObject((Object)rootOp));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)joinOp);
        }
        if ((indexSearchOp = this.createIndexSearchPlan(afterJoinRefs, joinRef, (Mutable<ILogicalExpression>)conditionRef, indexSubTree.getAssignsAndUnnestsRefs(), indexSubTree, probeSubTree, chosenIndex, analysisCtx, true, isLeftOuterJoin, true, context, newNullPlaceHolderVar, leftOuterMissingValue)) == null) {
            return false;
        }
        return AccessMethodUtils.finalizeJoinPlanTransformation(afterJoinRefs, joinRef, indexSubTree, probeSubTree, analysisCtx, context, isLeftOuterJoin, isLeftOuterJoinWithSpecialGroupBy, leftOuterMissingValue, indexSearchOp, newNullPlaceHolderVar, (Mutable<ILogicalExpression>)conditionRef, dataset, chosenIndex);
    }

    @Override
    public ILogicalOperator createIndexSearchPlan(List<Mutable<ILogicalOperator>> afterTopOpRefs, Mutable<ILogicalOperator> topOpRef, Mutable<ILogicalExpression> conditionRef, List<Mutable<ILogicalOperator>> assignBeforeTheOpRefs, OptimizableOperatorSubTree indexSubTree, OptimizableOperatorSubTree probeSubTree, Index chosenIndex, AccessMethodAnalysisContext analysisCtx, boolean retainInput, boolean retainMissing, boolean requiresBroadcast, IOptimizationContext context, LogicalVariable newMissingNullPlaceHolderForLOJ, IAlgebricksConstantValue leftOuterMissingValue) throws AlgebricksException {
        Index.ArrayIndexDetails chosenIndexDetails = (Index.ArrayIndexDetails)chosenIndex.getIndexDetails();
        ArrayList<List<String>> chosenIndexKeyFieldNames = new ArrayList<List<String>>();
        ArrayList<IAType> chosenIndexKeyFieldTypes = new ArrayList<IAType>();
        ArrayList<Integer> chosenIndexKeyFieldSourceIndicators = new ArrayList<Integer>();
        for (Index.ArrayIndexElement e : chosenIndexDetails.getElementList()) {
            for (int i = 0; i < e.getProjectList().size(); ++i) {
                chosenIndexKeyFieldNames.add(ArrayIndexUtil.getFlattenedKeyFieldNames((List)e.getUnnestList(), (List)((List)e.getProjectList().get(i))));
                chosenIndexKeyFieldTypes.add((IAType)e.getTypeList().get(i));
                chosenIndexKeyFieldSourceIndicators.add(e.getSourceIndicator());
            }
        }
        return this.createBTreeIndexSearchPlan(afterTopOpRefs, topOpRef, conditionRef, assignBeforeTheOpRefs, indexSubTree, probeSubTree, chosenIndex, analysisCtx, retainInput, retainMissing, requiresBroadcast, context, newMissingNullPlaceHolderForLOJ, leftOuterMissingValue, chosenIndexKeyFieldNames, chosenIndexKeyFieldTypes, chosenIndexKeyFieldSourceIndicators);
    }

    @Override
    public boolean matchIndexType(DatasetConfig.IndexType indexType) {
        return indexType == DatasetConfig.IndexType.ARRAY;
    }

    @Override
    public String getName() {
        return "ARRAY_BTREE_ACCESS_METHOD";
    }

    @Override
    public boolean acceptsFunction(AbstractFunctionCallExpression functionExpr, Index index, IAType indexedFieldType, boolean defaultNull, boolean finalStep) throws CompilationException {
        if (defaultNull) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, new Serializable[]{"CAST modifier not allowed"});
        }
        return AccessMethodUtils.isFieldAccess(functionExpr.getFunctionIdentifier());
    }

    @Override
    public int compareTo(IAccessMethod o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    protected boolean allowFunctionExpressionArg() {
        return false;
    }
}

