/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.profiling;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public class ConnectorSenderProfilingFrameWriter
implements IFrameWriter {
    private final IFrameWriter writer;
    private final ICounter openCounter;
    private final ICounter closeCounter;
    private final ICounter frameCounter;

    public ConnectorSenderProfilingFrameWriter(IHyracksTaskContext ctx, IFrameWriter writer, ConnectorDescriptorId cdId, int senderIndex, int receiverIndex) {
        this.writer = writer;
        int attempt = ctx.getTaskAttemptId().getAttempt();
        this.openCounter = ctx.getCounterContext().getCounter(cdId + ".sender." + attempt + "." + senderIndex + "." + receiverIndex + ".open", true);
        this.closeCounter = ctx.getCounterContext().getCounter(cdId + ".sender." + attempt + "." + senderIndex + "." + receiverIndex + ".close", true);
        this.frameCounter = ctx.getCounterContext().getCounter(cdId + ".sender." + attempt + "." + senderIndex + "." + receiverIndex + ".nextFrame", true);
    }

    public void open() throws HyracksDataException {
        this.writer.open();
        this.openCounter.update(1L);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.frameCounter.update(1L);
        this.writer.nextFrame(buffer);
    }

    public void close() throws HyracksDataException {
        try {
            this.closeCounter.update(1L);
        }
        finally {
            this.writer.close();
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }
}

