/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.IOException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.external.operators.AbstractLibraryOperatorDescriptor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LibraryDeployCommitOperatorDescriptor
extends AbstractLibraryOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(LibraryDeployCommitOperatorDescriptor.class);

    public LibraryDeployCommitOperatorDescriptor(IOperatorDescriptorRegistry spec, DataverseName dataverseName, String libraryName) {
        super(spec, dataverseName, libraryName);
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) {
        return new AbstractLibraryOperatorDescriptor.AbstractLibraryNodePushable(ctx){

            @Override
            protected void execute() throws IOException {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Commit deployment of library {}.{}", (Object)LibraryDeployCommitOperatorDescriptor.this.dataverseName, (Object)LibraryDeployCommitOperatorDescriptor.this.libraryName);
                }
                FileReference rev1 = this.getRev1Dir();
                FileReference stage = this.getStageDir();
                this.move(stage, rev1);
                FileReference libDir = this.getLibraryDir();
                this.flushDirectory(libDir);
            }
        };
    }
}

