/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.asterix.geo.evaluators.functions.AbstractSTSingleGeometryDescriptor;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class STMBRDescriptor
extends AbstractSTSingleGeometryDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new STMBRDescriptor();
        }
    };

    @Override
    protected Object evaluateOGCGeometry(OGCGeometry geometry) throws HyracksDataException {
        AMutableRectangle aRectangle = new AMutableRectangle(null, null);
        AMutablePoint[] aPoint = new AMutablePoint[]{new AMutablePoint(0.0, 0.0), new AMutablePoint(0.0, 0.0)};
        Envelope env = new Envelope();
        geometry.getEsriGeometry().queryEnvelope(env);
        aPoint[0].setValue(env.getXMin(), env.getYMin());
        aPoint[1].setValue(env.getXMax(), env.getYMax());
        aRectangle.setValue((APoint)aPoint[0], (APoint)aPoint[1]);
        return aRectangle;
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_MBR;
    }
}

