/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import com.google.common.math.DoubleMath;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.DoubleToInt32TypeConvertComputer;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public final class ArgumentUtils {
    public static final byte[] NUMERIC_TYPES = new byte[]{ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG};
    private static final DoubleToInt32TypeConvertComputer LAX_DOUBLE_TO_INT32 = DoubleToInt32TypeConvertComputer.getInstance((boolean)false);

    private ArgumentUtils() {
    }

    public static boolean setInteger(IEvaluatorContext ctx, SourceLocation sourceLoc, FunctionIdentifier funcID, int argIdx, byte[] value, int offset, AMutableInt32 outInteger) throws HyracksDataException {
        byte type = value[offset];
        if (ATypeHierarchy.getTypeDomain((ATypeTag)ATypeTag.VALUE_TYPE_MAPPING[type]) != ATypeHierarchy.Domain.NUMERIC) {
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)sourceLoc, (FunctionIdentifier)funcID, (byte)type, (int)argIdx, (byte[])NUMERIC_TYPES);
            return false;
        }
        double doubleValue = ATypeHierarchy.getDoubleValue((String)funcID.getName(), (int)argIdx, (byte[])value, (int)offset);
        if (!DoubleMath.isMathematicalInteger((double)doubleValue)) {
            ExceptionUtil.warnNonInteger((IEvaluatorContext)ctx, (SourceLocation)sourceLoc, (FunctionIdentifier)funcID, (int)argIdx, (double)doubleValue);
            return false;
        }
        outInteger.setValue(LAX_DOUBLE_TO_INT32.convert(doubleValue));
        return true;
    }
}

