/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiClock;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.cloud.storage.HttpRetryAlgorithmManager;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageFactory;
import com.google.cloud.storage.StorageImpl;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.spi.StorageRpcFactory;
import com.google.cloud.storage.spi.v1.HttpStorageRpc;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.HTTP})
public class HttpStorageOptions
extends StorageOptions {
    private static final long serialVersionUID = -5302637952911052045L;
    private static final String API_SHORT_NAME = "Storage";
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/devstorage.full_control");
    private static final String DEFAULT_HOST = "https://storage.googleapis.com";
    private final HttpRetryAlgorithmManager retryAlgorithmManager;
    private final RetryDependenciesAdapter retryDepsAdapter;

    private HttpStorageOptions(Builder builder, StorageOptions.StorageDefaults serviceDefaults) {
        super(builder, serviceDefaults);
        this.retryAlgorithmManager = new HttpRetryAlgorithmManager((StorageRetryStrategy)MoreObjects.firstNonNull((Object)builder.storageRetryStrategy, (Object)HttpStorageOptions.defaults().getStorageRetryStrategy()));
        this.retryDepsAdapter = new RetryDependenciesAdapter();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    @InternalApi
    HttpRetryAlgorithmManager getRetryAlgorithmManager() {
        return this.retryAlgorithmManager;
    }

    @InternalApi
    StorageRpc getStorageRpcV1() {
        return (StorageRpc)this.getRpc();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HttpStorageOptions && this.baseEquals((HttpStorageOptions)((Object)obj));
    }

    public static Builder newBuilder() {
        return new Builder().setHost(DEFAULT_HOST);
    }

    public static HttpStorageOptions getDefaultInstance() {
        return HttpStorageOptions.newBuilder().build();
    }

    public static HttpStorageDefaults defaults() {
        return HttpStorageDefaults.INSTANCE;
    }

    @InternalApi
    Retrying.RetryingDependencies asRetryDependencies() {
        return this.retryDepsAdapter;
    }

    public static class Builder
    extends StorageOptions.Builder {
        private StorageRetryStrategy storageRetryStrategy;

        Builder() {
        }

        Builder(StorageOptions options) {
            super(options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Storage.");
            }
            super.setTransportOptions(transportOptions);
            return this;
        }

        @Override
        public Builder setStorageRetryStrategy(StorageRetryStrategy storageRetryStrategy) {
            this.storageRetryStrategy = Objects.requireNonNull(storageRetryStrategy, "storageRetryStrategy must be non null");
            return this;
        }

        protected Builder self() {
            return this;
        }

        public Builder setServiceFactory(ServiceFactory<Storage, StorageOptions> serviceFactory) {
            super.setServiceFactory(serviceFactory);
            return this;
        }

        public Builder setClock(ApiClock clock) {
            super.setClock(clock);
            return this;
        }

        public Builder setProjectId(String projectId) {
            super.setProjectId(projectId);
            return this;
        }

        public Builder setHost(String host) {
            super.setHost(host);
            return this;
        }

        public Builder setCredentials(Credentials credentials) {
            super.setCredentials(credentials);
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        public Builder setServiceRpcFactory(ServiceRpcFactory<StorageOptions> serviceRpcFactory) {
            super.setServiceRpcFactory(serviceRpcFactory);
            return this;
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            super.setHeaderProvider(headerProvider);
            return this;
        }

        public Builder setClientLibToken(String clientLibToken) {
            super.setClientLibToken(clientLibToken);
            return this;
        }

        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @Override
        public HttpStorageOptions build() {
            return new HttpStorageOptions(this, HttpStorageOptions.defaults());
        }
    }

    public static final class HttpStorageDefaults
    extends StorageOptions.StorageDefaults {
        static final HttpStorageDefaults INSTANCE = new HttpStorageDefaults();
        static final StorageFactory STORAGE_FACTORY = new HttpStorageFactory();
        static final StorageRpcFactory STORAGE_RPC_FACTORY = new HttpStorageRpcFactory();

        private HttpStorageDefaults() {
        }

        public StorageFactory getDefaultServiceFactory() {
            return STORAGE_FACTORY;
        }

        public StorageRpcFactory getDefaultRpcFactory() {
            return STORAGE_RPC_FACTORY;
        }

        public HttpTransportOptions getDefaultTransportOptions() {
            return HttpTransportOptions.newBuilder().build();
        }

        public StorageRetryStrategy getStorageRetryStrategy() {
            return StorageRetryStrategy.getDefaultStorageRetryStrategy();
        }
    }

    private final class RetryDependenciesAdapter
    implements Retrying.RetryingDependencies,
    Serializable {
        private RetryDependenciesAdapter() {
        }

        @Override
        public RetrySettings getRetrySettings() {
            return HttpStorageOptions.this.getRetrySettings();
        }

        @Override
        public ApiClock getClock() {
            return HttpStorageOptions.this.getClock();
        }
    }

    @InternalApi
    public static class HttpStorageRpcFactory
    implements StorageRpcFactory,
    Serializable {
        private static final long serialVersionUID = -5896805045709989797L;

        @InternalApi
        @Deprecated
        public HttpStorageRpcFactory() {
        }

        public ServiceRpc create(StorageOptions options) {
            if (options instanceof HttpStorageOptions) {
                HttpStorageOptions httpStorageOptions = (HttpStorageOptions)options;
                return new HttpStorageRpc(httpStorageOptions);
            }
            throw new IllegalArgumentException("Only HttpStorageOptions supported");
        }
    }

    @InternalApi
    public static class HttpStorageFactory
    implements StorageFactory,
    Serializable {
        private static final long serialVersionUID = 1063208433681579145L;

        @InternalApi
        @Deprecated
        public HttpStorageFactory() {
        }

        public Storage create(StorageOptions options) {
            if (options instanceof HttpStorageOptions) {
                HttpStorageOptions httpStorageOptions = (HttpStorageOptions)options;
                return new StorageImpl(httpStorageOptions);
            }
            throw new IllegalArgumentException("Only HttpStorageOptions supported");
        }
    }
}

