/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.util.ConfigurationTypeValidator;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class DatasetDeclParametersUtil {
    public static final String MERGE_POLICY_PARAMETER_NAME = "merge-policy";
    public static final String MERGE_POLICY_NAME_PARAMETER_NAME = "name";
    public static final String MERGE_POLICY_PARAMETERS_PARAMETER_NAME = "parameters";
    public static final String MERGE_POLICY_MERGABLE_SIZE_PARAMETER_NAME = "max-mergable-component-size";
    public static final String MERGE_POLICY_TOLERANCE_COUNT_PARAMETER_NAME = "max-tolerance-component-count";
    public static final String MERGE_POLICY_NUMBER_COMPONENTS_PARAMETER_NAME = "num-components";
    public static final String MERGE_POLICY_SIZE_RATIO_NAME = "size-ratio";
    public static final String MERGE_POLICY_MAX_COMPONENT_COUNT_NAME = "max-component-count";
    public static final String MERGE_POLICY_MIN_MERGE_COMPONENT_COUNT_NAME = "min-merge-component-count";
    public static final String MERGE_POLICY_MAX_MERGE_COMPONENT_COUNT_NAME = "max-merge-component-count";
    public static final String STORAGE_BLOCK_COMPRESSION_PARAMETER_NAME = "storage-block-compression";
    public static final String STORAGE_BLOCK_COMPRESSION_SCHEME_PARAMETER_NAME = "scheme";
    public static final String NODE_GROUP_NAME = "node-group";
    public static final String NODE_GROUP_NAME_PARAMETER_NAME = "name";
    private static final ARecordType WITH_OBJECT_TYPE = DatasetDeclParametersUtil.getWithObjectType();
    static final AdmObjectNode EMPTY_WITH_OBJECT = new AdmObjectNode();

    private DatasetDeclParametersUtil() {
    }

    public static AdmObjectNode validateAndGetWithObjectNode(RecordConstructor withRecord, DatasetConfig.DatasetType datasetType) throws CompilationException {
        if (withRecord == null) {
            return EMPTY_WITH_OBJECT;
        }
        if (datasetType == DatasetConfig.DatasetType.INTERNAL) {
            ConfigurationTypeValidator validator = new ConfigurationTypeValidator();
            AdmObjectNode node = ExpressionUtils.toNode(withRecord);
            validator.validateType((IAType)WITH_OBJECT_TYPE, (IAdmNode)node);
            return node;
        }
        return ExpressionUtils.toNode(withRecord);
    }

    private static ARecordType getWithObjectType() {
        String[] withNames = new String[]{MERGE_POLICY_PARAMETER_NAME, STORAGE_BLOCK_COMPRESSION_PARAMETER_NAME, NODE_GROUP_NAME};
        IAType[] withTypes = new IAType[]{AUnionType.createUnknownableType((IAType)DatasetDeclParametersUtil.getMergePolicyType()), AUnionType.createUnknownableType((IAType)DatasetDeclParametersUtil.getStorageBlockCompressionType()), AUnionType.createUnknownableType((IAType)DatasetDeclParametersUtil.getNodeGroupType())};
        return new ARecordType("withObject", withNames, withTypes, false);
    }

    private static ARecordType getMergePolicyType() {
        String[] parameterNames = new String[]{MERGE_POLICY_MERGABLE_SIZE_PARAMETER_NAME, MERGE_POLICY_TOLERANCE_COUNT_PARAMETER_NAME, MERGE_POLICY_NUMBER_COMPONENTS_PARAMETER_NAME, MERGE_POLICY_SIZE_RATIO_NAME, MERGE_POLICY_MAX_COMPONENT_COUNT_NAME, MERGE_POLICY_MIN_MERGE_COMPONENT_COUNT_NAME, MERGE_POLICY_MAX_MERGE_COMPONENT_COUNT_NAME};
        IAType[] parametersTypes = new IAType[]{AUnionType.createUnknownableType((IAType)BuiltinType.AINT64), AUnionType.createUnknownableType((IAType)BuiltinType.AINT64), AUnionType.createUnknownableType((IAType)BuiltinType.AINT64), AUnionType.createUnknownableType((IAType)BuiltinType.ADOUBLE), AUnionType.createUnknownableType((IAType)BuiltinType.AINT64), AUnionType.createUnknownableType((IAType)BuiltinType.AINT64), AUnionType.createUnknownableType((IAType)BuiltinType.AINT64)};
        ARecordType parameters = new ARecordType(MERGE_POLICY_PARAMETERS_PARAMETER_NAME, parameterNames, parametersTypes, false);
        String[] mergePolicyNames = new String[]{"name", MERGE_POLICY_PARAMETERS_PARAMETER_NAME};
        IAType[] mergePolicyTypes = new IAType[]{BuiltinType.ASTRING, AUnionType.createUnknownableType((IAType)parameters)};
        return new ARecordType(MERGE_POLICY_PARAMETER_NAME, mergePolicyNames, mergePolicyTypes, false);
    }

    private static ARecordType getStorageBlockCompressionType() {
        String[] schemeName = new String[]{STORAGE_BLOCK_COMPRESSION_SCHEME_PARAMETER_NAME};
        IAType[] schemeType = new IAType[]{BuiltinType.ASTRING};
        return new ARecordType(STORAGE_BLOCK_COMPRESSION_PARAMETER_NAME, schemeName, schemeType, false);
    }

    private static ARecordType getNodeGroupType() {
        String[] schemeName = new String[]{"name"};
        IAType[] schemeType = new IAType[]{BuiltinType.ASTRING};
        return new ARecordType(NODE_GROUP_NAME, schemeName, schemeType, false);
    }

    public static void adjustInlineTypeDecl(TypeExpression typeDecl, List<List<String>> primaryKeyFields, List<Integer> primaryKeySources, boolean isMeta) {
        switch (typeDecl.getTypeKind()) {
            case RECORD: {
                RecordTypeDefinition recordTypeDef = (RecordTypeDefinition)typeDecl;
                int n = primaryKeyFields.size();
                for (int i = 0; i < n; ++i) {
                    int fieldIdx;
                    boolean isSameSource;
                    List<String> primaryKeyPath = primaryKeyFields.get(i);
                    if (primaryKeyPath.size() != 1) continue;
                    String primaryKeyFieldName = primaryKeyPath.get(0);
                    boolean isMetaSource = primaryKeySources != null && primaryKeySources.get(i) == 1;
                    boolean bl = isSameSource = isMetaSource == isMeta;
                    if (!isSameSource || (fieldIdx = recordTypeDef.getFieldNames().indexOf(primaryKeyFieldName)) < 0) continue;
                    recordTypeDef.getMissableFields().set(fieldIdx, false);
                    recordTypeDef.getNullableFields().set(fieldIdx, false);
                }
                break;
            }
            case TYPEREFERENCE: {
                break;
            }
            default: {
                throw new IllegalStateException(typeDecl.getTypeKind().toString());
            }
        }
    }
}

