/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.util.EnumSet;
import java.util.List;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.profiling.IOperatorStats;

public class JobUtils {
    public static JobId runJob(IHyracksClientConnection hcc, JobSpecification spec, boolean waitForCompletion) throws Exception {
        return JobUtils.runJob(hcc, spec, EnumSet.noneOf(JobFlag.class), waitForCompletion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobId runJob(IHyracksClientConnection hcc, JobSpecification spec, EnumSet<JobFlag> jobFlags, boolean waitForCompletion) throws Exception {
        spec.setMaxReattempts(0);
        JobId jobId = hcc.startJob(spec, jobFlags);
        if (waitForCompletion) {
            String nameBefore = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(nameBefore + " : WaitForCompletionForJobId: " + jobId);
                hcc.waitForCompletion(jobId);
            }
            finally {
                Thread.currentThread().setName(nameBefore);
            }
        }
        return jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<JobId, List<IOperatorStats>> runJob(IHyracksClientConnection hcc, JobSpecification spec, EnumSet<JobFlag> jobFlags, boolean waitForCompletion, List<String> statOperatorNames) throws Exception {
        spec.setMaxReattempts(0);
        JobId jobId = hcc.startJob(spec, jobFlags);
        List opStats = null;
        if (waitForCompletion) {
            String nameBefore = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(nameBefore + " : WaitForCompletionForJobId: " + jobId);
                opStats = hcc.waitForCompletion(jobId, statOperatorNames);
            }
            finally {
                Thread.currentThread().setName(nameBefore);
            }
        }
        return new Pair((Object)jobId, opStats);
    }

    public static enum ProgressState {
        NO_PROGRESS,
        ADDED_PENDINGOP_RECORD_TO_METADATA;

    }
}

