/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractUnaryNumericFunctionEval;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;

@MissingNullInOutFunction
public class NumericRoundHalfToEvenDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new NumericRoundHalfToEvenDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.NUMERIC_ROUND_HALF_TO_EVEN;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new RoundHalfToEvenEvaluator(ctx, args[0], NumericRoundHalfToEvenDescriptor.this.getIdentifier(), NumericRoundHalfToEvenDescriptor.this.sourceLoc);
            }
        };
    }

    private static class RoundHalfToEvenEvaluator
    extends AbstractUnaryNumericFunctionEval {
        RoundHalfToEvenEvaluator(IEvaluatorContext context, IScalarEvaluatorFactory argEvalFactory, FunctionIdentifier funID, SourceLocation sourceLocation) throws HyracksDataException {
            super(context, argEvalFactory, funID, sourceLocation);
        }

        @Override
        protected void processInt8(byte arg, IPointable resultPointable) throws HyracksDataException {
            resultPointable.set((IValueReference)this.argPtr);
        }

        @Override
        protected void processInt16(short arg, IPointable resultPointable) throws HyracksDataException {
            resultPointable.set((IValueReference)this.argPtr);
        }

        @Override
        protected void processInt32(int arg, IPointable resultPointable) throws HyracksDataException {
            resultPointable.set((IValueReference)this.argPtr);
        }

        @Override
        protected void processInt64(long arg, IPointable resultPointable) throws HyracksDataException {
            resultPointable.set((IValueReference)this.argPtr);
        }

        @Override
        protected void processFloat(float arg, IPointable resultPointable) throws HyracksDataException {
            this.aFloat.setValue((float)Math.rint(arg));
            this.serialize((IAObject)this.aFloat, this.floatSerde, resultPointable);
        }

        @Override
        protected void processDouble(double arg, IPointable resultPointable) throws HyracksDataException {
            this.aDouble.setValue(Math.rint(arg));
            this.serialize((IAObject)this.aDouble, this.doubleSerde, resultPointable);
        }
    }
}

