/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.HttpGetterInfo;
import com.azure.storage.blob.ProgressReporter;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlobCopyFromURLHeaders;
import com.azure.storage.blob.implementation.models.BlobCreateSnapshotHeaders;
import com.azure.storage.blob.implementation.models.BlobGetAccountInfoHeaders;
import com.azure.storage.blob.implementation.models.BlobGetPropertiesHeaders;
import com.azure.storage.blob.implementation.models.BlobStartCopyFromURLHeaders;
import com.azure.storage.blob.implementation.models.BlobsDownloadResponse;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.BlobSasImplUtil;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.models.RehydratePriority;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.ReliableDownload;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple3;

public class BlobAsyncClientBase {
    private final ClientLogger logger = new ClientLogger(BlobAsyncClientBase.class);
    protected final AzureBlobStorageImpl azureBlobStorage;
    private final String snapshot;
    private final CpkInfo customerProvidedKey;
    protected final EncryptionScope encryptionScope;
    protected final String accountName;
    protected final String containerName;
    protected final String blobName;
    protected final BlobServiceVersion serviceVersion;

    protected BlobAsyncClientBase(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey) {
        this(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, null);
    }

    protected BlobAsyncClientBase(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope) {
        this.azureBlobStorage = new AzureBlobStorageBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).build();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.containerName = containerName;
        this.blobName = Utility.urlEncode((String)Utility.urlDecode((String)blobName));
        this.snapshot = snapshot;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
    }

    protected String getEncryptionScope() {
        if (this.encryptionScope == null) {
            return null;
        }
        return this.encryptionScope.getEncryptionScope();
    }

    public BlobAsyncClientBase getSnapshotClient(String snapshot) {
        return new BlobAsyncClientBase(this.getHttpPipeline(), this.getBlobUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), snapshot, this.getCustomerProvidedKey(), this.encryptionScope);
    }

    public String getBlobUrl() {
        if (!this.isSnapshot()) {
            return this.azureBlobStorage.getUrl();
        }
        if (this.azureBlobStorage.getUrl().contains("?")) {
            return String.format("%s&snapshot=%s", this.azureBlobStorage.getUrl(), this.snapshot);
        }
        return String.format("%s?snapshot=%s", this.azureBlobStorage.getUrl(), this.snapshot);
    }

    public final String getContainerName() {
        return this.containerName;
    }

    public final String getBlobName() {
        return this.blobName == null ? null : Utility.urlDecode((String)this.blobName);
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public String getSnapshotId() {
        return this.snapshot;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    public Mono<Boolean> exists() {
        try {
            return this.existsWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Boolean>> existsWithResponse() {
        try {
            return FluxUtil.withContext(this::existsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Boolean>> existsWithResponse(Context context) {
        return this.getPropertiesWithResponse(null, context).map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)((Object)((Object)t))).getStatusCode() == 404, t -> {
            HttpResponse response = ((BlobStorageException)((Object)((Object)t))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false));
        });
    }

    public PollerFlux<BlobCopyInfo, Void> beginCopy(String sourceUrl, Duration pollInterval) {
        return this.beginCopy(sourceUrl, null, null, null, null, null, pollInterval);
    }

    public PollerFlux<BlobCopyInfo, Void> beginCopy(String sourceUrl, Map<String, String> metadata, AccessTier tier, RehydratePriority priority, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Duration pollInterval) {
        Duration interval = pollInterval != null ? pollInterval : Duration.ofSeconds(1L);
        RequestConditions sourceModifiedCondition = sourceModifiedRequestConditions == null ? new RequestConditions() : sourceModifiedRequestConditions;
        BlobRequestConditions destinationRequestConditions = destRequestConditions == null ? new BlobRequestConditions() : destRequestConditions;
        RequestConditions sourceConditions = new RequestConditions().setIfModifiedSince(sourceModifiedCondition.getIfModifiedSince()).setIfUnmodifiedSince(sourceModifiedCondition.getIfUnmodifiedSince()).setIfMatch(sourceModifiedCondition.getIfMatch()).setIfNoneMatch(sourceModifiedCondition.getIfNoneMatch());
        return new PollerFlux(interval, pollingContext -> {
            try {
                return this.onStart(sourceUrl, metadata, tier, priority, sourceConditions, destinationRequestConditions);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        }, pollingContext -> {
            try {
                return this.onPoll((PollResponse<BlobCopyInfo>)pollingContext.getLatestResponse());
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        }, (pollingContext, firstResponse) -> {
            if (firstResponse == null || firstResponse.getValue() == null) {
                return Mono.error((Throwable)this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot cancel a poll response that never started.")));
            }
            String copyIdentifier = ((BlobCopyInfo)firstResponse.getValue()).getCopyId();
            if (!CoreUtils.isNullOrEmpty((CharSequence)copyIdentifier)) {
                this.logger.info("Cancelling copy operation for copy id: {}", new Object[]{copyIdentifier});
                return this.abortCopyFromUrl(copyIdentifier).thenReturn((Object)((BlobCopyInfo)firstResponse.getValue()));
            }
            return Mono.empty();
        }, pollingContext -> Mono.empty());
    }

    private Mono<BlobCopyInfo> onStart(String sourceUrl, Map<String, String> metadata, AccessTier tier, RehydratePriority priority, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destinationRequestConditions) {
        URL url;
        try {
            url = new URL(sourceUrl);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sourceUrl' is not a valid url.", ex));
        }
        return FluxUtil.withContext(context -> this.azureBlobStorage.blobs().startCopyFromURLWithRestResponseAsync(null, null, url, null, metadata, tier, priority, sourceModifiedRequestConditions.getIfModifiedSince(), sourceModifiedRequestConditions.getIfUnmodifiedSince(), sourceModifiedRequestConditions.getIfMatch(), sourceModifiedRequestConditions.getIfNoneMatch(), destinationRequestConditions.getIfModifiedSince(), destinationRequestConditions.getIfUnmodifiedSince(), destinationRequestConditions.getIfMatch(), destinationRequestConditions.getIfNoneMatch(), destinationRequestConditions.getLeaseId(), null, (Context)context)).map(response -> {
            BlobStartCopyFromURLHeaders headers = (BlobStartCopyFromURLHeaders)response.getDeserializedHeaders();
            return new BlobCopyInfo(sourceUrl, headers.getCopyId(), headers.getCopyStatus(), headers.getETag(), headers.getLastModified(), headers.getErrorCode());
        });
    }

    private Mono<PollResponse<BlobCopyInfo>> onPoll(PollResponse<BlobCopyInfo> pollResponse) {
        if (pollResponse.getStatus() == LongRunningOperationStatus.SUCCESSFULLY_COMPLETED || pollResponse.getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.just(pollResponse);
        }
        BlobCopyInfo lastInfo = (BlobCopyInfo)pollResponse.getValue();
        if (lastInfo == null) {
            this.logger.warning("BlobCopyInfo does not exist. Activation operation failed.");
            return Mono.just((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"COPY_START_FAILED", (boolean)true), null));
        }
        return this.getProperties().map(response -> {
            LongRunningOperationStatus operationStatus;
            CopyStatusType status = response.getCopyStatus();
            BlobCopyInfo result = new BlobCopyInfo(response.getCopySource(), response.getCopyId(), status, response.getETag(), response.getCopyCompletionTime(), response.getCopyStatusDescription());
            switch (status) {
                case SUCCESS: {
                    operationStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                    break;
                }
                case FAILED: {
                    operationStatus = LongRunningOperationStatus.FAILED;
                    break;
                }
                case ABORTED: {
                    operationStatus = LongRunningOperationStatus.USER_CANCELLED;
                    break;
                }
                case PENDING: {
                    operationStatus = LongRunningOperationStatus.IN_PROGRESS;
                    break;
                }
                default: {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("CopyStatusType is not supported. Status: " + (Object)((Object)status)));
                }
            }
            return new PollResponse(operationStatus, (Object)result);
        }).onErrorReturn((Object)new PollResponse(LongRunningOperationStatus.fromString((String)"POLLING_FAILED", (boolean)true), (Object)lastInfo));
    }

    public Mono<Void> abortCopyFromUrl(String copyId) {
        try {
            return this.abortCopyFromUrlWithResponse(copyId, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> abortCopyFromUrlWithResponse(String copyId, String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.abortCopyFromUrlWithResponse(copyId, leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> abortCopyFromUrlWithResponse(String copyId, String leaseId, Context context) {
        return this.azureBlobStorage.blobs().abortCopyFromURLWithRestResponseAsync(null, null, copyId, null, leaseId, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<String> copyFromUrl(String copySource) {
        try {
            return this.copyFromUrlWithResponse(copySource, null, null, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<String>> copyFromUrlWithResponse(String copySource, Map<String, String> metadata, AccessTier tier, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.copyFromUrlWithResponse(copySource, metadata, tier, sourceModifiedRequestConditions, destRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> copyFromUrlWithResponse(String copySource, Map<String, String> metadata, AccessTier tier, RequestConditions sourceModifiedRequestConditions, BlobRequestConditions destRequestConditions, Context context) {
        URL url;
        sourceModifiedRequestConditions = sourceModifiedRequestConditions == null ? new RequestConditions() : sourceModifiedRequestConditions;
        destRequestConditions = destRequestConditions == null ? new BlobRequestConditions() : destRequestConditions;
        try {
            url = new URL(copySource);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'copySource' is not a valid url."));
        }
        return this.azureBlobStorage.blobs().copyFromURLWithRestResponseAsync(null, null, url, null, metadata, tier, sourceModifiedRequestConditions.getIfModifiedSince(), sourceModifiedRequestConditions.getIfUnmodifiedSince(), sourceModifiedRequestConditions.getIfMatch(), sourceModifiedRequestConditions.getIfNoneMatch(), destRequestConditions.getIfModifiedSince(), destRequestConditions.getIfUnmodifiedSince(), destRequestConditions.getIfMatch(), destRequestConditions.getIfNoneMatch(), destRequestConditions.getLeaseId(), null, null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobCopyFromURLHeaders)rb.getDeserializedHeaders()).getCopyId()));
    }

    public Flux<ByteBuffer> download() {
        try {
            return this.downloadWithResponse(null, null, null, false).flatMapMany(ResponseBase::getValue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<BlobDownloadAsyncResponse> downloadWithResponse(BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5) {
        try {
            return FluxUtil.withContext(context -> this.downloadWithResponse(range, options, requestConditions, getRangeContentMd5, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<BlobDownloadAsyncResponse> downloadWithResponse(BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Context context) {
        return this.downloadHelper(range, options, requestConditions, getRangeContentMd5, context).map(response -> new BlobDownloadAsyncResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), response.getValue(), response.getDeserializedHeaders()));
    }

    private Mono<ReliableDownload> downloadHelper(BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Context context) {
        range = range == null ? new BlobRange(0L) : range;
        Boolean getMD5 = getRangeContentMd5 ? Boolean.valueOf(getRangeContentMd5) : null;
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        HttpGetterInfo info = new HttpGetterInfo().setOffset(range.getOffset()).setCount(range.getCount()).setETag(requestConditions.getIfMatch());
        return this.azureBlobStorage.blobs().downloadWithRestResponseAsync(null, null, this.snapshot, null, range.toHeaderValue(), requestConditions.getLeaseId(), getMD5, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, this.customerProvidedKey, context).map(response -> {
            info.setETag(((BlobDownloadHeaders)response.getDeserializedHeaders()).getETag());
            return new ReliableDownload((BlobsDownloadResponse)response, options, info, updatedInfo -> this.downloadHelper(new BlobRange(updatedInfo.getOffset(), updatedInfo.getCount()), options, new BlobRequestConditions().setIfMatch(info.getETag()), false, context));
        });
    }

    public Mono<BlobProperties> downloadToFile(String filePath) {
        return this.downloadToFile(filePath, false);
    }

    public Mono<BlobProperties> downloadToFile(String filePath, boolean overwrite) {
        try {
            HashSet<OpenOption> openOptions = null;
            if (overwrite) {
                openOptions = new HashSet<OpenOption>();
                openOptions.add(StandardOpenOption.CREATE);
                openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                openOptions.add(StandardOpenOption.READ);
                openOptions.add(StandardOpenOption.WRITE);
            }
            return this.downloadToFileWithResponse(filePath, null, null, null, null, false, openOptions).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobProperties>> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean rangeGetContentMd5) {
        return this.downloadToFileWithResponse(filePath, range, parallelTransferOptions, options, requestConditions, rangeGetContentMd5, null);
    }

    public Mono<Response<BlobProperties>> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions) {
        try {
            return FluxUtil.withContext(context -> this.downloadToFileWithResponse(filePath, range, parallelTransferOptions, options, requestConditions, rangeGetContentMd5, openOptions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobProperties>> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions, Context context) {
        BlobRequestConditions finalConditions;
        BlobRange finalRange = range == null ? new BlobRange(0L) : range;
        ParallelTransferOptions finalParallelTransferOptions = ModelHelper.populateAndApplyDefaults(parallelTransferOptions);
        BlobRequestConditions blobRequestConditions = finalConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (openOptions == null) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE_NEW);
            openOptions.add(StandardOpenOption.WRITE);
            openOptions.add(StandardOpenOption.READ);
        }
        AsynchronousFileChannel channel = this.downloadToFileResourceSupplier(filePath, openOptions);
        return Mono.just((Object)channel).flatMap(c -> this.downloadToFileImpl((AsynchronousFileChannel)c, finalRange, finalParallelTransferOptions, downloadRetryOptions, finalConditions, rangeGetContentMd5, context)).doFinally(signalType -> this.downloadToFileCleanup(channel, filePath, (SignalType)signalType));
    }

    private AsynchronousFileChannel downloadToFileResourceSupplier(String filePath, Set<OpenOption> openOptions) {
        try {
            return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), openOptions, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    private Mono<Response<BlobProperties>> downloadToFileImpl(AsynchronousFileChannel file, BlobRange finalRange, ParallelTransferOptions finalParallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Context context) {
        ReentrantLock progressLock = new ReentrantLock();
        AtomicLong totalProgress = new AtomicLong(0L);
        return this.getSetupMono(finalRange, finalParallelTransferOptions, downloadRetryOptions, requestConditions, rangeGetContentMd5, context).flatMap(setupTuple3 -> {
            long newCount = (Long)setupTuple3.getT1();
            BlobRequestConditions finalConditions = (BlobRequestConditions)((Object)((Object)setupTuple3.getT2()));
            int numChunks = this.calculateNumBlocks(newCount, finalParallelTransferOptions.getBlockSize().intValue());
            numChunks = numChunks == 0 ? 1 : numChunks;
            BlobDownloadAsyncResponse initialResponse = (BlobDownloadAsyncResponse)((Object)((Object)setupTuple3.getT3()));
            return Flux.range((int)0, (int)numChunks).flatMap(chunkNum -> {
                if (chunkNum == 0) {
                    return BlobAsyncClientBase.writeBodyToFile(initialResponse, file, 0L, finalParallelTransferOptions, progressLock, totalProgress);
                }
                long modifier = chunkNum.longValue() * (long)finalParallelTransferOptions.getBlockSize().intValue();
                long chunkSizeActual = Math.min((long)finalParallelTransferOptions.getBlockSize().intValue(), newCount - modifier);
                BlobRange chunkRange = new BlobRange(finalRange.getOffset() + modifier, chunkSizeActual);
                return this.downloadWithResponse(chunkRange, downloadRetryOptions, finalConditions, rangeGetContentMd5, null).subscribeOn(Schedulers.elastic()).flatMap(response -> BlobAsyncClientBase.writeBodyToFile(response, file, chunkNum.intValue(), finalParallelTransferOptions, progressLock, totalProgress));
            }).then(Mono.just(BlobAsyncClientBase.buildBlobPropertiesResponse(initialResponse)));
        });
    }

    private int calculateNumBlocks(long dataSize, long blockLength) {
        int numBlocks = StrictMath.toIntExact(dataSize / blockLength);
        if (dataSize % blockLength != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }

    private Mono<Tuple3<Long, BlobRequestConditions, BlobDownloadAsyncResponse>> getSetupMono(BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Context context) {
        long initialChunkSize = range.getCount() != null && range.getCount() < (long)parallelTransferOptions.getBlockSize().intValue() ? range.getCount() : (long)parallelTransferOptions.getBlockSize().intValue();
        return this.downloadWithResponse(new BlobRange(range.getOffset(), initialChunkSize), downloadRetryOptions, requestConditions, rangeGetContentMd5, context).subscribeOn(Schedulers.elastic()).flatMap(response -> {
            BlobRequestConditions newConditions = BlobAsyncClientBase.setEtag(requestConditions, ((BlobDownloadHeaders)response.getDeserializedHeaders()).getETag());
            long totalLength = BlobAsyncClientBase.extractTotalBlobLength(((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentRange());
            long newCount = range.getCount() == null || range.getCount() > totalLength - range.getOffset() ? totalLength - range.getOffset() : range.getCount();
            return Mono.zip((Mono)Mono.just((Object)newCount), (Mono)Mono.just((Object)((Object)newConditions)), (Mono)Mono.just((Object)response));
        }).onErrorResume(BlobStorageException.class, blobStorageException -> {
            if (blobStorageException.getErrorCode() == BlobErrorCode.INVALID_RANGE && BlobAsyncClientBase.extractTotalBlobLength(blobStorageException.getResponse().getHeaders().getValue("Content-Range")) == 0L) {
                return this.downloadWithResponse(new BlobRange(0L, 0L), downloadRetryOptions, requestConditions, rangeGetContentMd5, context).subscribeOn(Schedulers.elastic()).flatMap(response -> {
                    if (response.getStatusCode() != 200) {
                        Mono.error((Throwable)new IllegalStateException("Blob was modified mid download. It was originally 0 bytes and is now larger."));
                    }
                    return Mono.zip((Mono)Mono.just((Object)0L), (Mono)Mono.just((Object)((Object)requestConditions)), (Mono)Mono.just((Object)response));
                });
            }
            return Mono.error((Throwable)((Object)blobStorageException));
        });
    }

    private static BlobRequestConditions setEtag(BlobRequestConditions requestConditions, String etag) {
        return new BlobRequestConditions().setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfModifiedSince()).setIfMatch(etag).setIfNoneMatch(requestConditions.getIfNoneMatch()).setLeaseId(requestConditions.getLeaseId());
    }

    private static Mono<Void> writeBodyToFile(BlobDownloadAsyncResponse response, AsynchronousFileChannel file, long chunkNum, ParallelTransferOptions finalParallelTransferOptions, Lock progressLock, AtomicLong totalProgress) {
        Flux<ByteBuffer> data = (Flux<ByteBuffer>)response.getValue();
        data = ProgressReporter.addParallelProgressReporting(data, finalParallelTransferOptions.getProgressReceiver(), progressLock, totalProgress);
        return FluxUtil.writeFile(data, (AsynchronousFileChannel)file, (long)(chunkNum * (long)finalParallelTransferOptions.getBlockSize().intValue()));
    }

    private static Response<BlobProperties> buildBlobPropertiesResponse(BlobDownloadAsyncResponse response) {
        long blobSize = ((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentRange() == null ? ((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentLength() : BlobAsyncClientBase.extractTotalBlobLength(((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentRange());
        BlobProperties properties = new BlobProperties(null, ((BlobDownloadHeaders)response.getDeserializedHeaders()).getLastModified(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getETag(), blobSize, ((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentType(), null, ((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentEncoding(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentDisposition(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentLanguage(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getCacheControl(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getBlobSequenceNumber(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getBlobType(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getLeaseStatus(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getLeaseState(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getLeaseDuration(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getCopyId(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getCopyStatus(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getCopySource(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getCopyProgress(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getCopyCompletionTime(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getCopyStatusDescription(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).isServerEncrypted(), null, null, null, null, null, ((BlobDownloadHeaders)response.getDeserializedHeaders()).getEncryptionKeySha256(), null, ((BlobDownloadHeaders)response.getDeserializedHeaders()).getMetadata(), ((BlobDownloadHeaders)response.getDeserializedHeaders()).getBlobCommittedBlockCount());
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)properties);
    }

    private static long extractTotalBlobLength(String contentRange) {
        return Long.parseLong(contentRange.split("/")[1]);
    }

    private void downloadToFileCleanup(AsynchronousFileChannel channel, String filePath, SignalType signalType) {
        try {
            channel.close();
            if (!signalType.equals((Object)SignalType.ON_COMPLETE)) {
                Files.deleteIfExists(Paths.get(filePath, new String[0]));
                this.logger.verbose("Downloading to file failed. Cleaning up resources.");
            }
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }

    public Mono<Void> delete() {
        try {
            return this.deleteWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> deleteWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.deleteWithResponse(deleteBlobSnapshotOptions, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteWithResponse(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        return this.azureBlobStorage.blobs().deleteWithRestResponseAsync(null, null, this.snapshot, null, requestConditions.getLeaseId(), deleteBlobSnapshotOptions, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<BlobProperties> getProperties() {
        try {
            return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobProperties>> getPropertiesWithResponse(BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPropertiesWithResponse(requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobProperties>> getPropertiesWithResponse(BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().getPropertiesWithRestResponseAsync(null, null, this.snapshot, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, this.customerProvidedKey, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            BlobGetPropertiesHeaders hd = (BlobGetPropertiesHeaders)rb.getDeserializedHeaders();
            BlobProperties properties = new BlobProperties(hd.getCreationTime(), hd.getLastModified(), hd.getETag(), hd.getContentLength() == null ? 0L : hd.getContentLength(), hd.getContentType(), hd.getContentMD5(), hd.getContentEncoding(), hd.getContentDisposition(), hd.getContentLanguage(), hd.getCacheControl(), hd.getBlobSequenceNumber(), hd.getBlobType(), hd.getLeaseStatus(), hd.getLeaseState(), hd.getLeaseDuration(), hd.getCopyId(), hd.getCopyStatus(), hd.getCopySource(), hd.getCopyProgress(), hd.getCopyCompletionTime(), hd.getCopyStatusDescription(), hd.isServerEncrypted(), hd.isIncrementalCopy(), hd.getDestinationSnapshot(), AccessTier.fromString(hd.getAccessTier()), hd.isAccessTierInferred(), ArchiveStatus.fromString(hd.getArchiveStatus()), hd.getEncryptionKeySha256(), hd.getAccessTierChangeTime(), hd.getMetadata(), hd.getBlobCommittedBlockCount());
            return new SimpleResponse((Response)rb, (Object)properties);
        });
    }

    public Mono<Void> setHttpHeaders(BlobHttpHeaders headers) {
        try {
            return this.setHttpHeadersWithResponse(headers, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setHttpHeadersWithResponse(BlobHttpHeaders headers, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setHttpHeadersWithResponse(headers, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setHttpHeadersWithResponse(BlobHttpHeaders headers, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().setHTTPHeadersWithRestResponseAsync(null, null, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, headers, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> setMetadata(Map<String, String> metadata) {
        try {
            return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.setMetadataWithResponse(metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().setMetadataWithRestResponseAsync(null, null, null, metadata, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), null, this.customerProvidedKey, this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<BlobAsyncClientBase> createSnapshot() {
        try {
            return this.createSnapshotWithResponse(null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlobAsyncClientBase>> createSnapshotWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.createSnapshotWithResponse(metadata, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<BlobAsyncClientBase>> createSnapshotWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Context context) {
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().createSnapshotWithRestResponseAsync(null, null, null, metadata, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getLeaseId(), null, this.customerProvidedKey, this.encryptionScope, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)this.getSnapshotClient(((BlobCreateSnapshotHeaders)rb.getDeserializedHeaders()).getSnapshot())));
    }

    public Mono<Void> setAccessTier(AccessTier tier) {
        try {
            return this.setAccessTierWithResponse(tier, null, null).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> setAccessTierWithResponse(AccessTier tier, RehydratePriority priority, String leaseId) {
        try {
            return FluxUtil.withContext(context -> this.setTierWithResponse(tier, priority, leaseId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setTierWithResponse(AccessTier tier, RehydratePriority priority, String leaseId, Context context) {
        StorageImplUtils.assertNotNull((String)"tier", (Object)((Object)tier));
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().setTierWithRestResponseAsync(null, null, tier, null, priority, null, leaseId, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> undelete() {
        try {
            return this.undeleteWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<Void>> undeleteWithResponse() {
        try {
            return FluxUtil.withContext(this::undeleteWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> undeleteWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().undeleteWithRestResponseAsync(null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<StorageAccountInfo> getAccountInfo() {
        try {
            return this.getAccountInfoWithResponse().flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountInfoWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.blobs().getAccountInfoWithRestResponseAsync(null, null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> {
            BlobGetAccountInfoHeaders hd = (BlobGetAccountInfoHeaders)rb.getDeserializedHeaders();
            return new SimpleResponse((Response)rb, (Object)new StorageAccountInfo(hd.getSkuName(), hd.getAccountKind()));
        });
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getContainerName(), this.getBlobName(), this.getSnapshotId()).generateUserDelegationSas(userDelegationKey, this.getAccountName());
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return new BlobSasImplUtil(blobServiceSasSignatureValues, this.getContainerName(), this.getBlobName(), this.getSnapshotId()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()));
    }
}

