/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class UnionTypeInfo
extends TypeInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<TypeInfo> allUnionObjectTypeInfos;

    public UnionTypeInfo() {
    }

    @Override
    public String getTypeName() {
        StringBuilder sb = new StringBuilder();
        sb.append("uniontype<");
        for (int i = 0; i < this.allUnionObjectTypeInfos.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.allUnionObjectTypeInfos.get(i).getTypeName());
        }
        sb.append(">");
        return sb.toString();
    }

    public void setAllUnionObjectTypeInfos(List<TypeInfo> allUnionObjectTypeInfos) {
        this.allUnionObjectTypeInfos = allUnionObjectTypeInfos;
    }

    UnionTypeInfo(List<TypeInfo> typeInfos) {
        this.allUnionObjectTypeInfos = new ArrayList<TypeInfo>();
        this.allUnionObjectTypeInfos.addAll(typeInfos);
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.UNION;
    }

    public List<TypeInfo> getAllUnionObjectTypeInfos() {
        return this.allUnionObjectTypeInfos;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnionTypeInfo)) {
            return false;
        }
        UnionTypeInfo o = (UnionTypeInfo)other;
        return ((Object)o.getAllUnionObjectTypeInfos()).equals(this.getAllUnionObjectTypeInfos());
    }

    @Override
    public int hashCode() {
        return ((Object)this.allUnionObjectTypeInfos).hashCode();
    }
}

