/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.hyracks.api.exceptions.SourceLocation;

public final class SqlppGroupingSetsParser {
    static final int GROUPING_SETS_LIMIT = 128;
    private SourceLocation sourceLoc;
    private List<GroupingElement> workList;
    private List<GbyVariableExpressionPair> gbyPairWorkList;
    private LinkedHashMap<Expression, GbyVariableExpressionPair> gbyPairWorkMap;
    private List<List<List<GbyVariableExpressionPair>>> crossProductWorkLists;

    public List<List<GbyVariableExpressionPair>> parse(List<GroupingElement> inList, SourceLocation sourceLoc) throws CompilationException {
        this.sourceLoc = sourceLoc;
        List<GbyVariableExpressionPair> primitiveList = this.transformSimpleToPrimitive(inList);
        if (primitiveList != null) {
            return Collections.singletonList(primitiveList);
        }
        if (this.workList == null) {
            this.workList = new ArrayList<GroupingElement>();
        } else {
            this.workList.clear();
        }
        this.eliminateComplexGroupingSets(inList, this.workList, false);
        return this.crossProductGroupingSets(this.workList);
    }

    private List<GbyVariableExpressionPair> transformSimpleToPrimitive(List<GroupingElement> inList) throws CompilationException {
        if (SqlppGroupingSetsParser.findComplexElement(inList) != null) {
            return null;
        }
        if (this.gbyPairWorkList == null) {
            this.gbyPairWorkList = new ArrayList<GbyVariableExpressionPair>();
        } else {
            this.gbyPairWorkList.clear();
        }
        this.concatOrdinary(inList, inList.size(), this.gbyPairWorkList);
        return this.removeDuplicates(this.gbyPairWorkList);
    }

    private void eliminateComplexGroupingSets(List<? extends GroupingElement> inList, List<GroupingElement> outList, boolean isInsideGroupingSets) throws CompilationException {
        block5: for (GroupingElement groupingElement : inList) {
            switch (groupingElement.getKind()) {
                case GROUPING_SET: {
                    outList.add(groupingElement);
                    continue block5;
                }
                case ROLLUP_CUBE: {
                    RollupCube rollupCube = (RollupCube)groupingElement;
                    List<GroupingSet> rollupCubeTransform = this.expandRollupCube(rollupCube);
                    if (isInsideGroupingSets) {
                        outList.addAll(rollupCubeTransform);
                        continue block5;
                    }
                    outList.add(new GroupingSets(rollupCubeTransform));
                    continue block5;
                }
                case GROUPING_SETS: {
                    GroupingSets groupingSets = (GroupingSets)groupingElement;
                    List<? extends GroupingElement> groupingSetsItems = groupingSets.getItems();
                    ArrayList<GroupingElement> groupingSetsTransform = new ArrayList<GroupingElement>(groupingSetsItems.size());
                    this.eliminateComplexGroupingSets(groupingSetsItems, groupingSetsTransform, true);
                    if (isInsideGroupingSets) {
                        outList.addAll(groupingSetsTransform);
                        continue block5;
                    }
                    outList.add(new GroupingSets(groupingSetsTransform));
                    continue block5;
                }
            }
            throw new IllegalStateException(String.valueOf((Object)groupingElement.getKind()));
        }
    }

    private List<GroupingSet> expandRollupCube(RollupCube rollupCube) throws CompilationException {
        List<GroupingSet> rollupCubeItems = rollupCube.getItems();
        return rollupCube.isCube() ? this.expandCube(rollupCubeItems) : this.expandRollup(rollupCubeItems);
    }

    private List<GroupingSet> expandRollup(List<GroupingSet> items) throws CompilationException {
        int n = items.size();
        int rollupSize = n + 1;
        this.checkGroupingSetsLimit(rollupSize);
        ArrayList<GroupingSet> result = new ArrayList<GroupingSet>(rollupSize);
        for (int i = n; i > 0; --i) {
            ArrayList<GbyVariableExpressionPair> groupingSetItems = new ArrayList<GbyVariableExpressionPair>();
            this.concatOrdinary(items, i, groupingSetItems);
            result.add(new GroupingSet(groupingSetItems));
        }
        result.add(GroupingSet.EMPTY);
        return result;
    }

    private List<GroupingSet> expandCube(List<GroupingSet> items) throws CompilationException {
        int n = items.size();
        int cubeSize = 1 << n;
        this.checkGroupingSetsLimit(cubeSize);
        ArrayList<GroupingSet> result = new ArrayList<GroupingSet>(cubeSize);
        ArrayList<GroupingSet> permutation = new ArrayList<GroupingSet>(n);
        for (long v = (long)(cubeSize - 1); v > 0L; --v) {
            permutation.clear();
            for (int i = n - 1; i >= 0; --i) {
                if ((v & 1L << i) == 0L) continue;
                permutation.add(items.get(n - i - 1));
            }
            ArrayList<GbyVariableExpressionPair> groupingSetItems = new ArrayList<GbyVariableExpressionPair>();
            this.concatOrdinary(permutation, permutation.size(), groupingSetItems);
            result.add(new GroupingSet(groupingSetItems));
        }
        result.add(GroupingSet.EMPTY);
        return result;
    }

    private List<List<GbyVariableExpressionPair>> crossProductGroupingSets(List<GroupingElement> inList) throws CompilationException {
        if (this.crossProductWorkLists == null) {
            this.crossProductWorkLists = Arrays.asList(new ArrayList(), new ArrayList());
        } else {
            for (List<List<GbyVariableExpressionPair>> list : this.crossProductWorkLists) {
                list.clear();
            }
        }
        int workInListIdx = 0;
        int inListSize = inList.size();
        for (int inListPos = 0; inListPos < inListSize; ++inListPos) {
            List<List<GbyVariableExpressionPair>> workInList = this.crossProductWorkLists.get(workInListIdx);
            int workOutListIdx = 1 - workInListIdx;
            List<List<GbyVariableExpressionPair>> workOutList = this.crossProductWorkLists.get(workOutListIdx);
            workOutList.clear();
            GroupingElement element = inList.get(inListPos);
            GroupingSet groupingSet = null;
            GroupingSets groupingSets = null;
            switch (element.getKind()) {
                case GROUPING_SET: {
                    groupingSet = (GroupingSet)element;
                    break;
                }
                case GROUPING_SETS: {
                    groupingSets = (GroupingSets)element;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)element.getKind()));
                }
            }
            if (inListPos == 0) {
                if (groupingSet != null) {
                    workOutList.add(groupingSet.getItems());
                } else {
                    for (GroupingElement groupingElement : groupingSets.getItems()) {
                        workOutList.add(((GroupingSet)groupingElement).getItems());
                    }
                }
            } else {
                for (List list : workInList) {
                    if (groupingSet != null) {
                        workOutList.add(this.concatOrdinary(list, groupingSet.getItems()));
                        continue;
                    }
                    for (GroupingElement groupingElement : groupingSets.getItems()) {
                        workOutList.add(this.concatOrdinary(list, ((GroupingSet)groupingElement).getItems()));
                    }
                }
            }
            this.checkGroupingSetsLimit(workOutList.size());
            workInListIdx = workOutListIdx;
        }
        List<List<GbyVariableExpressionPair>> crossProductList = this.crossProductWorkLists.get(workInListIdx);
        HashMap<Expression, GbyVariableExpressionPair> gbyPairMap = new HashMap<Expression, GbyVariableExpressionPair>();
        ArrayList<List<GbyVariableExpressionPair>> result = new ArrayList<List<GbyVariableExpressionPair>>(crossProductList.size());
        for (List<GbyVariableExpressionPair> groupingSet : crossProductList) {
            List<GbyVariableExpressionPair> gsNoDups = this.removeDuplicates(groupingSet);
            int n = gsNoDups.size();
            for (int i = 0; i < n; ++i) {
                GbyVariableExpressionPair gbyPair = gsNoDups.get(i);
                GbyVariableExpressionPair gbyVariableExpressionPair = (GbyVariableExpressionPair)gbyPairMap.get(gbyPair.getExpr());
                if (gbyVariableExpressionPair == null) {
                    gbyPairMap.put(gbyPair.getExpr(), gbyPair);
                    continue;
                }
                if (Objects.equals(gbyVariableExpressionPair.getVar(), gbyPair.getVar())) continue;
                if (gbyPair.getVar() != null) {
                    throw new CompilationException(ErrorCode.COMPILATION_UNEXPECTED_ALIAS, gbyPair.getVar().getSourceLocation(), new Serializable[]{SqlppVariableUtil.toUserDefinedName(gbyPair.getVar().getVar().getValue())});
                }
                VariableExpr newVar = new VariableExpr(new VarIdentifier(gbyVariableExpressionPair.getVar().getVar()));
                newVar.setSourceLocation(gbyVariableExpressionPair.getVar().getSourceLocation());
                gbyPair = new GbyVariableExpressionPair(newVar, gbyPair.getExpr());
                gsNoDups.set(i, gbyPair);
            }
            result.add(gsNoDups);
        }
        return result;
    }

    private List<GbyVariableExpressionPair> removeDuplicates(List<GbyVariableExpressionPair> inList) throws CompilationException {
        if (this.gbyPairWorkMap == null) {
            this.gbyPairWorkMap = new LinkedHashMap();
        } else {
            this.gbyPairWorkMap.clear();
        }
        for (GbyVariableExpressionPair gbyPair : inList) {
            GbyVariableExpressionPair existingPair = this.gbyPairWorkMap.get(gbyPair.getExpr());
            if (existingPair == null) {
                this.gbyPairWorkMap.put(gbyPair.getExpr(), gbyPair);
                continue;
            }
            if (Objects.equals(existingPair.getVar(), gbyPair.getVar()) || gbyPair.getVar() == null) continue;
            throw new CompilationException(ErrorCode.COMPILATION_UNEXPECTED_ALIAS, gbyPair.getVar().getSourceLocation(), new Serializable[]{SqlppVariableUtil.toUserDefinedName(gbyPair.getVar().getVar().getValue())});
        }
        return new ArrayList<GbyVariableExpressionPair>(this.gbyPairWorkMap.values());
    }

    private List<GbyVariableExpressionPair> concatOrdinary(List<GbyVariableExpressionPair> groupingSet1, List<GbyVariableExpressionPair> groupingSet2) {
        ArrayList<GbyVariableExpressionPair> outList = new ArrayList<GbyVariableExpressionPair>(groupingSet1.size() + groupingSet2.size());
        outList.addAll(groupingSet1);
        outList.addAll(groupingSet2);
        return outList;
    }

    private void concatOrdinary(List<? extends GroupingElement> inList, int endIdx, List<GbyVariableExpressionPair> outList) {
        for (int i = 0; i < endIdx; ++i) {
            GroupingElement element = inList.get(i);
            if (element.getKind() != GroupingElement.Kind.GROUPING_SET) {
                throw new IllegalStateException(String.valueOf((Object)element.getKind()));
            }
            outList.addAll(((GroupingSet)element).getItems());
        }
    }

    private static GroupingElement findComplexElement(List<GroupingElement> inList) {
        block4: for (GroupingElement element : inList) {
            switch (element.getKind()) {
                case ROLLUP_CUBE: 
                case GROUPING_SETS: {
                    return element;
                }
                case GROUPING_SET: {
                    continue block4;
                }
            }
            throw new IllegalStateException(String.valueOf((Object)element.getKind()));
        }
        return null;
    }

    private void checkGroupingSetsLimit(int n) throws CompilationException {
        if (n > 128) {
            throw new CompilationException(ErrorCode.COMPILATION_GROUPING_SETS_OVERFLOW, this.sourceLoc, new Serializable[]{String.valueOf(n), String.valueOf(128)});
        }
    }

    public static final class GroupingSets
    extends GroupingElement {
        private final List<? extends GroupingElement> items;

        public GroupingSets(List<? extends GroupingElement> items) {
            this.items = items;
        }

        @Override
        public GroupingElement.Kind getKind() {
            return GroupingElement.Kind.GROUPING_SETS;
        }

        public List<? extends GroupingElement> getItems() {
            return this.items;
        }
    }

    public static final class RollupCube
    extends GroupingElement {
        private final List<GroupingSet> items;
        private final boolean isCube;

        public RollupCube(List<GroupingSet> items, boolean isCube) {
            this.items = items;
            this.isCube = isCube;
        }

        @Override
        public GroupingElement.Kind getKind() {
            return GroupingElement.Kind.ROLLUP_CUBE;
        }

        public List<GroupingSet> getItems() {
            return this.items;
        }

        public boolean isCube() {
            return this.isCube;
        }
    }

    public static final class GroupingSet
    extends GroupingElement {
        public static final GroupingSet EMPTY = new GroupingSet(Collections.emptyList());
        private final List<GbyVariableExpressionPair> items;

        public GroupingSet(List<GbyVariableExpressionPair> items) {
            this.items = items;
        }

        @Override
        public GroupingElement.Kind getKind() {
            return GroupingElement.Kind.GROUPING_SET;
        }

        public List<GbyVariableExpressionPair> getItems() {
            return this.items;
        }
    }

    public static abstract class GroupingElement {
        public abstract Kind getKind();

        public static enum Kind {
            GROUPING_SET,
            GROUPING_SETS,
            ROLLUP_CUBE;

        }
    }
}

