/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.FloatPointable;

public class FloatToInt32TypeConvertComputer
implements ITypeConvertComputer {
    private static final FloatToInt32TypeConvertComputer INSTANCE_STRICT = new FloatToInt32TypeConvertComputer(true);
    private static final FloatToInt32TypeConvertComputer INSTANCE_LAX = new FloatToInt32TypeConvertComputer(false);
    private final boolean strict;

    private FloatToInt32TypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static FloatToInt32TypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        int targetValue = this.convertType(data, start);
        out.writeByte(ATypeTag.INTEGER.serialize());
        out.writeInt(targetValue);
    }

    int convertType(byte[] data, int start) throws HyracksDataException {
        float sourceValue = FloatPointable.getFloat((byte[])data, (int)start);
        return this.convert(sourceValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject, ATypeHierarchy.TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        float sourceValue = ATypeHierarchy.applyMathFunctionToFloatValue(sourceObject, mathFunction);
        int targetValue = this.convert(sourceValue);
        return new AInt32(targetValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int convert(float sourceValue) throws HyracksDataException {
        if (Float.isNaN(sourceValue)) {
            if (!this.strict) return 0;
            this.raiseBoundaryCheckException(sourceValue);
            return (int)Math.floor(sourceValue);
        } else if (sourceValue > 2.1474836E9f) {
            if (!this.strict) return Integer.MAX_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
            return (int)Math.floor(sourceValue);
        } else {
            if (!(sourceValue < -2.1474836E9f)) return (int)Math.floor(sourceValue);
            if (!this.strict) return Integer.MIN_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
        }
        return (int)Math.floor(sourceValue);
    }

    private void raiseBoundaryCheckException(float sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_OUT_OF_BOUND, new Serializable[]{Float.valueOf(sourceValue), ATypeTag.INTEGER, Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(Integer.MIN_VALUE)});
    }
}

