/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.external;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.io.RunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.hyracks.dataflow.std.group.AggregateType;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.ISpillableTable;
import org.apache.hyracks.dataflow.std.group.ISpillableTableFactory;
import org.apache.hyracks.dataflow.std.group.external.ExternalGroupOperatorDescriptor;
import org.apache.hyracks.dataflow.std.group.external.ExternalGroupState;
import org.apache.hyracks.dataflow.std.group.external.ExternalHashGroupBy;
import org.apache.hyracks.dataflow.std.group.external.IRunFileWriterGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalGroupWriteOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable
implements IRunFileWriterGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IHyracksTaskContext ctx;
    private final Object stateId;
    private final ISpillableTableFactory spillableTableFactory;
    private final RecordDescriptor partialAggRecordDesc;
    private final RecordDescriptor outRecordDesc;
    private final IAggregatorDescriptorFactory mergeAggregatorFactory;
    private final int[] gbyFields;
    private final int[] fdFields;
    private final IBinaryComparator[] groupByComparators;
    private final int frameLimit;
    private final INormalizedKeyComputer nmkComputer;
    private final ArrayList<RunFileWriter> generatedRuns = new ArrayList();

    public ExternalGroupWriteOperatorNodePushable(IHyracksTaskContext ctx, Object stateId, ISpillableTableFactory spillableTableFactory, RecordDescriptor partialAggRecordDesc, RecordDescriptor outRecordDesc, int framesLimit, int[] gbyFields, int[] fdFields, INormalizedKeyComputerFactory nmkFactory, IBinaryComparatorFactory[] comparatorFactories, IAggregatorDescriptorFactory aggregatorFactory) throws HyracksDataException {
        int i;
        if (comparatorFactories.length != gbyFields.length) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"mismatch in group by fields and comparators"});
        }
        this.ctx = ctx;
        this.stateId = stateId;
        this.spillableTableFactory = spillableTableFactory;
        this.frameLimit = framesLimit;
        this.nmkComputer = nmkFactory == null ? null : nmkFactory.createNormalizedKeyComputer();
        this.partialAggRecordDesc = partialAggRecordDesc;
        this.outRecordDesc = outRecordDesc;
        this.mergeAggregatorFactory = aggregatorFactory;
        this.gbyFields = new int[gbyFields.length];
        int position = 0;
        for (i = 0; i < this.gbyFields.length; ++i) {
            this.gbyFields[i] = position++;
        }
        if (fdFields != null) {
            this.fdFields = new int[fdFields.length];
            for (i = 0; i < this.fdFields.length; ++i) {
                this.fdFields[i] = position++;
            }
        } else {
            this.fdFields = null;
        }
        this.groupByComparators = new IBinaryComparator[comparatorFactories.length];
        for (i = 0; i < this.groupByComparators.length; ++i) {
            this.groupByComparators[i] = comparatorFactories[i].createBinaryComparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws HyracksDataException {
        ExternalGroupState aggState = (ExternalGroupState)this.ctx.getStateObject(this.stateId);
        ISpillableTable table = aggState.getSpillableTable();
        RunFileWriter[] partitionRuns = aggState.getRuns();
        int[] numberOfTuples = aggState.getSpilledNumTuples();
        try {
            this.writer.open();
            this.doPass(table, partitionRuns, numberOfTuples, this.writer, 1);
        }
        catch (Exception e) {
            try {
                for (RunFileWriter run : this.generatedRuns) {
                    run.erase();
                }
            }
            finally {
                this.writer.fail();
            }
            throw e;
        }
        finally {
            this.writer.close();
        }
    }

    private void doPass(ISpillableTable table, RunFileWriter[] runs, int[] numOfTuples, IFrameWriter writer, int level) throws HyracksDataException {
        int i;
        assert (table.getNumPartitions() == runs.length);
        for (i = 0; i < runs.length; ++i) {
            if (runs[i] != null) continue;
            table.flushFrames(i, writer, AggregateType.FINAL);
        }
        table.close();
        for (i = 0; i < runs.length; ++i) {
            if (runs[i] == null) continue;
            int memoryBudgetInBytes = this.ctx.getInitialFrameSize() * this.frameLimit;
            int allFields = this.gbyFields.length + (this.fdFields == null ? 0 : this.fdFields.length);
            int hashTableCardinality = ExternalGroupOperatorDescriptor.calculateGroupByTableCardinality(memoryBudgetInBytes, allFields, this.ctx.getInitialFrameSize());
            hashTableCardinality = Math.min(hashTableCardinality, numOfTuples[i]);
            ISpillableTable partitionTable = this.spillableTableFactory.buildSpillableTable(this.ctx, hashTableCardinality, runs[i].getFileSize(), this.gbyFields, this.fdFields, this.groupByComparators, this.nmkComputer, this.mergeAggregatorFactory, this.partialAggRecordDesc, this.outRecordDesc, this.frameLimit, level);
            RunFileWriter[] runFileWriters = new RunFileWriter[partitionTable.getNumPartitions()];
            int[] sizeInTuplesNextLevel = this.buildGroup((RunFileReader)runs[i].createDeleteOnCloseReader(), partitionTable, runFileWriters);
            for (int idFile = 0; idFile < runFileWriters.length; ++idFile) {
                if (runFileWriters[idFile] == null) continue;
                this.generatedRuns.add(runFileWriters[idFile]);
            }
            if (LOGGER.isDebugEnabled()) {
                int numOfSpilledPart = 0;
                for (int x = 0; x < numOfTuples.length; ++x) {
                    if (numOfTuples[x] <= 0) continue;
                    ++numOfSpilledPart;
                }
                LOGGER.debug("level " + level + ":build with " + numOfTuples.length + " partitions, spilled " + numOfSpilledPart + " partitions");
            }
            this.doPass(partitionTable, runFileWriters, sizeInTuplesNextLevel, writer, level + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] buildGroup(RunFileReader reader, ISpillableTable table, RunFileWriter[] runFileWriters) throws HyracksDataException {
        ExternalHashGroupBy groupBy = new ExternalHashGroupBy(this, table, runFileWriters, this.partialAggRecordDesc);
        reader.open();
        try {
            VSizeFrame frame = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
            while (reader.nextFrame((IFrame)frame)) {
                groupBy.insert(frame.getBuffer());
            }
            groupBy.flushSpilledPartitions();
        }
        finally {
            reader.close();
        }
        return groupBy.getSpilledNumTuples();
    }

    @Override
    public RunFileWriter getRunFileWriter() throws HyracksDataException {
        FileReference newRun = this.ctx.createManagedWorkspaceFile(ExternalGroupOperatorDescriptor.class.getSimpleName());
        return new RunFileWriter(newRun, this.ctx.getIoManager());
    }
}

