/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IRewriterFactory;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.ListSliceExpression;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.visitor.AbstractInlineUdfsVisitor;
import org.apache.asterix.lang.common.visitor.CloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.HavingClause;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.Projection;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.CaseExpression;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.visitor.SqlppCloneAndSubstituteVariablesVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SqlppInlineUdfsVisitor
extends AbstractInlineUdfsVisitor
implements ISqlppVisitor<Boolean, List<FunctionDecl>> {
    public SqlppInlineUdfsVisitor(LangRewritingContext context, IRewriterFactory rewriterFactory, List<FunctionDecl> declaredFunctions, MetadataProvider metadataProvider) {
        super(context, rewriterFactory, declaredFunctions, metadataProvider, (CloneAndSubstituteVariablesVisitor)new SqlppCloneAndSubstituteVariablesVisitor(context));
    }

    protected Expression generateQueryExpression(List<LetClause> letClauses, Expression returnExpr) throws CompilationException {
        Map<Expression, Expression> varExprMap = this.extractLetBindingVariableExpressionMappings(letClauses);
        return SqlppRewriteUtil.substituteExpression(returnExpr, varExprMap, this.context);
    }

    @Override
    public Boolean visit(FromClause fromClause, List<FunctionDecl> func) throws CompilationException {
        boolean changed = false;
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            changed |= fromTerm.accept(this, func).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(FromTerm fromTerm, List<FunctionDecl> func) throws CompilationException {
        boolean changed = false;
        Pair p = this.inlineUdfsInExpr(fromTerm.getLeftExpression(), func);
        fromTerm.setLeftExpression((Expression)p.second);
        changed |= ((Boolean)p.first).booleanValue();
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            changed |= ((Boolean)correlateClause.accept(this, func)).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(JoinClause joinClause, List<FunctionDecl> funcs) throws CompilationException {
        Pair p1 = this.inlineUdfsInExpr(joinClause.getRightExpression(), funcs);
        joinClause.setRightExpression((Expression)p1.second);
        Pair p2 = this.inlineUdfsInExpr(joinClause.getConditionExpression(), funcs);
        joinClause.setConditionExpression((Expression)p2.second);
        return (Boolean)p1.first != false || (Boolean)p2.first != false;
    }

    @Override
    public Boolean visit(NestClause nestClause, List<FunctionDecl> funcs) throws CompilationException {
        Pair p1 = this.inlineUdfsInExpr(nestClause.getRightExpression(), funcs);
        nestClause.setRightExpression((Expression)p1.second);
        Pair p2 = this.inlineUdfsInExpr(nestClause.getConditionExpression(), funcs);
        nestClause.setConditionExpression((Expression)p2.second);
        return (Boolean)p1.first != false || (Boolean)p2.first != false;
    }

    @Override
    public Boolean visit(Projection projection, List<FunctionDecl> funcs) throws CompilationException {
        if (projection.star()) {
            return false;
        }
        Pair p = this.inlineUdfsInExpr(projection.getExpression(), funcs);
        projection.setExpression((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(SelectBlock selectBlock, List<FunctionDecl> funcs) throws CompilationException {
        boolean changed = false;
        if (selectBlock.hasFromClause()) {
            changed |= selectBlock.getFromClause().accept(this, funcs).booleanValue();
        }
        if (selectBlock.hasLetWhereClauses()) {
            for (AbstractClause letWhereClause : selectBlock.getLetWhereList()) {
                changed |= ((Boolean)letWhereClause.accept((ILangVisitor)this, funcs)).booleanValue();
            }
        }
        if (selectBlock.hasGroupbyClause()) {
            changed |= ((Boolean)selectBlock.getGroupbyClause().accept((ILangVisitor)this, funcs)).booleanValue();
        }
        if (selectBlock.hasLetHavingClausesAfterGroupby()) {
            for (AbstractClause letHavingClause : selectBlock.getLetHavingListAfterGroupby()) {
                changed |= ((Boolean)letHavingClause.accept((ILangVisitor)this, funcs)).booleanValue();
            }
        }
        return changed |= selectBlock.getSelectClause().accept(this, funcs).booleanValue();
    }

    @Override
    public Boolean visit(SelectClause selectClause, List<FunctionDecl> funcs) throws CompilationException {
        boolean changed = false;
        changed = selectClause.selectElement() ? (changed |= selectClause.getSelectElement().accept(this, funcs).booleanValue()) : (changed |= selectClause.getSelectRegular().accept(this, funcs).booleanValue());
        return changed;
    }

    @Override
    public Boolean visit(SelectElement selectElement, List<FunctionDecl> funcs) throws CompilationException {
        Pair p = this.inlineUdfsInExpr(selectElement.getExpression(), funcs);
        selectElement.setExpression((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(SelectRegular selectRegular, List<FunctionDecl> funcs) throws CompilationException {
        boolean changed = false;
        for (Projection projection : selectRegular.getProjections()) {
            changed |= projection.accept(this, funcs).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(SelectSetOperation selectSetOperation, List<FunctionDecl> funcs) throws CompilationException {
        boolean changed = false;
        changed |= selectSetOperation.getLeftInput().accept(this, funcs).booleanValue();
        for (SetOperationRight right : selectSetOperation.getRightInputs()) {
            changed |= right.getSetOperationRightInput().accept(this, funcs).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(SelectExpression selectExpression, List<FunctionDecl> funcs) throws CompilationException {
        boolean changed = false;
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                changed |= ((Boolean)letClause.accept((ILangVisitor)this, funcs)).booleanValue();
            }
        }
        changed |= selectExpression.getSelectSetOperation().accept(this, funcs).booleanValue();
        if (selectExpression.hasOrderby()) {
            changed |= ((Boolean)selectExpression.getOrderbyClause().accept((ILangVisitor)this, funcs)).booleanValue();
        }
        if (selectExpression.hasLimit()) {
            changed |= ((Boolean)selectExpression.getLimitClause().accept((ILangVisitor)this, funcs)).booleanValue();
        }
        return changed;
    }

    @Override
    public Boolean visit(UnnestClause unnestClause, List<FunctionDecl> funcs) throws CompilationException {
        Pair p = this.inlineUdfsInExpr(unnestClause.getRightExpression(), funcs);
        unnestClause.setRightExpression((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(HavingClause havingClause, List<FunctionDecl> funcs) throws CompilationException {
        Pair p = this.inlineUdfsInExpr(havingClause.getFilterExpression(), funcs);
        havingClause.setFilterExpression((Expression)p.second);
        return (Boolean)p.first;
    }

    @Override
    public Boolean visit(CaseExpression caseExpr, List<FunctionDecl> funcs) throws CompilationException {
        Pair result = this.inlineUdfsInExpr(caseExpr.getConditionExpr(), funcs);
        caseExpr.setConditionExpr((Expression)result.second);
        boolean inlined = (Boolean)result.first;
        Pair inlinedList = this.inlineUdfsInExprList(caseExpr.getWhenExprs(), funcs);
        inlined = inlined || (Boolean)inlinedList.first != false;
        caseExpr.setWhenExprs((List)inlinedList.second);
        inlinedList = this.inlineUdfsInExprList(caseExpr.getThenExprs(), funcs);
        inlined = inlined || (Boolean)inlinedList.first != false;
        caseExpr.setThenExprs((List)inlinedList.second);
        result = this.inlineUdfsInExpr(caseExpr.getElseExpr(), funcs);
        caseExpr.setElseExpr((Expression)result.second);
        return inlined || (Boolean)result.first != false;
    }

    @Override
    public Boolean visit(WindowExpression winExpr, List<FunctionDecl> funcs) throws CompilationException {
        Pair inlinedExpr;
        Pair inlinedList;
        boolean inlined = false;
        if (winExpr.hasPartitionList()) {
            inlinedList = this.inlineUdfsInExprList(winExpr.getPartitionList(), funcs);
            winExpr.setPartitionList((List)inlinedList.second);
            inlined = (Boolean)inlinedList.first;
        }
        if (winExpr.hasOrderByList()) {
            inlinedList = this.inlineUdfsInExprList(winExpr.getOrderbyList(), funcs);
            winExpr.setOrderbyList((List)inlinedList.second);
            inlined |= ((Boolean)inlinedList.first).booleanValue();
        }
        if (winExpr.hasFrameStartExpr()) {
            inlinedExpr = this.inlineUdfsInExpr(winExpr.getFrameStartExpr(), funcs);
            winExpr.setFrameStartExpr((Expression)inlinedExpr.second);
            inlined |= ((Boolean)inlinedExpr.first).booleanValue();
        }
        if (winExpr.hasFrameEndExpr()) {
            inlinedExpr = this.inlineUdfsInExpr(winExpr.getFrameEndExpr(), funcs);
            winExpr.setFrameEndExpr((Expression)inlinedExpr.second);
            inlined |= ((Boolean)inlinedExpr.first).booleanValue();
        }
        if (winExpr.hasWindowFieldList()) {
            inlinedList = this.inlineUdfsInFieldList(winExpr.getWindowFieldList(), funcs);
            winExpr.setWindowFieldList((List)inlinedList.second);
            inlined |= ((Boolean)inlinedList.first).booleanValue();
        }
        if (winExpr.hasAggregateFilterExpr()) {
            inlinedExpr = this.inlineUdfsInExpr(winExpr.getAggregateFilterExpr(), funcs);
            winExpr.setAggregateFilterExpr((Expression)inlinedExpr.second);
            inlined |= ((Boolean)inlinedExpr.first).booleanValue();
        }
        inlinedList = this.inlineUdfsInExprList(winExpr.getExprList(), funcs);
        winExpr.setExprList((List)inlinedList.second);
        return inlined |= ((Boolean)inlinedList.first).booleanValue();
    }

    public Boolean visit(ListSliceExpression expression, List<FunctionDecl> funcs) throws CompilationException {
        Pair expressionResult = this.inlineUdfsInExpr(expression.getExpr(), funcs);
        expression.setExpr((Expression)expressionResult.second);
        boolean inlined = (Boolean)expressionResult.first;
        Pair startIndexExpressResult = this.inlineUdfsInExpr(expression.getStartIndexExpression(), funcs);
        expression.setStartIndexExpression((Expression)startIndexExpressResult.second);
        inlined |= ((Boolean)startIndexExpressResult.first).booleanValue();
        if (expression.hasEndExpression()) {
            Pair endIndexExpressionResult = this.inlineUdfsInExpr(expression.getEndIndexExpression(), funcs);
            expression.setEndIndexExpression((Expression)endIndexExpressionResult.second);
            inlined |= ((Boolean)endIndexExpressionResult.first).booleanValue();
        }
        return inlined;
    }

    private Map<Expression, Expression> extractLetBindingVariableExpressionMappings(List<LetClause> letClauses) throws CompilationException {
        HashMap<Expression, Expression> varExprMap = new HashMap<Expression, Expression>();
        for (LetClause lc : letClauses) {
            lc.setBindingExpr(SqlppRewriteUtil.substituteExpression(lc.getBindingExpr(), varExprMap, this.context));
            varExprMap.put((Expression)lc.getVarExpr(), lc.getBindingExpr());
        }
        return varExprMap;
    }
}

