/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.AbstractIntegerTypeConvertComputer;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.dataflow.common.data.marshalling.DoubleSerializerDeserializer;

public class IntegerToDoubleTypeConvertComputer
implements ITypeConvertComputer {
    private static final IntegerToDoubleTypeConvertComputer INSTANCE = new IntegerToDoubleTypeConvertComputer();

    private IntegerToDoubleTypeConvertComputer() {
    }

    public static IntegerToDoubleTypeConvertComputer getInstance() {
        return INSTANCE;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        long val = AbstractIntegerTypeConvertComputer.asLong(data, start, length);
        out.writeByte(ATypeTag.DOUBLE.serialize());
        DoubleSerializerDeserializer.write((double)val, (DataOutput)out);
    }

    double convertType(byte[] data, int start, ATypeTag sourceTypeTag) throws HyracksDataException {
        switch (sourceTypeTag) {
            case TINYINT: {
                return BytePointable.getByte((byte[])data, (int)start);
            }
            case SMALLINT: {
                return ShortPointable.getShort((byte[])data, (int)start);
            }
            case INTEGER: {
                return IntegerPointable.getInteger((byte[])data, (int)start);
            }
            case BIGINT: {
                return LongPointable.getLong((byte[])data, (int)start);
            }
        }
        throw new RuntimeDataException(19, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
    }

    @Override
    public IAObject convertType(IAObject sourceObject, ATypeHierarchy.TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        long val;
        switch (sourceObject.getType().getTypeTag()) {
            case TINYINT: {
                val = ((AInt8)sourceObject).getByteValue();
                break;
            }
            case SMALLINT: {
                val = ((AInt16)sourceObject).getShortValue();
                break;
            }
            case INTEGER: {
                val = ((AInt32)sourceObject).getIntegerValue();
                break;
            }
            case BIGINT: {
                val = ((AInt64)sourceObject).getLongValue();
                break;
            }
            default: {
                throw new RuntimeDataException(19, new Serializable[]{Arrays.toString(new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT})});
            }
        }
        return new ADouble(val);
    }
}

