/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.base.AString;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.hyracks.util.string.UTF8StringUtil;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class AStringSerializerDeserializer
implements ISerializerDeserializer<AString> {
    private static final long serialVersionUID = 1L;
    public static final AStringSerializerDeserializer INSTANCE = new AStringSerializerDeserializer();
    private final UTF8StringWriter utf8StringWriter;
    private final UTF8StringReader utf8StringReader;

    private AStringSerializerDeserializer() {
        this.utf8StringWriter = null;
        this.utf8StringReader = null;
    }

    public AStringSerializerDeserializer(UTF8StringWriter utf8StringWriter, UTF8StringReader utf8StringReader) {
        this.utf8StringWriter = utf8StringWriter;
        this.utf8StringReader = utf8StringReader;
    }

    public AString deserialize(DataInput in) throws HyracksDataException {
        try {
            return new AString(UTF8StringUtil.readUTF8((DataInput)in, (UTF8StringReader)this.utf8StringReader));
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void serialize(AString instance, DataOutput out) throws HyracksDataException {
        try {
            UTF8StringUtil.writeUTF8((CharSequence)instance.getStringValue(), (DataOutput)out, (UTF8StringWriter)this.utf8StringWriter);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void serialize(char[] buffer, int start, int length, DataOutput out) throws IOException {
        UTF8StringUtil.writeUTF8((char[])buffer, (int)start, (int)length, (DataOutput)out, (UTF8StringWriter)this.utf8StringWriter);
    }
}

