/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;

public class JobActivityGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<ActivityId, IActivity> activityMap = new HashMap<ActivityId, IActivity>();
    private final Map<ConnectorDescriptorId, IConnectorDescriptor> connectorMap = new HashMap<ConnectorDescriptorId, IConnectorDescriptor>();
    private final Map<ConnectorDescriptorId, RecordDescriptor> connectorRecordDescriptorMap = new HashMap<ConnectorDescriptorId, RecordDescriptor>();
    private final Map<ActivityId, List<IConnectorDescriptor>> activityInputMap = new HashMap<ActivityId, List<IConnectorDescriptor>>();
    private final Map<ActivityId, List<IConnectorDescriptor>> activityOutputMap = new HashMap<ActivityId, List<IConnectorDescriptor>>();
    private final Map<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> connectorActivityMap = new HashMap<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>>();
    private final Map<ActivityId, Set<ActivityId>> blocked2blockerMap = new HashMap<ActivityId, Set<ActivityId>>();

    public Map<ActivityId, IActivity> getActivityMap() {
        return this.activityMap;
    }

    public Map<ConnectorDescriptorId, IConnectorDescriptor> getConnectorMap() {
        return this.connectorMap;
    }

    public Map<ConnectorDescriptorId, RecordDescriptor> getConnectorRecordDescriptorMap() {
        return this.connectorRecordDescriptorMap;
    }

    public Map<ActivityId, Set<ActivityId>> getBlocked2BlockerMap() {
        return this.blocked2blockerMap;
    }

    public Map<ActivityId, List<IConnectorDescriptor>> getActivityInputMap() {
        return this.activityInputMap;
    }

    public Map<ActivityId, List<IConnectorDescriptor>> getActivityOutputMap() {
        return this.activityOutputMap;
    }

    public Map<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> getConnectorActivityMap() {
        return this.connectorActivityMap;
    }

    public ActivityId getConsumerActivity(ConnectorDescriptorId cdId) {
        Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> connEdge = this.connectorActivityMap.get(cdId);
        return ((IActivity)((Pair)connEdge.getRight()).getLeft()).getActivityId();
    }

    public ActivityId getProducerActivity(ConnectorDescriptorId cdId) {
        Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> connEdge = this.connectorActivityMap.get(cdId);
        return ((IActivity)((Pair)connEdge.getLeft()).getLeft()).getActivityId();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ActivityNodes: " + this.activityMap);
        buffer.append('\n');
        buffer.append("Blocker->Blocked: " + this.blocked2blockerMap);
        buffer.append('\n');
        return buffer.toString();
    }
}

