/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.functions;

import java.io.Serializable;
import java.util.Objects;
import org.apache.asterix.common.functions.FunctionConstants;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class FunctionSignature
implements Serializable {
    private static final long serialVersionUID = 2L;
    private DataverseName dataverseName;
    private String name;
    private int arity;

    public FunctionSignature(FunctionIdentifier fi) {
        this(FunctionSignature.getDataverseName(fi), fi.getName(), fi.getArity());
    }

    public FunctionSignature(DataverseName dataverseName, String name, int arity) {
        this.dataverseName = dataverseName;
        this.name = name;
        this.arity = arity;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FunctionSignature)) {
            return false;
        }
        FunctionSignature f = (FunctionSignature)o;
        return Objects.equals(this.dataverseName, f.dataverseName) && this.name.equals(f.name) && (this.arity == f.arity || this.arity == -1 || f.arity == -1);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeArity) {
        String namespaceCanonicalForm = this.dataverseName != null ? this.dataverseName.getCanonicalForm() : null;
        int len = (namespaceCanonicalForm != null ? namespaceCanonicalForm.length() : 4) + 1 + this.name.length() + (includeArity ? 3 : 0);
        StringBuilder sb = new StringBuilder(len);
        sb.append(namespaceCanonicalForm).append('.').append(this.name);
        if (includeArity) {
            sb.append('@').append(this.arity);
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.dataverseName, this.name);
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public void setDataverseName(DataverseName dataverseName) {
        this.dataverseName = dataverseName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }

    public FunctionIdentifier createFunctionIdentifier() {
        return FunctionSignature.createFunctionIdentifier(this.dataverseName, this.name, this.arity);
    }

    public static FunctionIdentifier createFunctionIdentifier(DataverseName dataverseName, String functionName, int arity) {
        return new FunctionIdentifier(dataverseName.getCanonicalForm(), functionName, arity);
    }

    public static FunctionIdentifier createFunctionIdentifier(DataverseName dataverseName, String functionName) {
        return new FunctionIdentifier(dataverseName.getCanonicalForm(), functionName);
    }

    public static DataverseName getDataverseName(FunctionIdentifier fi) {
        String dataverseCanonicalName;
        switch (dataverseCanonicalName = fi.getNamespace()) {
            case "asterix": {
                return FunctionConstants.ASTERIX_DV;
            }
            case "algebricks": {
                return FunctionConstants.ALGEBRICKS_DV;
            }
        }
        return DataverseName.createFromCanonicalForm(dataverseCanonicalName);
    }
}

