/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.context.DatasetResource;
import org.apache.asterix.common.context.IndexInfo;
import org.apache.asterix.common.context.Info;
import org.apache.asterix.common.context.PrimaryIndexOperationTracker;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.ioopcallbacks.LSMIOOperationCallback;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentIdGenerator;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.LocalResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatasetLifecycleManager
implements IDatasetLifecycleManager,
ILifeCycleComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Integer, DatasetResource> datasets = new ConcurrentHashMap<Integer, DatasetResource>();
    private final StorageProperties storageProperties;
    private final ILocalResourceRepository resourceRepository;
    private final IVirtualBufferCache vbc;
    private final ILogManager logManager;
    private final LogRecord waitLog;
    private volatile boolean stopped = false;
    private final IIndexCheckpointManagerProvider indexCheckpointManagerProvider;
    private final List<IVirtualBufferCache> vbcs;

    public DatasetLifecycleManager(StorageProperties storageProperties, ILocalResourceRepository resourceRepository, ILogManager logManager, IVirtualBufferCache vbc, IIndexCheckpointManagerProvider indexCheckpointManagerProvider, int numPartitions) {
        this.logManager = logManager;
        this.storageProperties = storageProperties;
        this.resourceRepository = resourceRepository;
        this.vbc = vbc;
        int numMemoryComponents = storageProperties.getMemoryComponentsNum();
        this.vbcs = new ArrayList<IVirtualBufferCache>(numMemoryComponents);
        for (int i = 0; i < numMemoryComponents; ++i) {
            this.vbcs.add(vbc);
        }
        this.indexCheckpointManagerProvider = indexCheckpointManagerProvider;
        this.waitLog = new LogRecord();
        this.waitLog.setLogType((byte)9);
        this.waitLog.computeAndSetLogSize();
    }

    public synchronized ILSMIndex get(String resourcePath) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        int datasetID = this.getDIDfromResourcePath(resourcePath);
        long resourceID = this.getResourceIDfromResourcePath(resourcePath);
        return this.getIndex(datasetID, resourceID);
    }

    public synchronized ILSMIndex getIndex(int datasetID, long resourceID) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        DatasetResource datasetResource = this.datasets.get(datasetID);
        if (datasetResource == null) {
            return null;
        }
        return datasetResource.getIndex(resourceID);
    }

    public synchronized void register(String resourcePath, IIndex index) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        int did = this.getDIDfromResourcePath(resourcePath);
        LocalResource resource = this.resourceRepository.get(resourcePath);
        DatasetResource datasetResource = this.datasets.get(did);
        if (datasetResource == null) {
            datasetResource = this.getDatasetLifecycle(did);
        }
        datasetResource.register(resource, (ILSMIndex)index);
    }

    private int getDIDfromResourcePath(String resourcePath) throws HyracksDataException {
        LocalResource lr = this.resourceRepository.get(resourcePath);
        if (lr == null) {
            return -1;
        }
        return ((DatasetLocalResource)lr.getResource()).getDatasetId();
    }

    private long getResourceIDfromResourcePath(String resourcePath) throws HyracksDataException {
        LocalResource lr = this.resourceRepository.get(resourcePath);
        if (lr == null) {
            return -1L;
        }
        return lr.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregister(String resourcePath) throws HyracksDataException {
        IndexInfo iInfo;
        this.validateDatasetLifecycleManagerState();
        int did = this.getDIDfromResourcePath(resourcePath);
        long resourceID = this.getResourceIDfromResourcePath(resourcePath);
        DatasetResource dsr = this.datasets.get(did);
        IndexInfo indexInfo = iInfo = dsr == null ? null : dsr.getIndexInfo(resourceID);
        if (dsr == null || iInfo == null) {
            throw HyracksDataException.create((int)104, (Serializable[])new Serializable[0]);
        }
        PrimaryIndexOperationTracker opTracker = dsr.getOpTracker(iInfo.getPartition());
        if (iInfo.getReferenceCount() != 0 || opTracker != null && opTracker.getNumActiveOperations() != 0) {
            if (LOGGER.isErrorEnabled()) {
                String logMsg = String.format("Failed to drop in-use index %s. Ref count (%d), Operation tracker active ops (%d)", resourcePath, iInfo.getReferenceCount(), opTracker.getNumActiveOperations());
                LOGGER.error(logMsg);
            }
            throw HyracksDataException.create((int)105, (Serializable[])new Serializable[]{StoragePathUtil.getIndexNameFromPath(resourcePath)});
        }
        DatasetInfo dsInfo = dsr.getDatasetInfo();
        dsInfo.waitForIO();
        this.closeIndex(iInfo);
        dsInfo.removeIndex(resourceID);
        DatasetInfo datasetInfo = dsInfo;
        synchronized (datasetInfo) {
            if (dsInfo.getReferenceCount() == 0 && dsInfo.isOpen() && dsInfo.getIndexes().isEmpty() && !dsInfo.isExternal()) {
                this.removeDatasetFromCache(dsInfo.getDatasetID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(String resourcePath) throws HyracksDataException {
        this.validateDatasetLifecycleManagerState();
        int did = this.getDIDfromResourcePath(resourcePath);
        long resourceID = this.getResourceIDfromResourcePath(resourcePath);
        DatasetResource dsr = this.datasets.get(did);
        DatasetInfo dsInfo = dsr.getDatasetInfo();
        if (dsInfo == null || !dsInfo.isRegistered()) {
            throw new HyracksDataException("Failed to open index with resource ID " + resourceID + " since it does not exist.");
        }
        IndexInfo iInfo = dsInfo.getIndexes().get(resourceID);
        if (iInfo == null) {
            throw new HyracksDataException("Failed to open index with resource ID " + resourceID + " since it does not exist.");
        }
        dsr.open(true);
        dsr.touch();
        if (!iInfo.isOpen()) {
            ILSMOperationTracker opTracker;
            ILSMOperationTracker iLSMOperationTracker = opTracker = iInfo.getIndex().getOperationTracker();
            synchronized (iLSMOperationTracker) {
                iInfo.getIndex().activate();
            }
            iInfo.setOpen(true);
        }
        iInfo.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasetResource getDatasetLifecycle(int did) {
        DatasetResource dsr = this.datasets.get(did);
        if (dsr != null) {
            return dsr;
        }
        Map<Integer, DatasetResource> map = this.datasets;
        synchronized (map) {
            dsr = this.datasets.get(did);
            if (dsr == null) {
                DatasetInfo dsInfo = new DatasetInfo(did, this.logManager);
                dsr = new DatasetResource(dsInfo);
                this.datasets.put(did, dsr);
            }
            return dsr;
        }
    }

    @Override
    public DatasetInfo getDatasetInfo(int datasetID) {
        return this.getDatasetLifecycle(datasetID).getDatasetInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(String resourcePath) throws HyracksDataException {
        DatasetResource dsr = null;
        Info iInfo = null;
        try {
            this.validateDatasetLifecycleManagerState();
            int did = this.getDIDfromResourcePath(resourcePath);
            long resourceID = this.getResourceIDfromResourcePath(resourcePath);
            dsr = this.datasets.get(did);
            if (dsr == null) {
                throw HyracksDataException.create((int)83, (Serializable[])new Serializable[]{Long.valueOf(resourceID)});
            }
            iInfo = dsr.getIndexInfo(resourceID);
            if (iInfo == null) {
                throw HyracksDataException.create((int)83, (Serializable[])new Serializable[]{Long.valueOf(resourceID)});
            }
        }
        finally {
            if (iInfo != null) {
                iInfo.untouch();
            }
            if (dsr != null) {
                dsr.untouch();
            }
        }
    }

    public synchronized List<IIndex> getOpenResources() {
        List<IndexInfo> openIndexesInfo = this.getOpenIndexesInfo();
        ArrayList<IIndex> openIndexes = new ArrayList<IIndex>();
        for (IndexInfo iInfo : openIndexesInfo) {
            openIndexes.add((IIndex)iInfo.getIndex());
        }
        return openIndexes;
    }

    @Override
    public synchronized List<IndexInfo> getOpenIndexesInfo() {
        ArrayList<IndexInfo> openIndexesInfo = new ArrayList<IndexInfo>();
        for (DatasetResource dsr : this.datasets.values()) {
            for (IndexInfo iInfo : dsr.getIndexes().values()) {
                if (!iInfo.isOpen()) continue;
                openIndexesInfo.add(iInfo);
            }
        }
        return openIndexesInfo;
    }

    @Override
    public List<IVirtualBufferCache> getVirtualBufferCaches(int datasetID, int ioDeviceNum) {
        return this.vbcs;
    }

    private void removeDatasetFromCache(int datasetID) throws HyracksDataException {
        this.datasets.remove(datasetID);
    }

    @Override
    public synchronized PrimaryIndexOperationTracker getOperationTracker(int datasetId, int partition, String path) {
        DatasetResource dataset = this.getDatasetLifecycle(datasetId);
        PrimaryIndexOperationTracker opTracker = dataset.getOpTracker(partition);
        if (opTracker == null) {
            this.populateOpTrackerAndIdGenerator(dataset, partition, path);
            opTracker = dataset.getOpTracker(partition);
        }
        return opTracker;
    }

    @Override
    public synchronized ILSMComponentIdGenerator getComponentIdGenerator(int datasetId, int partition, String path) {
        DatasetResource dataset = this.datasets.get(datasetId);
        ILSMComponentIdGenerator generator = dataset.getComponentIdGenerator(partition);
        if (generator == null) {
            this.populateOpTrackerAndIdGenerator(dataset, partition, path);
            generator = dataset.getComponentIdGenerator(partition);
        }
        return generator;
    }

    @Override
    public synchronized boolean isRegistered(int datasetId) {
        return this.datasets.containsKey(datasetId);
    }

    private void populateOpTrackerAndIdGenerator(DatasetResource dataset, int partition, String path) {
        long lastValidId = this.getDatasetLastValidComponentId(path);
        LSMComponentIdGenerator idGenerator = new LSMComponentIdGenerator(this.storageProperties.getMemoryComponentsNum(), lastValidId);
        PrimaryIndexOperationTracker opTracker = new PrimaryIndexOperationTracker(dataset.getDatasetID(), partition, this.logManager, dataset.getDatasetInfo(), (ILSMComponentIdGenerator)idGenerator);
        dataset.setPrimaryIndexOperationTracker(partition, opTracker);
        dataset.setIdGenerator(partition, (ILSMComponentIdGenerator)idGenerator);
    }

    private void validateDatasetLifecycleManagerState() throws HyracksDataException {
        if (this.stopped) {
            throw new HyracksDataException(DatasetLifecycleManager.class.getSimpleName() + " was stopped.");
        }
    }

    public void start() {
    }

    @Override
    public synchronized void flushAllDatasets() throws HyracksDataException {
        for (DatasetResource dsr : this.datasets.values()) {
            if (!dsr.getDatasetInfo().isOpen()) continue;
            this.flushDatasetOpenIndexes(dsr, false);
        }
    }

    @Override
    public synchronized void flushDataset(int datasetId, boolean asyncFlush) throws HyracksDataException {
        DatasetResource dsr = this.datasets.get(datasetId);
        if (dsr != null) {
            this.flushDatasetOpenIndexes(dsr, asyncFlush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void asyncFlushMatchingIndexes(Predicate<ILSMIndex> indexPredicate) throws HyracksDataException {
        for (DatasetResource dsr : this.datasets.values()) {
            Iterator<PrimaryIndexOperationTracker> iterator = dsr.getOpTrackers().iterator();
            while (iterator.hasNext()) {
                PrimaryIndexOperationTracker opTracker;
                PrimaryIndexOperationTracker primaryIndexOperationTracker = opTracker = iterator.next();
                synchronized (primaryIndexOperationTracker) {
                    this.asyncFlush(dsr, opTracker, indexPredicate);
                }
            }
        }
    }

    private void asyncFlush(DatasetResource dsr, PrimaryIndexOperationTracker opTracker, Predicate<ILSMIndex> indexPredicate) throws HyracksDataException {
        int partition = opTracker.getPartition();
        for (ILSMIndex lsmIndex : dsr.getDatasetInfo().getDatasetPartitionOpenIndexes(partition)) {
            LSMIOOperationCallback ioCallback;
            if (!DatasetLifecycleManager.needsFlush(opTracker, lsmIndex, ioCallback = (LSMIOOperationCallback)lsmIndex.getIOOperationCallback()) || !indexPredicate.test(lsmIndex)) continue;
            LOGGER.info("Async flushing {}", (Object)opTracker);
            opTracker.setFlushOnExit(true);
            opTracker.flushIfNeeded();
            break;
        }
    }

    private void flushDatasetOpenIndexes(DatasetResource dsr, boolean asyncFlush) throws HyracksDataException {
        DatasetInfo dsInfo = dsr.getDatasetInfo();
        if (!dsInfo.isOpen()) {
            throw new IllegalStateException("flushDatasetOpenIndexes is called on a dataset that is closed");
        }
        if (dsInfo.isExternal()) {
            return;
        }
        this.logManager.log(this.waitLog);
        for (PrimaryIndexOperationTracker primaryOpTracker : dsr.getOpTrackers()) {
            if (primaryOpTracker.getNumActiveOperations() > 0) {
                throw new IllegalStateException("flushDatasetOpenIndexes is called on a dataset with currently active operations");
            }
            primaryOpTracker.setFlushOnExit(true);
            primaryOpTracker.flushIfNeeded();
        }
        this.logManager.log(this.waitLog);
        if (!asyncFlush) {
            ArrayList<FlushOperation> flushes = new ArrayList<FlushOperation>();
            for (PrimaryIndexOperationTracker primaryOpTracker : dsr.getOpTrackers()) {
                flushes.addAll(primaryOpTracker.getScheduledFlushes());
            }
            LSMIndexUtil.waitFor(flushes);
        }
    }

    private void closeDataset(DatasetResource dsr) throws HyracksDataException {
        DatasetInfo dsInfo = dsr.getDatasetInfo();
        try {
            this.flushDatasetOpenIndexes(dsr, false);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
        dsInfo.waitForIO();
        for (IndexInfo iInfo : dsInfo.getIndexes().values()) {
            this.closeIndex(iInfo);
        }
        this.removeDatasetFromCache(dsInfo.getDatasetID());
        dsInfo.setOpen(false);
    }

    @Override
    public synchronized void closeAllDatasets() throws HyracksDataException {
        ArrayList<DatasetResource> openDatasets = new ArrayList<DatasetResource>(this.datasets.values());
        for (DatasetResource dsr : openDatasets) {
            if (!dsr.isOpen()) continue;
            this.closeDataset(dsr);
        }
    }

    @Override
    public synchronized void closeUserDatasets() throws HyracksDataException {
        ArrayList<DatasetResource> openDatasets = new ArrayList<DatasetResource>(this.datasets.values());
        for (DatasetResource dsr : openDatasets) {
            if (dsr.isMetadataDataset()) continue;
            this.closeDataset(dsr);
        }
    }

    public synchronized void stop(boolean dumpState, OutputStream outputStream) throws IOException {
        if (this.stopped) {
            return;
        }
        if (dumpState) {
            this.dumpState(outputStream);
        }
        this.closeAllDatasets();
        this.datasets.clear();
        this.stopped = true;
    }

    public void dumpState(OutputStream outputStream) throws IOException {
        DatasetInfo dsInfo;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Memory budget = %d%n", this.storageProperties.getMemoryComponentGlobalBudget()));
        long avaialbleMemory = this.storageProperties.getMemoryComponentGlobalBudget() - (long)this.vbc.getUsage() * (long)this.storageProperties.getMemoryComponentPageSize();
        sb.append(String.format("Memory available = %d%n", avaialbleMemory));
        sb.append("\n");
        String dsHeaderFormat = "%-10s %-6s %-16s %-12s\n";
        String dsFormat = "%-10d %-6b %-16d %-12d\n";
        String idxHeaderFormat = "%-10s %-11s %-6s %-16s %-6s\n";
        String idxFormat = "%-10d %-11d %-6b %-16d %-6s\n";
        sb.append("[Datasets]\n");
        sb.append(String.format(dsHeaderFormat, "DatasetID", "Open", "Reference Count", "Last Access"));
        for (DatasetResource dsr : this.datasets.values()) {
            dsInfo = dsr.getDatasetInfo();
            sb.append(String.format(dsFormat, dsInfo.getDatasetID(), dsInfo.isOpen(), dsInfo.getReferenceCount(), dsInfo.getLastAccess()));
        }
        sb.append("\n");
        sb.append("[Indexes]\n");
        sb.append(String.format(idxHeaderFormat, "DatasetID", "ResourceID", "Open", "Reference Count", "Index"));
        for (DatasetResource dsr : this.datasets.values()) {
            dsInfo = dsr.getDatasetInfo();
            dsInfo.getIndexes().forEach((key, iInfo) -> sb.append(String.format(idxFormat, dsInfo.getDatasetID(), key, iInfo.isOpen(), iInfo.getReferenceCount(), iInfo.getIndex())));
        }
        outputStream.write(sb.toString().getBytes());
    }

    @Override
    public void flushDataset(IReplicationStrategy replicationStrategy) throws HyracksDataException {
        for (DatasetResource dsr : this.datasets.values()) {
            if (!dsr.isOpen() || !replicationStrategy.isMatch(dsr.getDatasetID())) continue;
            this.flushDatasetOpenIndexes(dsr, false);
        }
    }

    @Override
    public void waitForIO(IReplicationStrategy replicationStrategy) throws HyracksDataException {
        for (DatasetResource dsr : this.datasets.values()) {
            if (!dsr.isOpen() || !replicationStrategy.isMatch(dsr.getDatasetID())) continue;
            dsr.getDatasetInfo().waitForIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIndex(IndexInfo indexInfo) throws HyracksDataException {
        if (indexInfo.isOpen()) {
            ILSMOperationTracker opTracker;
            ILSMOperationTracker iLSMOperationTracker = opTracker = indexInfo.getIndex().getOperationTracker();
            synchronized (iLSMOperationTracker) {
                indexInfo.getIndex().deactivate(false);
            }
            this.indexCheckpointManagerProvider.close(DatasetResourceReference.of(indexInfo.getLocalResource()));
            indexInfo.setOpen(false);
        }
    }

    private long getDatasetLastValidComponentId(String indexPath) {
        try {
            ResourceReference indexRef = ResourceReference.ofIndex(indexPath);
            ResourceReference primaryIndexRef = indexRef.getDatasetReference();
            IIndexCheckpointManager indexCheckpointManager = this.indexCheckpointManagerProvider.get(primaryIndexRef);
            if (indexCheckpointManager.getCheckpointCount() > 0) {
                return Math.max(indexCheckpointManager.getLatest().getLastComponentId(), 0L);
            }
            return 0L;
        }
        catch (HyracksDataException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean needsFlush(PrimaryIndexOperationTracker opTracker, ILSMIndex lsmIndex, LSMIOOperationCallback ioCallback) throws HyracksDataException {
        return !lsmIndex.isCurrentMutableComponentEmpty() && !ioCallback.hasPendingFlush() && !opTracker.isFlushLogCreated() && !opTracker.isFlushOnExit();
    }
}

