/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.rewriter.base.PhysicalOptimizationConfig;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.control.common.config.OptionTypes;

public class OptimizationConfUtil {
    private static final int MIN_FRAME_LIMIT_FOR_SORT = 3;
    private static final int MIN_FRAME_LIMIT_FOR_GROUP_BY = 4;
    private static final int MIN_FRAME_LIMIT_FOR_JOIN = 5;
    private static final int MIN_FRAME_LIMIT_FOR_WINDOW = 5;
    public static final int MIN_FRAME_LIMIT_FOR_TEXT_SEARCH = 5;

    private OptimizationConfUtil() {
    }

    public static PhysicalOptimizationConfig createPhysicalOptimizationConf(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AlgebricksException {
        int frameSize = compilerProperties.getFrameSize();
        int sortFrameLimit = OptimizationConfUtil.getSortNumFrames(compilerProperties, querySpecificConfig, sourceLoc);
        int groupFrameLimit = OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_GROUPMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_GROUPMEMORY_KEY), compilerProperties.getGroupMemorySize(), frameSize, 4, sourceLoc);
        int joinFrameLimit = OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_JOINMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_JOINMEMORY_KEY), compilerProperties.getJoinMemorySize(), frameSize, 5, sourceLoc);
        int windowFrameLimit = OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_WINDOWMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_WINDOWMEMORY_KEY), compilerProperties.getWindowMemorySize(), frameSize, 5, sourceLoc);
        int textSearchFrameLimit = OptimizationConfUtil.getTextSearchNumFrames(compilerProperties, querySpecificConfig, sourceLoc);
        int sortNumSamples = OptimizationConfUtil.getSortSamples(compilerProperties, querySpecificConfig, sourceLoc);
        boolean fullParallelSort = OptimizationConfUtil.getSortParallel(compilerProperties, querySpecificConfig);
        boolean indexOnly = OptimizationConfUtil.isIndexOnly(compilerProperties, querySpecificConfig);
        PhysicalOptimizationConfig physOptConf = new PhysicalOptimizationConfig();
        physOptConf.setFrameSize(frameSize);
        physOptConf.setMaxFramesExternalSort(sortFrameLimit);
        physOptConf.setMaxFramesExternalGroupBy(groupFrameLimit);
        physOptConf.setMaxFramesForJoin(joinFrameLimit);
        physOptConf.setMaxFramesForWindow(windowFrameLimit);
        physOptConf.setMaxFramesForTextSearch(textSearchFrameLimit);
        physOptConf.setSortParallel(fullParallelSort);
        physOptConf.setSortSamples(sortNumSamples);
        physOptConf.setIndexOnly(indexOnly);
        return physOptConf;
    }

    public static int getSortNumFrames(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AlgebricksException {
        return OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_SORTMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_SORTMEMORY_KEY), compilerProperties.getSortMemorySize(), compilerProperties.getFrameSize(), 3, sourceLoc);
    }

    public static int getTextSearchNumFrames(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AlgebricksException {
        return OptimizationConfUtil.getFrameLimit(CompilerProperties.COMPILER_TEXTSEARCHMEMORY_KEY, (String)querySpecificConfig.get(CompilerProperties.COMPILER_TEXTSEARCHMEMORY_KEY), compilerProperties.getTextSearchMemorySize(), compilerProperties.getFrameSize(), 5, sourceLoc);
    }

    private static int getFrameLimit(String parameterName, String parameter, long memBudgetInConfiguration, int frameSize, int minFrameLimit, SourceLocation sourceLoc) throws AlgebricksException {
        long memBudget;
        IOptionType longBytePropertyInterpreter = OptionTypes.LONG_BYTE_UNIT;
        try {
            memBudget = parameter == null ? memBudgetInConfiguration : (Long)longBytePropertyInterpreter.parse(parameter);
        }
        catch (IllegalArgumentException e) {
            throw AsterixException.create(1079, sourceLoc, new Serializable[]{e.getMessage()});
        }
        int frameLimit = (int)(memBudget / (long)frameSize);
        if (frameLimit < minFrameLimit) {
            throw AsterixException.create(1037, sourceLoc, new Serializable[]{parameterName, Integer.valueOf(frameSize * minFrameLimit), "bytes"});
        }
        return Math.max(frameLimit, minFrameLimit);
    }

    private static boolean getSortParallel(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig) {
        String valueInQuery = (String)querySpecificConfig.get(CompilerProperties.COMPILER_SORT_PARALLEL_KEY);
        if (valueInQuery != null) {
            return (Boolean)OptionTypes.BOOLEAN.parse(valueInQuery);
        }
        return compilerProperties.getSortParallel();
    }

    private static int getSortSamples(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig, SourceLocation sourceLoc) throws AsterixException {
        String valueInQuery = (String)querySpecificConfig.get(CompilerProperties.COMPILER_SORT_SAMPLES_KEY);
        try {
            return valueInQuery == null ? compilerProperties.getSortSamples() : ((Integer)OptionTypes.POSITIVE_INTEGER.parse(valueInQuery)).intValue();
        }
        catch (IllegalArgumentException e) {
            throw AsterixException.create(1037, sourceLoc, new Serializable[]{CompilerProperties.COMPILER_SORT_SAMPLES_KEY, Integer.valueOf(1), "samples"});
        }
    }

    private static boolean isIndexOnly(CompilerProperties compilerProperties, Map<String, Object> querySpecificConfig) {
        String valueInQuery = (String)querySpecificConfig.get(CompilerProperties.COMPILER_INDEXONLY_KEY);
        if (valueInQuery != null) {
            return (Boolean)OptionTypes.BOOLEAN.parse(valueInQuery);
        }
        return compilerProperties.isIndexOnly();
    }
}

