/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IObjectFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.InvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.ArrayListFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.ObjectCache;

public class InvertedListPartitions {
    private final int DEFAULT_NUM_PARTITIONS = 10;
    private final int PARTITIONS_SLACK_SIZE = 10;
    private final int OBJECT_CACHE_INIT_SIZE = 10;
    private final int OBJECT_CACHE_EXPAND_SIZE = 10;
    private final IObjectFactory<ArrayList<InvertedListCursor>> arrayListFactory = new ArrayListFactory<InvertedListCursor>();
    private final ObjectCache<ArrayList<InvertedListCursor>> arrayListCache = new ObjectCache<ArrayList<InvertedListCursor>>(this.arrayListFactory, 10, 10);
    private ArrayList<InvertedListCursor>[] partitions;
    private short minValidPartitionIndex;
    private short maxValidPartitionIndex;

    public void reset(short numTokensLowerBound, short numTokensUpperBound) {
        if (this.partitions == null) {
            int initialSize = numTokensUpperBound < 0 ? 10 : numTokensUpperBound + 1;
            this.partitions = new ArrayList[initialSize];
        } else {
            if (numTokensUpperBound + 1 >= this.partitions.length) {
                this.partitions = Arrays.copyOf(this.partitions, numTokensUpperBound + 1);
            }
            Arrays.fill(this.partitions, null);
        }
        this.arrayListCache.reset();
        this.minValidPartitionIndex = Short.MAX_VALUE;
        this.maxValidPartitionIndex = Short.MIN_VALUE;
    }

    public void addInvertedListCursor(InvertedListCursor listCursor, short numTokens) throws HyracksDataException {
        ArrayList<InvertedListCursor> partitionCursors;
        if (numTokens + 1 >= this.partitions.length) {
            this.partitions = Arrays.copyOf(this.partitions, numTokens + 10);
        }
        if ((partitionCursors = this.partitions[numTokens]) == null) {
            partitionCursors = this.arrayListCache.getNext();
            partitionCursors.clear();
            this.partitions[numTokens] = partitionCursors;
            if (numTokens < this.minValidPartitionIndex) {
                this.minValidPartitionIndex = numTokens;
            }
            if (numTokens > this.maxValidPartitionIndex) {
                this.maxValidPartitionIndex = numTokens;
            }
        }
        partitionCursors.add(listCursor);
    }

    public ArrayList<InvertedListCursor>[] getPartitions() {
        return this.partitions;
    }

    public short getMinValidPartitionIndex() {
        return this.minValidPartitionIndex;
    }

    public short getMaxValidPartitionIndex() {
        return this.maxValidPartitionIndex;
    }
}

