/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.io.RunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.BufferManagerBackedVSizeFrame;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeFrameTupleAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeFrameTupleAppender;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeTupleReference;

public class InvertedIndexSearchResult {
    protected static final int ELEMENT_COUNT_SIZE = 4;
    protected static final int IO_BUFFER_IDX = 0;
    protected static final String FILE_PREFIX = "InvertedIndexSearchResult";
    protected final IHyracksTaskContext ctx;
    protected final FixedSizeFrameTupleAppender appender;
    protected final FixedSizeFrameTupleAccessor accessor;
    protected final FixedSizeTupleReference tuple;
    protected final ISimpleFrameBufferManager bufferManager;
    protected ITypeTraits[] typeTraits;
    protected int invListElementSize;
    protected int currentWriterBufIdx;
    protected int currentReaderBufIdx;
    protected int numResults;
    protected int numPossibleElementPerPage;
    protected IFrame ioBufferFrame = null;
    protected ByteBuffer ioBuffer = null;
    protected ArrayList<ByteBuffer> buffers;
    protected RunFileWriter searchResultWriter;
    protected RunFileReader searchResultReader;
    protected boolean isInMemoryOpMode;
    protected boolean isInReadMode;
    protected boolean isWriteFinished;
    protected boolean isFileOpened;

    public InvertedIndexSearchResult(ITypeTraits[] invListFields, IHyracksTaskContext ctx, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        this.initTypeTraits(invListFields);
        this.ctx = ctx;
        this.appender = new FixedSizeFrameTupleAppender(ctx.getInitialFrameSize(), this.typeTraits);
        this.accessor = new FixedSizeFrameTupleAccessor(ctx.getInitialFrameSize(), this.typeTraits);
        this.tuple = new FixedSizeTupleReference(this.typeTraits);
        this.bufferManager = bufferManager;
        this.isInReadMode = false;
        this.isWriteFinished = false;
        this.isInMemoryOpMode = false;
        this.isFileOpened = false;
        this.ioBufferFrame = null;
        this.ioBuffer = null;
        this.buffers = null;
        this.currentWriterBufIdx = 0;
        this.currentReaderBufIdx = 0;
        this.numResults = 0;
        this.calculateNumElementPerPage();
        this.prepareIOBuffer();
    }

    protected void initTypeTraits(ITypeTraits[] invListFields) {
        this.typeTraits = new ITypeTraits[invListFields.length + 1];
        int tmp = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            this.typeTraits[i] = invListFields[i];
            tmp += invListFields[i].getFixedLength();
        }
        this.invListElementSize = tmp;
        this.typeTraits[invListFields.length] = IntegerPointable.TYPE_TRAITS;
    }

    public void prepareWrite(int numExpectedPages) throws HyracksDataException {
        if (this.isInReadMode || this.isWriteFinished || this.searchResultWriter != null) {
            return;
        }
        this.isInMemoryOpMode = this.tryAllocateBuffers(numExpectedPages);
        if (!this.isInMemoryOpMode) {
            this.createAndOpenFile();
        }
        this.appender.reset(this.ioBuffer);
        this.isWriteFinished = false;
    }

    public boolean append(ITupleReference invListElement, int count) throws HyracksDataException {
        if (!this.appender.hasSpace()) {
            ByteBuffer currentBuffer;
            ++this.currentWriterBufIdx;
            if (this.isInMemoryOpMode) {
                currentBuffer = this.buffers.get(this.currentWriterBufIdx);
            } else {
                this.searchResultWriter.nextFrame(this.ioBuffer);
                currentBuffer = this.ioBuffer;
            }
            this.appender.reset(currentBuffer);
        }
        if (!this.appender.append(invListElement.getFieldData(0), invListElement.getFieldStart(0), this.invListElementSize)) {
            throw HyracksDataException.create((int)112, (Serializable[])new Serializable[0]);
        }
        if (!this.appender.append(count)) {
            throw HyracksDataException.create((int)112, (Serializable[])new Serializable[0]);
        }
        this.appender.incrementTupleCount(1);
        ++this.numResults;
        return true;
    }

    public void finalizeWrite() throws HyracksDataException {
        if (this.isWriteFinished) {
            return;
        }
        if (!this.isInMemoryOpMode && this.searchResultWriter != null) {
            this.searchResultWriter.nextFrame(this.ioBuffer);
            this.searchResultWriter.close();
        }
        this.isWriteFinished = true;
    }

    public void prepareResultRead() throws HyracksDataException {
        if (this.isInReadMode) {
            return;
        }
        if (!this.isInMemoryOpMode && this.searchResultWriter != null) {
            if (!this.isWriteFinished) {
                this.finalizeWrite();
            }
            this.searchResultReader = this.searchResultWriter.createDeleteOnCloseReader();
            this.searchResultReader.open();
            this.searchResultReader.setDeleteAfterClose(true);
        }
        this.currentReaderBufIdx = 0;
        this.isInReadMode = true;
    }

    public ByteBuffer getNextFrame() throws HyracksDataException {
        ByteBuffer returnedBuffer = null;
        if (this.isInMemoryOpMode) {
            returnedBuffer = this.buffers.get(this.currentReaderBufIdx);
            ++this.currentReaderBufIdx;
        } else if (this.searchResultReader != null && this.searchResultReader.nextFrame(this.ioBufferFrame)) {
            returnedBuffer = this.ioBufferFrame.getBuffer();
        }
        return returnedBuffer;
    }

    public void closeResultRead(boolean deallocateIOBufferNeeded) throws HyracksDataException {
        if (this.isInMemoryOpMode) {
            this.deallocateBuffers();
        } else if (this.searchResultReader != null) {
            this.searchResultReader.close();
        }
        if (deallocateIOBufferNeeded) {
            this.deallocateIOBuffer();
        }
    }

    public int getCurrentBufferIndex() {
        return this.currentWriterBufIdx;
    }

    public ITypeTraits[] getTypeTraits() {
        return this.typeTraits;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void close() throws HyracksDataException {
        if (this.isInMemoryOpMode) {
            this.deallocateBuffers();
        } else if (this.searchResultReader != null) {
            this.searchResultReader.close();
        } else if (this.searchResultWriter != null) {
            this.searchResultWriter.erase();
        }
        this.deallocateIOBuffer();
    }

    public void reset() throws HyracksDataException {
        if (this.searchResultReader != null) {
            this.searchResultReader.close();
        } else if (this.searchResultWriter != null) {
            this.searchResultWriter.erase();
        } else if (this.buffers.size() > 1) {
            this.deallocateBuffers();
        }
        this.clearBuffer(this.ioBuffer);
        this.searchResultWriter = null;
        this.searchResultReader = null;
        this.isInReadMode = false;
        this.isWriteFinished = false;
        this.isInMemoryOpMode = false;
        this.isFileOpened = false;
        this.currentWriterBufIdx = 0;
        this.currentReaderBufIdx = 0;
        this.numResults = 0;
    }

    public int getExpectedNumPages(int numExpectedElements) {
        return (int)Math.ceil((double)numExpectedElements / (double)this.numPossibleElementPerPage);
    }

    protected void calculateNumElementPerPage() {
        int frameSize = this.ctx.getInitialFrameSize();
        frameSize = frameSize - 4 - 4;
        this.numPossibleElementPerPage = (int)Math.floor((double)frameSize / (double)(this.invListElementSize + 4));
    }

    protected void prepareIOBuffer() throws HyracksDataException {
        if (this.ioBufferFrame != null) {
            this.clearBuffer(this.ioBuffer);
        } else {
            this.ioBufferFrame = new BufferManagerBackedVSizeFrame((IHyracksFrameMgrContext)this.ctx, this.bufferManager);
            this.ioBuffer = this.ioBufferFrame.getBuffer();
            if (this.ioBuffer == null) {
                throw HyracksDataException.create((int)109, (Serializable[])new Serializable[]{this.getClass().getSimpleName()});
            }
            this.clearBuffer(this.ioBuffer);
            this.buffers = new ArrayList();
            this.buffers.add(this.ioBuffer);
        }
    }

    protected boolean tryAllocateBuffers(int numExpectedPages) throws HyracksDataException {
        boolean allBufferAllocated = true;
        while (this.buffers.size() < numExpectedPages) {
            ByteBuffer tmpBuffer = this.bufferManager.acquireFrame(this.ctx.getInitialFrameSize());
            if (tmpBuffer == null) {
                allBufferAllocated = false;
                break;
            }
            this.clearBuffer(tmpBuffer);
            this.buffers.add(tmpBuffer);
        }
        return allBufferAllocated;
    }

    protected void createAndOpenFile() throws HyracksDataException {
        if (this.isInMemoryOpMode) {
            return;
        }
        if (this.searchResultWriter == null) {
            FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(FILE_PREFIX);
            this.searchResultWriter = new RunFileWriter(file, this.ctx.getIoManager());
            this.searchResultWriter.open();
            this.isFileOpened = true;
        }
    }

    protected void deallocateIOBuffer() throws HyracksDataException {
        if (this.ioBufferFrame != null) {
            this.bufferManager.releaseFrame(this.ioBuffer);
            this.buffers.clear();
            this.ioBufferFrame = null;
            this.ioBuffer = null;
        }
    }

    protected void deallocateBuffers() throws HyracksDataException {
        int toDeleteCount = this.buffers.size() - 1;
        ListIterator<ByteBuffer> iter = this.buffers.listIterator(this.buffers.size());
        for (int deletedCount = 0; iter.hasPrevious() && deletedCount < toDeleteCount; ++deletedCount) {
            ByteBuffer next = iter.previous();
            this.bufferManager.releaseFrame(next);
            iter.remove();
        }
    }

    public FixedSizeFrameTupleAccessor getAccessor() {
        return this.accessor;
    }

    public FixedSizeFrameTupleAppender getAppender() {
        return this.appender;
    }

    public FixedSizeTupleReference getTuple() {
        return this.tuple;
    }

    protected void clearBuffer(ByteBuffer bufferToClear) {
        Arrays.fill(bufferToClear.array(), (byte)0);
        bufferToClear.clear();
    }

    protected void resetAppenderLocation(int bufferIdx) {
        this.accessor.reset(this.buffers.get(bufferIdx));
        this.appender.reset(this.buffers.get(bufferIdx), false, this.accessor.getTupleCount(), this.accessor.getTupleEndOffset(this.accessor.getTupleCount() - 1));
    }
}

