/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchResult;

public class InvertedIndexFinalSearchResult
extends InvertedIndexSearchResult {
    public InvertedIndexFinalSearchResult(ITypeTraits[] invListFields, IHyracksTaskContext ctx, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        super(invListFields, ctx, bufferManager);
    }

    @Override
    protected void initTypeTraits(ITypeTraits[] invListFields) {
        this.typeTraits = new ITypeTraits[invListFields.length];
        int tmp = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            this.typeTraits[i] = invListFields[i];
            tmp += invListFields[i].getFixedLength();
        }
        this.invListElementSize = tmp;
    }

    @Override
    public void prepareWrite(int numExpectedPages) throws HyracksDataException {
        this.isInMemoryOpMode = true;
        this.isFileOpened = false;
        this.resetAppenderLocation(0);
        this.isWriteFinished = false;
    }

    @Override
    public boolean append(ITupleReference invListElement, int count) throws HyracksDataException {
        if (!this.appender.hasSpace()) {
            return false;
        }
        if (!this.appender.append(invListElement.getFieldData(0), invListElement.getFieldStart(0), this.invListElementSize)) {
            throw HyracksDataException.create((int)112, (Serializable[])new Serializable[0]);
        }
        this.appender.incrementTupleCount(1);
        ++this.numResults;
        return true;
    }

    @Override
    public void finalizeWrite() throws HyracksDataException {
        if (this.isWriteFinished) {
            return;
        }
        this.isWriteFinished = true;
    }

    @Override
    public void prepareResultRead() throws HyracksDataException {
        if (this.isInReadMode) {
            return;
        }
        this.currentReaderBufIdx = 0;
        this.isInReadMode = true;
    }

    @Override
    public ByteBuffer getNextFrame() throws HyracksDataException {
        return (ByteBuffer)this.buffers.get(0);
    }

    @Override
    public void closeResultRead(boolean deallocateIOBufferNeeded) throws HyracksDataException {
        if (deallocateIOBufferNeeded) {
            this.deallocateIOBuffer();
        }
    }

    @Override
    public void close() throws HyracksDataException {
        this.deallocateIOBuffer();
    }

    @Override
    public void reset() throws HyracksDataException {
        this.clearBuffer(this.ioBuffer);
        this.searchResultWriter = null;
        this.searchResultReader = null;
        this.isInReadMode = false;
        this.isWriteFinished = false;
        this.isInMemoryOpMode = false;
        this.isFileOpened = false;
        this.currentWriterBufIdx = 0;
        this.currentReaderBufIdx = 0;
        this.numResults = 0;
    }

    @Override
    protected void deallocateIOBuffer() throws HyracksDataException {
        if (this.ioBufferFrame != null) {
            this.bufferManager.releaseFrame(this.ioBuffer);
            this.buffers.clear();
            this.ioBufferFrame = null;
            this.ioBuffer = null;
        }
    }

    public void resetBuffer() {
        this.appender.reset((ByteBuffer)this.buffers.get(0));
    }
}

