/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FixedSizeTupleReference
implements ITupleReference {
    private final ITypeTraits[] typeTraits;
    private final int[] fieldStartOffsets;
    private byte[] data;
    private int startOff;

    public FixedSizeTupleReference(ITypeTraits[] typeTraits) {
        this.typeTraits = typeTraits;
        this.fieldStartOffsets = new int[typeTraits.length];
        this.fieldStartOffsets[0] = 0;
        for (int i = 1; i < typeTraits.length; ++i) {
            this.fieldStartOffsets[i] = this.fieldStartOffsets[i - 1] + typeTraits[i - 1].getFixedLength();
        }
    }

    public void reset(byte[] data, int startOff) {
        this.data = data;
        this.startOff = startOff;
    }

    public int getFieldCount() {
        return this.typeTraits.length;
    }

    public byte[] getFieldData(int fIdx) {
        return this.data;
    }

    public int getFieldLength(int fIdx) {
        return this.typeTraits[fIdx].getFixedLength();
    }

    public int getFieldStart(int fIdx) {
        return this.startOff + this.fieldStartOffsets[fIdx];
    }
}

