/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;

public class FixedSizeFrameTupleAppender {
    public static final int TUPLE_COUNT_SIZE = 4;
    public static final int MINFRAME_COUNT_SIZE = 4;
    private final int frameSize;
    private final int tupleSize;
    private ByteBuffer buffer;
    private int tupleCount;
    private int tupleDataEndOffset;

    public FixedSizeFrameTupleAppender(int frameSize, ITypeTraits[] fields) {
        this.frameSize = frameSize;
        int tmp = 0;
        for (int i = 0; i < fields.length; ++i) {
            tmp += fields[i].getFixedLength();
        }
        this.tupleSize = tmp;
    }

    public void reset(ByteBuffer buffer) {
        this.reset(buffer, true, 0, 4);
    }

    public void reset(ByteBuffer buffer, boolean clear, int tupleCount, int tupleDataEndOffset) {
        this.buffer = buffer;
        if (clear) {
            Arrays.fill(this.buffer.array(), (byte)0);
            this.buffer.clear();
            FrameHelper.serializeFrameSize((ByteBuffer)this.buffer, (int)1);
        }
        this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), tupleCount);
        this.tupleCount = tupleCount;
        this.tupleDataEndOffset = tupleDataEndOffset;
    }

    public boolean append(byte[] bytes, int offset) {
        if (this.tupleDataEndOffset + this.tupleSize + 4 <= this.frameSize) {
            System.arraycopy(bytes, offset, this.buffer.array(), this.tupleDataEndOffset, this.tupleSize);
            this.tupleDataEndOffset += this.tupleSize;
            ++this.tupleCount;
            return true;
        }
        return false;
    }

    public boolean append(byte[] bytes, int offset, int length) {
        if (this.tupleDataEndOffset + length + 4 <= this.frameSize) {
            System.arraycopy(bytes, offset, this.buffer.array(), this.tupleDataEndOffset, length);
            this.tupleDataEndOffset += length;
            return true;
        }
        return false;
    }

    public boolean append(int fieldValue) {
        if (this.tupleDataEndOffset + 4 + 4 <= this.frameSize) {
            this.buffer.putInt(this.tupleDataEndOffset, fieldValue);
            this.tupleDataEndOffset += 4;
            ++this.tupleCount;
            return true;
        }
        return false;
    }

    public boolean append(long fieldValue) {
        if (this.tupleDataEndOffset + 8 + 4 <= this.frameSize) {
            this.buffer.putLong(this.tupleDataEndOffset, fieldValue);
            this.tupleDataEndOffset += 8;
            ++this.tupleCount;
            return true;
        }
        return false;
    }

    public boolean append(char fieldValue) {
        if (this.tupleDataEndOffset + 2 + 4 <= this.frameSize) {
            this.buffer.putLong(this.tupleDataEndOffset, fieldValue);
            this.tupleDataEndOffset += 2;
            ++this.tupleCount;
            return true;
        }
        return false;
    }

    public boolean append(byte fieldValue) {
        if (this.tupleDataEndOffset + 1 + 4 <= this.frameSize) {
            this.buffer.put(this.tupleDataEndOffset, fieldValue);
            ++this.tupleDataEndOffset;
            ++this.tupleCount;
            return true;
        }
        return false;
    }

    public boolean hasSpace() {
        return this.tupleDataEndOffset + this.tupleSize + 4 <= this.frameSize;
    }

    public void incrementTupleCount(int count) {
        this.buffer.putInt(FrameHelper.getTupleCountOffset((int)this.frameSize), this.buffer.getInt(FrameHelper.getTupleCountOffset((int)this.frameSize)) + count);
    }

    public int getTupleCount() {
        return this.tupleCount;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

