/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.literal.LongIntegerLiteral;
import org.apache.asterix.lang.common.literal.NullLiteral;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.optype.SetOpType;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SetOperationVisitor;
import org.apache.asterix.lang.sqlpp.rewrites.visitor.SqlppGroupByVisitor;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppRewriteUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.asterix.om.functions.BuiltinFunctions;

public final class SqlppGroupingSetsVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    private final LangRewritingContext context;
    private final List<List<GbyVariableExpressionPair>> tmpGroupingSets = new ArrayList<List<GbyVariableExpressionPair>>(1);
    private final List<GbyVariableExpressionPair> tmpDecorPairList = new ArrayList<GbyVariableExpressionPair>();
    private final Set<VariableExpr> tmpAllGroupingSetsVars = new LinkedHashSet<VariableExpr>();
    private final Set<VariableExpr> tmpCurrentGroupingSetVars = new LinkedHashSet<VariableExpr>();

    public SqlppGroupingSetsVisitor(LangRewritingContext context) {
        this.context = context;
    }

    @Override
    public Expression visit(SelectSetOperation setOp, ILangExpression arg) throws CompilationException {
        super.visit(setOp, arg);
        SetOperationInput setOpInputLeft = setOp.getLeftInput();
        SelectBlock selectBlockLeft = setOpInputLeft.getSelectBlock();
        if (selectBlockLeft != null && selectBlockLeft.hasGroupbyClause()) {
            setOpInputLeft.setSelectBlock(this.rewriteSelectBlock(selectBlockLeft));
        }
        if (setOp.hasRightInputs()) {
            for (SetOperationRight setOpRight : setOp.getRightInputs()) {
                SetOperationInput setOpInputRight = setOpRight.getSetOperationRightInput();
                SelectBlock selectBlockRight = setOpInputRight.getSelectBlock();
                if (selectBlockRight == null || !selectBlockRight.hasGroupbyClause()) continue;
                setOpInputRight.setSelectBlock(this.rewriteSelectBlock(selectBlockRight));
            }
        }
        return null;
    }

    private SelectBlock rewriteSelectBlock(SelectBlock selectBlock) throws CompilationException {
        return selectBlock.getGroupbyClause().getGbyPairList().size() <= 1 ? this.rewriteZeroOrOneGroupingSet(selectBlock) : this.rewriteMultipleGroupingSets(selectBlock);
    }

    private SelectBlock rewriteZeroOrOneGroupingSet(SelectBlock selectBlock) throws CompilationException {
        GroupbyClause gby = selectBlock.getGroupbyClause();
        List groupingSets = gby.getGbyPairList();
        if (groupingSets.size() > 1) {
            throw new CompilationException(1038, gby.getSourceLocation(), new Serializable[]{""});
        }
        this.tmpAllGroupingSetsVars.clear();
        SqlppGroupingSetsVisitor.getAllGroupingSetsVars(groupingSets, this.tmpAllGroupingSetsVars);
        this.rewriteGroupingOperations(selectBlock, this.tmpAllGroupingSetsVars, this.tmpAllGroupingSetsVars);
        return selectBlock;
    }

    private SelectBlock rewriteMultipleGroupingSets(SelectBlock selectBlock) throws CompilationException {
        GroupbyClause gby = selectBlock.getGroupbyClause();
        List groupingSets = gby.getGbyPairList();
        if (groupingSets.size() <= 1 || !gby.getDecorPairList().isEmpty()) {
            throw new CompilationException(1038, gby.getSourceLocation(), new Serializable[]{""});
        }
        this.tmpAllGroupingSetsVars.clear();
        SqlppGroupingSetsVisitor.getAllGroupingSetsVars(groupingSets, this.tmpAllGroupingSetsVars);
        int nGroupingSets = groupingSets.size();
        ArrayList<SetOperationRight> newSetOpRightInputs = new ArrayList<SetOperationRight>(nGroupingSets - 1);
        for (int i = 1; i < nGroupingSets; ++i) {
            List groupingSet = (List)groupingSets.get(i);
            this.tmpCurrentGroupingSetVars.clear();
            SqlppGroupingSetsVisitor.getGroupingSetVars(groupingSet, this.tmpCurrentGroupingSetVars);
            this.tmpGroupingSets.clear();
            this.tmpGroupingSets.add(groupingSet);
            gby.setGbyPairList(this.tmpGroupingSets);
            this.tmpDecorPairList.clear();
            SqlppGroupingSetsVisitor.computeDecorVars(this.tmpAllGroupingSetsVars, this.tmpCurrentGroupingSetVars, this.tmpDecorPairList);
            gby.setDecorPairList(this.tmpDecorPairList);
            SelectBlock newSelectBlock = (SelectBlock)SqlppRewriteUtil.deepCopy((ILangExpression)selectBlock);
            this.rewriteGroupingOperations(newSelectBlock, this.tmpAllGroupingSetsVars, this.tmpCurrentGroupingSetVars);
            SetOperationRight newSetOpRight = new SetOperationRight(SetOpType.UNION, false, new SetOperationInput(newSelectBlock, null));
            newSetOpRightInputs.add(newSetOpRight);
        }
        List groupingSet = (List)groupingSets.get(0);
        gby.setGbyPairList(Collections.singletonList(groupingSet));
        this.tmpCurrentGroupingSetVars.clear();
        SqlppGroupingSetsVisitor.getGroupingSetVars(groupingSet, this.tmpCurrentGroupingSetVars);
        ArrayList<GbyVariableExpressionPair> newDecorPairList = new ArrayList<GbyVariableExpressionPair>();
        SqlppGroupingSetsVisitor.computeDecorVars(this.tmpAllGroupingSetsVars, this.tmpCurrentGroupingSetVars, newDecorPairList);
        gby.setDecorPairList(newDecorPairList);
        this.rewriteGroupingOperations(selectBlock, this.tmpAllGroupingSetsVars, this.tmpCurrentGroupingSetVars);
        SetOperationInput newSetOpInput = new SetOperationInput(selectBlock, null);
        SelectSetOperation newSetOp = new SelectSetOperation(newSetOpInput, newSetOpRightInputs);
        newSetOp.setSourceLocation(selectBlock.getSourceLocation());
        SelectExpression newSelectExpr = new SelectExpression(null, newSetOp, null, null, true);
        newSelectExpr.setSourceLocation(selectBlock.getSourceLocation());
        return SetOperationVisitor.createSelectBlock((Expression)newSelectExpr, this.context);
    }

    private void rewriteGroupingOperations(SelectBlock selectBlock, Set<VariableExpr> allGroupingSetsVars, Set<VariableExpr> currentGroupingSetVars) throws CompilationException {
        if (selectBlock.hasLetHavingClausesAfterGroupby()) {
            for (Clause clause : selectBlock.getLetHavingListAfterGroupby()) {
                LetClause letClause;
                Expression letExpr;
                if (clause.getClauseType() != Clause.ClauseType.LET_CLAUSE || !SqlppGroupByVisitor.isGroupingOperation(letExpr = (letClause = (LetClause)clause).getBindingExpr())) continue;
                Expression newLetExpr = this.rewriteGroupingOperation((CallExpr)letExpr, allGroupingSetsVars, currentGroupingSetVars);
                letClause.setBindingExpr(newLetExpr);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression rewriteGroupingOperation(CallExpr callExpr, Set<VariableExpr> allGroupingSetsVars, Set<VariableExpr> currentGroupingSetVars) throws CompilationException {
        List argList = callExpr.getExprList();
        if (argList.isEmpty()) {
            throw new CompilationException(1087, callExpr.getSourceLocation(), new Serializable[]{BuiltinFunctions.GROUPING.getName()});
        }
        if (callExpr.hasAggregateFilterExpr()) {
            throw new CompilationException(1121, callExpr.getSourceLocation(), new Serializable[0]);
        }
        long result = 0L;
        for (Expression argExpr : argList) {
            int v;
            if (argExpr.getKind() != Expression.Kind.VARIABLE_EXPRESSION) throw new CompilationException(1119, argExpr.getSourceLocation(), new Serializable[0]);
            VariableExpr varExpr = (VariableExpr)argExpr;
            if (currentGroupingSetVars.contains(varExpr)) {
                v = 0;
            } else {
                if (!allGroupingSetsVars.contains(varExpr)) throw new CompilationException(1119, argExpr.getSourceLocation(), new Serializable[0]);
                v = 1;
            }
            result = (result << 1) + (long)v;
        }
        LiteralExpr resultExpr = new LiteralExpr((Literal)new LongIntegerLiteral(Long.valueOf(result)));
        resultExpr.setSourceLocation(callExpr.getSourceLocation());
        return resultExpr;
    }

    private static void getAllGroupingSetsVars(List<List<GbyVariableExpressionPair>> gbyList, Set<VariableExpr> outVars) {
        for (List<GbyVariableExpressionPair> gbyPairList : gbyList) {
            SqlppGroupingSetsVisitor.getGroupingSetVars(gbyPairList, outVars);
        }
    }

    private static void getGroupingSetVars(List<GbyVariableExpressionPair> groupingSet, Collection<VariableExpr> outVars) {
        for (GbyVariableExpressionPair gbyPair : groupingSet) {
            outVars.add(gbyPair.getVar());
        }
    }

    private static void computeDecorVars(Set<VariableExpr> allGroupingSetsVars, Set<VariableExpr> currentGroupingSetVars, List<GbyVariableExpressionPair> outDecorPairList) {
        for (VariableExpr var : allGroupingSetsVars) {
            if (currentGroupingSetVars.contains(var)) continue;
            LiteralExpr nullExpr = new LiteralExpr((Literal)NullLiteral.INSTANCE);
            nullExpr.setSourceLocation(var.getSourceLocation());
            VariableExpr newDecorVarExpr = new VariableExpr(var.getVar());
            newDecorVarExpr.setSourceLocation(var.getSourceLocation());
            outDecorPairList.add(new GbyVariableExpressionPair(newDecorVarExpr, (Expression)nullExpr));
        }
    }
}

